/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Transfer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.GHResponse;
import com.graphhopper.PathWrapper;
import com.graphhopper.Trip;
import com.graphhopper.http.WebHelper;
import com.graphhopper.reader.gtfs.EmptyLocationIndex;
import com.graphhopper.reader.gtfs.GHLocation;
import com.graphhopper.reader.gtfs.GHPointLocation;
import com.graphhopper.reader.gtfs.GHStationLocation;
import com.graphhopper.reader.gtfs.GraphExplorer;
import com.graphhopper.reader.gtfs.GraphSupport;
import com.graphhopper.reader.gtfs.GtfsReader;
import com.graphhopper.reader.gtfs.GtfsStorage;
import com.graphhopper.reader.gtfs.Label;
import com.graphhopper.reader.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.reader.gtfs.PtFlagEncoder;
import com.graphhopper.reader.gtfs.RealtimeFeed;
import com.graphhopper.reader.gtfs.Request;
import com.graphhopper.reader.gtfs.TripFromLabel;
import com.graphhopper.reader.gtfs.WrapperGraph;
import com.graphhopper.reader.osm.OSMReader;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.VirtualEdgeIteratorState;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="route")
public final class GraphHopperGtfs {
    private final TranslationMap translationMap;
    private final PtFlagEncoder flagEncoder;
    private final Weighting accessEgressWeighting;
    private final GraphHopperStorage graphHopperStorage;
    private final LocationIndex locationIndex;
    private final GtfsStorage gtfsStorage;
    private final RealtimeFeed realtimeFeed;
    private final TripFromLabel tripFromLabel;

    public static Factory createFactory(PtFlagEncoder flagEncoder, TranslationMap translationMap, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex, GtfsStorage gtfsStorage) {
        return new Factory(flagEncoder, translationMap, graphHopperStorage, locationIndex, gtfsStorage);
    }

    @Inject
    public GraphHopperGtfs(PtFlagEncoder flagEncoder, TranslationMap translationMap, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex, GtfsStorage gtfsStorage, RealtimeFeed realtimeFeed) {
        this.flagEncoder = flagEncoder;
        this.accessEgressWeighting = new FastestWeighting(graphHopperStorage.getEncodingManager().getEncoder("foot"));
        this.translationMap = translationMap;
        this.graphHopperStorage = graphHopperStorage;
        this.locationIndex = locationIndex;
        this.gtfsStorage = gtfsStorage;
        this.realtimeFeed = realtimeFeed;
        this.tripFromLabel = new TripFromLabel(this.gtfsStorage, this.realtimeFeed);
    }

    public static GtfsStorage createGtfsStorage() {
        return new GtfsStorage();
    }

    public static GHDirectory createGHDirectory(String graphHopperFolder) {
        return new GHDirectory(graphHopperFolder, DAType.RAM_STORE);
    }

    public static TranslationMap createTranslationMap() {
        return new TranslationMap().doImport();
    }

    /*
     * WARNING - void declaration
     */
    public static GraphHopperStorage createOrLoad(GHDirectory directory, EncodingManager encodingManager, PtFlagEncoder ptFlagEncoder, GtfsStorage gtfsStorage, Collection<String> gtfsFiles, Collection<String> osmFiles) {
        void var8_13;
        GraphHopperStorage graphHopperStorage = new GraphHopperStorage(directory, encodingManager, false, gtfsStorage);
        if (graphHopperStorage.loadExisting()) {
            return graphHopperStorage;
        }
        graphHopperStorage.create(1000L);
        for (String string : osmFiles) {
            OSMReader osmReader = new OSMReader(graphHopperStorage);
            osmReader.setFile(new File(string));
            osmReader.setCreateStorage(false);
            try {
                osmReader.readGraph();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        new PrepareRoutingSubnetworks(graphHopperStorage, Collections.singletonList(encodingManager.getEncoder("foot"))).doWork();
        int id = 0;
        for (String gtfsFile : gtfsFiles) {
            try {
                ((GtfsStorage)graphHopperStorage.getExtension()).loadGtfsFromFile("gtfs_" + id++, new ZipFile(gtfsFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (graphHopperStorage.getNodes() > 0) {
            LocationIndex locationIndex = new LocationIndexTree(graphHopperStorage, new RAMDirectory()).prepareIndex();
        } else {
            EmptyLocationIndex emptyLocationIndex = new EmptyLocationIndex();
        }
        GraphHopperGtfs graphHopperGtfs = new GraphHopperGtfs(ptFlagEncoder, GraphHopperGtfs.createTranslationMap(), graphHopperStorage, (LocationIndex)var8_13, gtfsStorage, RealtimeFeed.empty(gtfsStorage));
        for (int i = 0; i < id; ++i) {
            GTFSFeed gtfsFeed = gtfsStorage.getGtfsFeeds().get("gtfs_" + i);
            GtfsReader gtfsReader = new GtfsReader("gtfs_" + i, graphHopperStorage, gtfsStorage, ptFlagEncoder, (LocationIndex)var8_13);
            gtfsReader.connectStopsToStreetNetwork();
            graphHopperGtfs.getType0TransferWithTimes(gtfsFeed).forEach(t -> {
                t.transfer.transfer_type = 2;
                t.transfer.min_transfer_time = (int)(t.time / 1000L);
                gtfsFeed.transfers.put(t.id, t.transfer);
            });
            try {
                gtfsReader.buildPtNetwork();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while constructing transit network. Is your GTFS file valid? Please check log for possible causes.", e);
            }
        }
        graphHopperStorage.flush();
        return graphHopperStorage;
    }

    public static LocationIndex createOrLoadIndex(GHDirectory directory, GraphHopperStorage graphHopperStorage) {
        DefaultEdgeFilter filter = DefaultEdgeFilter.allEdges(graphHopperStorage.getEncodingManager().getEncoder("foot"));
        Graph walkNetwork = GraphSupport.filteredView(graphHopperStorage, filter);
        LocationIndexTree locationIndex = new LocationIndexTree(walkNetwork, directory);
        if (!locationIndex.loadExisting()) {
            locationIndex.prepareIndex();
        }
        return locationIndex;
    }

    @GET
    @Produces(value={"application/json"})
    public ObjectNode route(@QueryParam(value="point") List<GHLocation> requestPoints, @QueryParam(value="pt.earliest_departure_time") String departureTimeString, @QueryParam(value="locale") String localeStr, @QueryParam(value="pt.ignore_transfers") Boolean ignoreTransfers, @QueryParam(value="pt.profile") Boolean profileQuery, @QueryParam(value="pt.limit_solutions") Integer limitSolutions) {
        Instant departureTime;
        if (departureTimeString == null) {
            throw new BadRequestException(String.format(Locale.ROOT, "Illegal value for required parameter %s: [%s]", "pt.earliest_departure_time", departureTimeString));
        }
        try {
            departureTime = Instant.parse(departureTimeString);
        }
        catch (DateTimeParseException e) {
            throw new BadRequestException(String.format(Locale.ROOT, "Illegal value for required parameter %s: [%s]", "pt.earliest_departure_time", departureTimeString));
        }
        Request request = new Request(requestPoints, departureTime);
        Optional.ofNullable(profileQuery).ifPresent(request::setProfileQuery);
        Optional.ofNullable(ignoreTransfers).ifPresent(request::setIgnoreTransfers);
        Optional.ofNullable(localeStr).ifPresent(s -> request.setLocale(Helper.getLocale(s)));
        Optional.ofNullable(limitSolutions).ifPresent(request::setLimitSolutions);
        GHResponse route = new RequestHandler(request).route();
        return WebHelper.jsonObject(route, true, true, false, false, 0.0f);
    }

    public GHResponse route(Request request) {
        return new RequestHandler(request).route();
    }

    private Stream<TransferWithTime> getType0TransferWithTimes(GTFSFeed gtfsFeed) {
        return gtfsFeed.transfers.entrySet().parallelStream().filter(e -> ((Transfer)e.getValue()).transfer_type == 0).map(e -> {
            PointList points = new PointList(2, false);
            int fromnode = this.gtfsStorage.getStationNodes().get(((Transfer)e.getValue()).from_stop_id);
            QueryResult fromstation = new QueryResult(this.graphHopperStorage.getNodeAccess().getLat(fromnode), this.graphHopperStorage.getNodeAccess().getLon(fromnode));
            fromstation.setClosestNode(fromnode);
            points.add(this.graphHopperStorage.getNodeAccess().getLat(fromnode), this.graphHopperStorage.getNodeAccess().getLon(fromnode));
            int tonode = this.gtfsStorage.getStationNodes().get(((Transfer)e.getValue()).to_stop_id);
            QueryResult tostation = new QueryResult(this.graphHopperStorage.getNodeAccess().getLat(tonode), this.graphHopperStorage.getNodeAccess().getLon(tonode));
            tostation.setClosestNode(tonode);
            points.add(this.graphHopperStorage.getNodeAccess().getLat(tonode), this.graphHopperStorage.getNodeAccess().getLon(tonode));
            QueryGraph queryGraph = new QueryGraph(this.graphHopperStorage);
            queryGraph.lookup(Collections.emptyList());
            GraphExplorer graphExplorer = new GraphExplorer(queryGraph, this.accessEgressWeighting, this.flagEncoder, this.gtfsStorage, this.realtimeFeed, false, true, 5.0);
            MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, this.flagEncoder, false, Double.MAX_VALUE, false, false, false, Integer.MAX_VALUE, new ArrayList<Label>());
            Iterator iterator = router.calcLabels(fromnode, tonode, Instant.ofEpochMilli(0L), 0).iterator();
            Label solution = null;
            while (iterator.hasNext()) {
                Label label = (Label)iterator.next();
                if (tonode != label.adjNode) continue;
                solution = label;
                break;
            }
            if (solution == null) {
                throw new RuntimeException("Can't find a transfer walk route.");
            }
            TransferWithTime transferWithTime = new TransferWithTime();
            transferWithTime.id = (String)e.getKey();
            transferWithTime.transfer = (Transfer)e.getValue();
            transferWithTime.time = solution.currentTime;
            return transferWithTime;
        });
    }

    private class TransferWithTime {
        public String id;
        Transfer transfer;
        long time;

        private TransferWithTime() {
        }
    }

    private class RequestHandler {
        private final int maxVisitedNodesForRequest;
        private final int limitSolutions;
        private final Instant initialTime;
        private final boolean profileQuery;
        private final boolean arriveBy;
        private final boolean ignoreTransfers;
        private final double betaTransfers;
        private final double betaWalkTime;
        private final double walkSpeedKmH;
        private final double maxWalkDistancePerLeg;
        private final int blockedRouteTypes;
        private final GHLocation enter;
        private final GHLocation exit;
        private final Translation translation;
        private final List<VirtualEdgeIteratorState> extraEdges;
        private final GHResponse response;
        private final Graph graphWithExtraEdges;
        private QueryGraph queryGraph;
        private GraphExplorer graphExplorer;
        private int visitedNodes;

        RequestHandler(Request request) {
            this.extraEdges = new ArrayList<VirtualEdgeIteratorState>(GraphHopperGtfs.this.realtimeFeed.getAdditionalEdges());
            this.response = new GHResponse();
            this.graphWithExtraEdges = new WrapperGraph(GraphHopperGtfs.this.graphHopperStorage, this.extraEdges);
            this.queryGraph = new QueryGraph(this.graphWithExtraEdges);
            this.maxVisitedNodesForRequest = request.getMaxVisitedNodes();
            this.profileQuery = request.isProfileQuery();
            this.ignoreTransfers = Optional.ofNullable(request.getIgnoreTransfers()).orElse(request.isProfileQuery());
            this.betaTransfers = request.getBetaTransfers();
            this.betaWalkTime = request.getBetaWalkTime();
            this.limitSolutions = Optional.ofNullable(request.getLimitSolutions()).orElse(this.profileQuery ? 5 : (this.ignoreTransfers ? 1 : Integer.MAX_VALUE));
            this.initialTime = request.getEarliestDepartureTime();
            this.arriveBy = request.isArriveBy();
            this.walkSpeedKmH = request.getWalkSpeedKmH();
            this.blockedRouteTypes = request.getBlockedRouteTypes();
            this.translation = GraphHopperGtfs.this.translationMap.getWithFallBack(request.getLocale());
            if (request.getPoints().size() != 2) {
                throw new IllegalArgumentException("Exactly 2 points have to be specified, but was:" + request.getPoints().size());
            }
            this.enter = request.getPoints().get(0);
            this.exit = request.getPoints().get(1);
            this.maxWalkDistancePerLeg = request.getMaxWalkDistancePerLeg();
        }

        GHResponse route() {
            int destNode;
            int startNode;
            QueryResult station;
            int node;
            String stop_id;
            QueryResult closest;
            StopWatch stopWatch = new StopWatch().start();
            ArrayList<QueryResult> pointQueryResults = new ArrayList<QueryResult>();
            ArrayList<QueryResult> allQueryResults = new ArrayList<QueryResult>();
            PointList points = new PointList(2, false);
            if (this.enter instanceof GHPointLocation) {
                closest = this.findClosest(((GHPointLocation)this.enter).ghPoint, 0);
                pointQueryResults.add(closest);
                allQueryResults.add(closest);
                points.add(closest.getSnappedPoint());
            } else if (this.enter instanceof GHStationLocation) {
                stop_id = ((GHStationLocation)this.enter).stop_id;
                node = GraphHopperGtfs.this.gtfsStorage.getStationNodes().get(stop_id);
                station = new QueryResult(GraphHopperGtfs.this.graphHopperStorage.getNodeAccess().getLat(node), GraphHopperGtfs.this.graphHopperStorage.getNodeAccess().getLon(node));
                station.setClosestNode(node);
                allQueryResults.add(station);
                points.add(GraphHopperGtfs.this.graphHopperStorage.getNodeAccess().getLat(node), GraphHopperGtfs.this.graphHopperStorage.getNodeAccess().getLon(node));
            }
            if (this.exit instanceof GHPointLocation) {
                closest = this.findClosest(((GHPointLocation)this.exit).ghPoint, 1);
                pointQueryResults.add(closest);
                allQueryResults.add(closest);
                points.add(closest.getSnappedPoint());
            } else if (this.exit instanceof GHStationLocation) {
                stop_id = ((GHStationLocation)this.exit).stop_id;
                node = GraphHopperGtfs.this.gtfsStorage.getStationNodes().get(stop_id);
                station = new QueryResult(GraphHopperGtfs.this.graphHopperStorage.getNodeAccess().getLat(node), GraphHopperGtfs.this.graphHopperStorage.getNodeAccess().getLon(node));
                station.setClosestNode(node);
                allQueryResults.add(station);
                points.add(GraphHopperGtfs.this.graphHopperStorage.getNodeAccess().getLat(node), GraphHopperGtfs.this.graphHopperStorage.getNodeAccess().getLon(node));
            }
            this.queryGraph.lookup(pointQueryResults);
            this.response.addDebugInfo("idLookup:" + stopWatch.stop().getSeconds() + "s");
            if (this.arriveBy) {
                startNode = ((QueryResult)allQueryResults.get(1)).getClosestNode();
                destNode = ((QueryResult)allQueryResults.get(0)).getClosestNode();
            } else {
                startNode = ((QueryResult)allQueryResults.get(0)).getClosestNode();
                destNode = ((QueryResult)allQueryResults.get(1)).getClosestNode();
            }
            List<List<Label.Transition>> solutions = this.findPaths(startNode, destNode);
            this.parseSolutionsAndAddToResponse(solutions, points);
            return this.response;
        }

        private QueryResult findClosest(GHPoint point, int indexForErrorMessage) {
            DefaultEdgeFilter filter = DefaultEdgeFilter.allEdges(GraphHopperGtfs.this.graphHopperStorage.getEncodingManager().getEncoder("foot"));
            QueryResult source = GraphHopperGtfs.this.locationIndex.findClosest(point.lat, point.lon, filter);
            if (!source.isValid()) {
                throw new PointNotFoundException("Cannot find point: " + point, indexForErrorMessage);
            }
            if (source.getClosestEdge().get(GraphHopperGtfs.this.flagEncoder.getTypeEnc()) != GtfsStorage.EdgeType.HIGHWAY) {
                throw new RuntimeException(source.getClosestEdge().get(GraphHopperGtfs.this.flagEncoder.getTypeEnc()).name());
            }
            return source;
        }

        private void parseSolutionsAndAddToResponse(List<List<Label.Transition>> solutions, PointList waypoints) {
            for (List<Label.Transition> solution : solutions) {
                List<Trip.Leg> legs = GraphHopperGtfs.this.tripFromLabel.getTrip(this.translation, this.queryGraph, GraphHopperGtfs.this.accessEgressWeighting, solution);
                PathWrapper pathWrapper = GraphHopperGtfs.this.tripFromLabel.createPathWrapper(this.translation, waypoints, legs);
                pathWrapper.setImpossible(solution.stream().anyMatch(t -> t.label.impossible));
                pathWrapper.setTime(solution.get((int)(solution.size() - 1)).label.currentTime - solution.get((int)0).label.currentTime);
                this.response.add(pathWrapper);
            }
            Comparator<PathWrapper> c = Comparator.comparingInt(p -> p.isImpossible() ? 1 : 0);
            Comparator<PathWrapper> d = Comparator.comparingDouble(PathWrapper::getTime);
            this.response.getAll().sort(c.thenComparing(d));
        }

        private List<List<Label.Transition>> findPaths(int startNode, int destNode) {
            StopWatch stopWatch = new StopWatch().start();
            GraphExplorer accessEgressGraphExplorer = new GraphExplorer(this.queryGraph, GraphHopperGtfs.this.accessEgressWeighting, GraphHopperGtfs.this.flagEncoder, GraphHopperGtfs.this.gtfsStorage, GraphHopperGtfs.this.realtimeFeed, !this.arriveBy, true, this.walkSpeedKmH);
            boolean reverse = !this.arriveBy;
            GtfsStorage.EdgeType edgeType = reverse ? GtfsStorage.EdgeType.EXIT_PT : GtfsStorage.EdgeType.ENTER_PT;
            MultiCriteriaLabelSetting stationRouter = new MultiCriteriaLabelSetting(accessEgressGraphExplorer, GraphHopperGtfs.this.flagEncoder, reverse, this.maxWalkDistancePerLeg, false, false, false, this.maxVisitedNodesForRequest, new ArrayList<Label>());
            stationRouter.setBetaWalkTime(this.betaWalkTime);
            Iterator stationIterator = stationRouter.calcLabels(destNode, startNode, this.initialTime, this.blockedRouteTypes).iterator();
            ArrayList<Label> stationLabels = new ArrayList<Label>();
            while (stationIterator.hasNext()) {
                Label label = (Label)stationIterator.next();
                if (label.adjNode == startNode) {
                    stationLabels.add(label);
                    break;
                }
                if (label.edge == -1 || this.queryGraph.getEdgeIteratorState(label.edge, label.parent.adjNode).get(GraphHopperGtfs.this.flagEncoder.getTypeEnc()) != edgeType) continue;
                stationLabels.add(label);
            }
            this.visitedNodes += stationRouter.getVisitedNodes();
            HashMap<Integer, Label> reverseSettledSet = new HashMap<Integer, Label>();
            for (Label stationLabel : stationLabels) {
                reverseSettledSet.put(stationLabel.adjNode, stationLabel);
            }
            this.graphExplorer = new GraphExplorer(this.queryGraph, GraphHopperGtfs.this.accessEgressWeighting, GraphHopperGtfs.this.flagEncoder, GraphHopperGtfs.this.gtfsStorage, GraphHopperGtfs.this.realtimeFeed, this.arriveBy, false, this.walkSpeedKmH);
            ArrayList<Label> discoveredSolutions = new ArrayList<Label>();
            MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(this.graphExplorer, GraphHopperGtfs.this.flagEncoder, this.arriveBy, this.maxWalkDistancePerLeg, true, !this.ignoreTransfers, this.profileQuery, this.maxVisitedNodesForRequest, discoveredSolutions);
            router.setBetaTransfers(this.betaTransfers);
            router.setBetaWalkTime(this.betaWalkTime);
            long smallestStationLabelWeight = !stationLabels.isEmpty() ? stationRouter.weight((Label)stationLabels.get(0)) : Long.MAX_VALUE;
            Iterator iterator = router.calcLabels(startNode, destNode, this.initialTime, this.blockedRouteTypes).iterator();
            HashMap<Label, Label> originalSolutions = new HashMap<Label, Label>();
            long highestWeightForDominationTest = Long.MAX_VALUE;
            while (iterator.hasNext()) {
                Label combinedSolution;
                Label label = (Label)iterator.next();
                long weight = router.weight(label);
                if ((!this.profileQuery || discoveredSolutions.size() >= this.limitSolutions) && weight + smallestStationLabelWeight > highestWeightForDominationTest) break;
                Label reverseLabel = (Label)reverseSettledSet.get(label.adjNode);
                if (reverseLabel == null || !router.isNotDominatedByAnyOf(combinedSolution = new Label(label.currentTime - reverseLabel.currentTime + this.initialTime.toEpochMilli(), -1, label.adjNode, label.nTransfers + reverseLabel.nTransfers, label.nWalkDistanceConstraintViolations + reverseLabel.nWalkDistanceConstraintViolations, label.walkDistanceOnCurrentLeg + reverseLabel.walkDistanceOnCurrentLeg, label.departureTime, label.walkTime + reverseLabel.walkTime, 0L, label.impossible, null), discoveredSolutions)) continue;
                router.removeDominated(combinedSolution, discoveredSolutions);
                if (discoveredSolutions.size() >= this.limitSolutions) continue;
                discoveredSolutions.add(combinedSolution);
                originalSolutions.put(combinedSolution, label);
                if (this.profileQuery) {
                    highestWeightForDominationTest = router.weight((Label)discoveredSolutions.get(discoveredSolutions.size() - 1));
                    continue;
                }
                highestWeightForDominationTest = discoveredSolutions.stream().filter(s -> !s.impossible && (this.ignoreTransfers || s.nTransfers <= 1)).mapToLong(router::weight).min().orElse(Long.MAX_VALUE);
            }
            List pathsToStations = discoveredSolutions.stream().map(originalSolutions::get).map(l -> GraphHopperGtfs.this.tripFromLabel.getTransitions(this.arriveBy, GraphHopperGtfs.this.flagEncoder, this.queryGraph, (Label)l)).collect(Collectors.toList());
            List<List<Label.Transition>> paths = pathsToStations.stream().map(p -> {
                if (this.arriveBy) {
                    ArrayList pp = new ArrayList(p.subList(1, p.size()));
                    List<Label.Transition> pathFromStation = this.pathFromStation((Label)reverseSettledSet.get(((Label.Transition)p.get((int)0)).label.adjNode));
                    long diff = ((Label.Transition)p.get((int)0)).label.currentTime - pathFromStation.get((int)(pathFromStation.size() - 1)).label.currentTime;
                    List patchedPathFromStation = pathFromStation.stream().map(t -> new Label.Transition(new Label(t.label.currentTime + diff, t.label.edge, t.label.adjNode, t.label.nTransfers, t.label.nWalkDistanceConstraintViolations, t.label.walkDistanceOnCurrentLeg, t.label.departureTime, t.label.walkTime, t.label.residualDelay, t.label.impossible, null), t.edge)).collect(Collectors.toList());
                    pp.addAll(0, patchedPathFromStation);
                    return pp;
                }
                ArrayList pp = new ArrayList(p);
                List<Label.Transition> pathFromStation = this.pathFromStation((Label)reverseSettledSet.get(((Label.Transition)p.get((int)(p.size() - 1))).label.adjNode));
                long diff = ((Label.Transition)p.get((int)(p.size() - 1))).label.currentTime - pathFromStation.get((int)0).label.currentTime;
                List patchedPathFromStation = pathFromStation.subList(1, pathFromStation.size()).stream().map(t -> new Label.Transition(new Label(t.label.currentTime + diff, t.label.edge, t.label.adjNode, t.label.nTransfers, t.label.nWalkDistanceConstraintViolations, t.label.walkDistanceOnCurrentLeg, t.label.departureTime, t.label.walkTime, t.label.residualDelay, t.label.impossible, null), t.edge)).collect(Collectors.toList());
                pp.addAll(patchedPathFromStation);
                return pp;
            }).collect(Collectors.toList());
            this.visitedNodes += router.getVisitedNodes();
            this.response.addDebugInfo("routing:" + stopWatch.stop().getSeconds() + "s");
            if (discoveredSolutions.isEmpty() && router.getVisitedNodes() >= this.maxVisitedNodesForRequest) {
                this.response.addError(new IllegalArgumentException("No path found - maximum number of nodes exceeded: " + this.maxVisitedNodesForRequest));
            }
            this.response.getHints().put("visited_nodes.sum", this.visitedNodes);
            this.response.getHints().put("visited_nodes.average", this.visitedNodes);
            if (discoveredSolutions.isEmpty()) {
                this.response.addError(new RuntimeException("No route found"));
            }
            return paths;
        }

        private List<Label.Transition> pathFromStation(Label l) {
            return GraphHopperGtfs.this.tripFromLabel.getTransitions(!this.arriveBy, GraphHopperGtfs.this.flagEncoder, this.queryGraph, l);
        }
    }

    public static class Factory {
        private final TranslationMap translationMap;
        private final PtFlagEncoder flagEncoder;
        private final GraphHopperStorage graphHopperStorage;
        private final LocationIndex locationIndex;
        private final GtfsStorage gtfsStorage;

        private Factory(PtFlagEncoder flagEncoder, TranslationMap translationMap, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex, GtfsStorage gtfsStorage) {
            this.flagEncoder = flagEncoder;
            this.translationMap = translationMap;
            this.graphHopperStorage = graphHopperStorage;
            this.locationIndex = locationIndex;
            this.gtfsStorage = gtfsStorage;
        }

        public GraphHopperGtfs createWith(GtfsRealtime.FeedMessage realtimeFeed) {
            HashMap<String, GtfsRealtime.FeedMessage> realtimeFeeds = new HashMap<String, GtfsRealtime.FeedMessage>();
            realtimeFeeds.put("gtfs_0", realtimeFeed);
            return new GraphHopperGtfs(this.flagEncoder, this.translationMap, this.graphHopperStorage, this.locationIndex, this.gtfsStorage, RealtimeFeed.fromProtobuf(this.graphHopperStorage, this.gtfsStorage, this.flagEncoder, realtimeFeeds));
        }

        public GraphHopperGtfs createWithoutRealtimeFeed() {
            return new GraphHopperGtfs(this.flagEncoder, this.translationMap, this.graphHopperStorage, this.locationIndex, this.gtfsStorage, RealtimeFeed.empty(this.gtfsStorage));
        }
    }
}

