/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Fare;
import com.conveyal.gtfs.model.FareRule;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.gtfs.fare.FixedFareAttributeLoader;
import com.graphhopper.reader.gtfs.GtfsStorageI;
import com.graphhopper.reader.gtfs.Transfers;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphExtension;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipFile;
import org.mapdb.Bind;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;

public class GtfsStorage
implements GraphExtension,
GtfsStorageI {
    private boolean isClosed = false;
    private Directory dir;
    private Set<String> gtfsFeedIds;
    private Map<String, GTFSFeed> gtfsFeeds = new HashMap<String, GTFSFeed>();
    private Map<String, Transfers> transfers = new HashMap<String, Transfers>();
    private HTreeMap<Validity, Integer> operatingDayPatterns;
    private Bind.MapWithModificationListener<FeedIdWithTimezone, Integer> timeZones;
    private Map<Integer, FeedIdWithTimezone> readableTimeZones;
    private Map<Integer, byte[]> tripDescriptors;
    private Map<Integer, Integer> stopSequences;
    private Map<Integer, GtfsStorageI.PlatformDescriptor> routes;
    private Map<String, Fare> fares;
    private Map<String, int[]> boardEdgesForTrip;
    private Map<String, int[]> leaveEdgesForTrip;
    private Map<String, Integer> stationNodes;
    private DB data;

    @Override
    public boolean isRequireNodeField() {
        return true;
    }

    @Override
    public boolean isRequireEdgeField() {
        return false;
    }

    @Override
    public int getDefaultNodeFieldValue() {
        return 0;
    }

    @Override
    public int getDefaultEdgeFieldValue() {
        return EdgeType.HIGHWAY.ordinal();
    }

    @Override
    public void init(Graph graph, Directory dir) {
        this.dir = dir;
    }

    @Override
    public void setSegmentSize(int bytes) {
    }

    @Override
    public GraphExtension copyTo(GraphExtension extStorage) {
        throw new UnsupportedOperationException("copyTo not yet supported");
    }

    @Override
    public boolean loadExisting() {
        this.data = ((DBMaker)((DBMaker)((DBMaker)DBMaker.newFileDB(new File(this.dir.getLocation() + "/transit_schedule")).transactionDisable()).mmapFileEnable()).readOnly()).make();
        this.init();
        for (String gtfsFeedId : this.gtfsFeedIds) {
            GTFSFeed feed = new GTFSFeed(new File(this.dir.getLocation() + "/" + gtfsFeedId));
            this.gtfsFeeds.put(gtfsFeedId, feed);
            this.transfers.put(gtfsFeedId, new Transfers(feed));
        }
        return true;
    }

    @Override
    public GraphExtension create(long byteCount) {
        File file = new File(this.dir.getLocation() + "/transit_schedule");
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.data = ((DBMaker)((DBMaker)((DBMaker)DBMaker.newFileDB(file).transactionDisable()).mmapFileEnable()).asyncWriteEnable()).make();
        this.init();
        return this;
    }

    private void init() {
        this.gtfsFeedIds = this.data.getHashSet("gtfsFeeds");
        this.operatingDayPatterns = this.data.getHashMap("validities");
        this.timeZones = this.data.getHashMap("timeZones");
        HashMap readableTimeZones = new HashMap();
        for (Map.Entry entry : this.timeZones.entrySet()) {
            readableTimeZones.put(entry.getValue(), entry.getKey());
        }
        Bind.mapInverse(this.timeZones, readableTimeZones);
        this.readableTimeZones = Collections.unmodifiableMap(readableTimeZones);
        this.tripDescriptors = this.data.getTreeMap("tripDescriptors");
        this.stopSequences = this.data.getTreeMap("stopSequences");
        this.fares = this.data.getTreeMap("fares");
        this.boardEdgesForTrip = this.data.getHashMap("boardEdgesForTrip");
        this.leaveEdgesForTrip = this.data.getHashMap("leaveEdgesForTrip");
        this.stationNodes = this.data.getHashMap("stationNodes");
        this.routes = this.data.getHashMap("routes");
    }

    void loadGtfsFromFile(String id, ZipFile zip) {
        File file = new File(this.dir.getLocation() + "/" + id);
        try {
            Files.deleteIfExists(file.toPath());
            GTFSFeed feed = new GTFSFeed(file);
            feed.loadFromFileAndLogErrors(zip);
            this.fixFares(feed, zip);
            this.gtfsFeeds.put(id, feed);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.gtfsFeedIds.add(id);
    }

    private void fixFares(GTFSFeed feed, ZipFile zip) {
        feed.fares.clear();
        HashMap<String, Fare> fares = new HashMap<String, Fare>();
        try {
            new FixedFareAttributeLoader(feed, fares).loadTable(zip);
            new FareRule.Loader(feed, fares).loadTable(zip);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        feed.fares.putAll(fares);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.data.close();
            for (GTFSFeed feed : this.gtfsFeeds.values()) {
                feed.close();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public long getCapacity() {
        return 0L;
    }

    @Override
    public Map<Validity, Integer> getOperatingDayPatterns() {
        return this.operatingDayPatterns;
    }

    Map<Integer, FeedIdWithTimezone> getTimeZones() {
        return this.readableTimeZones;
    }

    @Override
    public Map<FeedIdWithTimezone, Integer> getWritableTimeZones() {
        return this.timeZones;
    }

    @Override
    public Map<Integer, byte[]> getTripDescriptors() {
        return this.tripDescriptors;
    }

    @Override
    public Map<Integer, Integer> getStopSequences() {
        return this.stopSequences;
    }

    @Override
    public Map<String, int[]> getBoardEdgesForTrip() {
        return this.boardEdgesForTrip;
    }

    @Override
    public Map<String, int[]> getAlightEdgesForTrip() {
        return this.leaveEdgesForTrip;
    }

    @Override
    public Map<Integer, GtfsStorageI.PlatformDescriptor> getRoutes() {
        return this.routes;
    }

    @Override
    public Map<String, Fare> getFares() {
        return this.fares;
    }

    @Override
    public Map<String, GTFSFeed> getGtfsFeeds() {
        return Collections.unmodifiableMap(this.gtfsFeeds);
    }

    @Override
    public Map<String, Transfers> getTransfers() {
        return this.transfers;
    }

    @Override
    public Map<String, Integer> getStationNodes() {
        return this.stationNodes;
    }

    static String tripKey(GtfsRealtime.TripDescriptor tripDescriptor, boolean isFrequencyBased) {
        if (isFrequencyBased) {
            return tripDescriptor.getTripId() + tripDescriptor.getStartTime();
        }
        return tripDescriptor.getTripId();
    }

    public static enum EdgeType {
        HIGHWAY,
        ENTER_TIME_EXPANDED_NETWORK,
        LEAVE_TIME_EXPANDED_NETWORK,
        ENTER_PT,
        EXIT_PT,
        HOP,
        DWELL,
        BOARD,
        ALIGHT,
        OVERNIGHT,
        TRANSFER,
        WAIT,
        WAIT_ARRIVAL;

    }

    static class FeedIdWithTimezone
    implements Serializable {
        final String feedId;
        final ZoneId zoneId;

        FeedIdWithTimezone(String feedId, ZoneId zoneId) {
            this.feedId = feedId;
            this.zoneId = zoneId;
        }

        public boolean equals(Object other) {
            if (!(other instanceof FeedIdWithTimezone)) {
                return false;
            }
            FeedIdWithTimezone v = (FeedIdWithTimezone)other;
            return this.feedId.equals(v.feedId) && this.zoneId.equals(v.zoneId);
        }

        public int hashCode() {
            return Objects.hash(this.feedId, this.zoneId);
        }
    }

    public static class Validity
    implements Serializable {
        final BitSet validity;
        final ZoneId zoneId;
        final LocalDate start;

        Validity(BitSet validity, ZoneId zoneId, LocalDate start) {
            this.validity = validity;
            this.zoneId = zoneId;
            this.start = start;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Validity)) {
                return false;
            }
            Validity v = (Validity)other;
            return this.validity.equals(v.validity) && this.zoneId.equals(v.zoneId) && this.start.equals(v.start);
        }

        public int hashCode() {
            return Objects.hash(this.validity, this.zoneId, this.start);
        }
    }
}

