/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Fare;
import com.graphhopper.reader.gtfs.GtfsStorage;
import com.graphhopper.reader.gtfs.Transfers;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public interface GtfsStorageI {
    public Map<String, Fare> getFares();

    public Map<GtfsStorage.Validity, Integer> getOperatingDayPatterns();

    public Map<GtfsStorage.FeedIdWithTimezone, Integer> getWritableTimeZones();

    public Map<Integer, byte[]> getTripDescriptors();

    public Map<Integer, Integer> getStopSequences();

    public Map<String, int[]> getBoardEdgesForTrip();

    public Map<String, int[]> getAlightEdgesForTrip();

    public Map<String, GTFSFeed> getGtfsFeeds();

    public Map<String, Transfers> getTransfers();

    public Map<String, Integer> getStationNodes();

    public Map<Integer, PlatformDescriptor> getRoutes();

    public static class RouteTypePlatform
    extends PlatformDescriptor {
        int route_type;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteTypePlatform that = (RouteTypePlatform)o;
            return this.route_type == that.route_type;
        }

        public int hashCode() {
            return Objects.hash(this.route_type);
        }
    }

    public static class RoutePlatform
    extends PlatformDescriptor {
        String route_id;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoutePlatform that = (RoutePlatform)o;
            return Objects.equals(this.route_id, that.route_id);
        }

        public int hashCode() {
            return Objects.hash(this.route_id);
        }
    }

    public static abstract class PlatformDescriptor
    implements Serializable {
        public static PlatformDescriptor route(String route_id) {
            RoutePlatform routePlatform = new RoutePlatform();
            routePlatform.route_id = route_id;
            return routePlatform;
        }

        public static RouteTypePlatform routeType(int route_type) {
            RouteTypePlatform routeTypePlatform = new RouteTypePlatform();
            routeTypePlatform.route_type = route_type;
            return routeTypePlatform;
        }
    }
}

