/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.gtfs;

import com.graphhopper.reader.gtfs.GtfsStorage;
import com.graphhopper.reader.gtfs.PtFlagEncoder;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIteratorState;
import java.time.Instant;
import java.util.Iterator;

public class Label {
    public final long currentTime;
    public final int edge;
    public final int adjNode;
    public final int nTransfers;
    public final int nWalkDistanceConstraintViolations;
    public final double walkDistanceOnCurrentLeg;
    public final Long departureTime;
    public final long walkTime;
    final long residualDelay;
    final boolean impossible;
    public final Label parent;
    public boolean deleted = false;

    Label(long currentTime, int edgeId, int adjNode, int nTransfers, int nWalkDistanceConstraintViolations, double walkDistance, Long departureTime, long walkTime, long residualDelay, boolean impossible, Label parent) {
        this.currentTime = currentTime;
        this.edge = edgeId;
        this.adjNode = adjNode;
        this.nTransfers = nTransfers;
        this.nWalkDistanceConstraintViolations = nWalkDistanceConstraintViolations;
        this.walkDistanceOnCurrentLeg = walkDistance;
        this.departureTime = departureTime;
        this.walkTime = walkTime;
        this.residualDelay = residualDelay;
        this.impossible = impossible;
        this.parent = parent;
    }

    public String toString() {
        return this.adjNode + " " + Instant.ofEpochMilli(this.currentTime) + " " + this.nTransfers + " " + this.nWalkDistanceConstraintViolations + " " + (this.departureTime != null ? Instant.ofEpochMilli(this.departureTime) : "");
    }

    static Iterable<Transition> reverseEdges(final Label leaf, final Graph graph, final PtFlagEncoder flagEncoder, final boolean reverseEdgeFlags) {
        return new Iterable<Transition>(){

            @Override
            public Iterator<Transition> iterator() {
                return new Iterator<Transition>(){
                    int i = 0;
                    Label label;
                    {
                        this.label = leaf;
                    }

                    @Override
                    public boolean hasNext() {
                        return reverseEdgeFlags ? this.label != null : this.label.parent != null;
                    }

                    @Override
                    public Transition next() {
                        EdgeIteratorState edgeIteratorState;
                        if (this.i == 0 && !reverseEdgeFlags) {
                            ++this.i;
                            return new Transition(this.label, null);
                        }
                        EdgeIteratorState edgeIteratorState2 = this.label.parent == null ? null : (edgeIteratorState = graph.getEdgeIteratorState(this.label.edge, reverseEdgeFlags ? this.label.adjNode : this.label.parent.adjNode).detach(false));
                        if (reverseEdgeFlags && edgeIteratorState != null && (edgeIteratorState.getBaseNode() != this.label.parent.adjNode || edgeIteratorState.getAdjNode() != this.label.adjNode)) {
                            throw new IllegalStateException();
                        }
                        if (!(reverseEdgeFlags || edgeIteratorState == null || edgeIteratorState.getAdjNode() == this.label.parent.adjNode && edgeIteratorState.getBaseNode() == this.label.adjNode)) {
                            throw new IllegalStateException();
                        }
                        Transition transition = reverseEdgeFlags ? new Transition(this.label, edgeIteratorState != null ? Label.getEdgeLabel(edgeIteratorState, flagEncoder) : null) : new Transition(this.label.parent, edgeIteratorState != null ? Label.getEdgeLabel(edgeIteratorState, flagEncoder) : null);
                        this.label = this.label.parent;
                        return transition;
                    }
                };
            }
        };
    }

    private static EdgeLabel getEdgeLabel(EdgeIteratorState edgeIteratorState, PtFlagEncoder flagEncoder) {
        return new EdgeLabel(edgeIteratorState, edgeIteratorState.get(flagEncoder.getTypeEnc()), edgeIteratorState.get(flagEncoder.getValidityIdEnc()), edgeIteratorState.get(flagEncoder.getTransfersEnc()), edgeIteratorState.getDistance());
    }

    static class EdgeLabel {
        final EdgeIteratorState edgeIteratorState;
        final GtfsStorage.EdgeType edgeType;
        final int timeZoneId;
        final int nTransfers;
        final double distance;

        public EdgeLabel(EdgeIteratorState edgeIteratorState, GtfsStorage.EdgeType edgeType, int timeZoneId, int nTransfers, double distance) {
            this.edgeIteratorState = edgeIteratorState;
            this.edgeType = edgeType;
            this.timeZoneId = timeZoneId;
            this.nTransfers = nTransfers;
            this.distance = distance;
        }

        public String toString() {
            return this.edgeType.toString();
        }
    }

    static class Transition {
        final Label label;
        final EdgeLabel edge;

        Transition(Label label, EdgeLabel edge) {
            this.label = label;
            this.edge = edge;
        }

        public String toString() {
            return (this.edge != null ? this.edge.toString() + " -> " : "") + this.label.adjNode;
        }
    }
}

