/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.gtfs;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.gtfs.GtfsStorage;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.routing.profiles.SimpleIntEncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.IntsRef;
import java.util.List;

public class PtFlagEncoder
extends AbstractFlagEncoder {
    private IntEncodedValue timeEnc;
    private IntEncodedValue transfersEnc;
    private IntEncodedValue validityIdEnc;
    private EnumEncodedValue<GtfsStorage.EdgeType> typeEnc;

    public PtFlagEncoder() {
        super(0, 1.0, 0);
    }

    @Override
    public void createEncodedValues(List<EncodedValue> list, String prefix, int index) {
        super.createEncodedValues(list, prefix, index);
        this.validityIdEnc = new SimpleIntEncodedValue(prefix + "validity_id", 20, false);
        list.add(this.validityIdEnc);
        this.transfersEnc = new SimpleIntEncodedValue(prefix + "transfers", 1, false);
        list.add(this.transfersEnc);
        this.typeEnc = new EnumEncodedValue<GtfsStorage.EdgeType>(prefix + "type", GtfsStorage.EdgeType.class);
        list.add(this.typeEnc);
        this.timeEnc = new SimpleIntEncodedValue(prefix + "time", 17, false);
        list.add(this.timeEnc);
    }

    @Override
    public long handleRelationTags(long oldRelationFlags, ReaderRelation relation) {
        return oldRelationFlags;
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        return EncodingManager.Access.CAN_SKIP;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        return edgeFlags;
    }

    public IntEncodedValue getTimeEnc() {
        return this.timeEnc;
    }

    public IntEncodedValue getTransfersEnc() {
        return this.transfersEnc;
    }

    public IntEncodedValue getValidityIdEnc() {
        return this.validityIdEnc;
    }

    public EnumEncodedValue<GtfsStorage.EdgeType> getTypeEnc() {
        return this.typeEnc;
    }

    public String toString() {
        return "pt";
    }

    @Override
    public int getVersion() {
        return 1;
    }
}

