/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.gtfs;

import com.graphhopper.reader.gtfs.GHLocation;
import com.graphhopper.reader.gtfs.GHPointLocation;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.GHPoint;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class Request {
    private List<GHLocation> points;
    private Instant earliestDepartureTime;
    private int maxVisitedNodes = 1000000;
    private boolean profileQuery;
    private Boolean ignoreTransfers;
    private double betaTransfers = 0.0;
    private double betaWalkTime = 1.0;
    private Integer limitSolutions;
    private boolean arriveBy;
    private double walkSpeedKmH = 5.0;
    private int blockedRouteTypes;
    private Locale locale = Helper.getLocale("en");
    private double maxWalkDistancePerLeg = 2.147483647E9;

    public Request(List<GHLocation> points, Instant departureTime) {
        this.points = points;
        this.earliestDepartureTime = departureTime;
    }

    public Request(double from_lat, double from_lon, double to_lat, double to_lon) {
        this.points = Arrays.asList(new GHPointLocation(new GHPoint(from_lat, from_lon)), new GHPointLocation(new GHPoint(to_lat, to_lon)));
    }

    public int getMaxVisitedNodes() {
        return this.maxVisitedNodes;
    }

    public void setMaxVisitedNodes(int maxVisitedNodes) {
        this.maxVisitedNodes = maxVisitedNodes;
    }

    public boolean isProfileQuery() {
        return this.profileQuery;
    }

    public void setProfileQuery(boolean profileQuery) {
        this.profileQuery = profileQuery;
    }

    public Boolean getIgnoreTransfers() {
        return this.ignoreTransfers;
    }

    public void setIgnoreTransfers(Boolean ignoreTransfers) {
        this.ignoreTransfers = ignoreTransfers;
    }

    public double getBetaTransfers() {
        return this.betaTransfers;
    }

    public void setBetaTransfers(double betaTransfers) {
        this.betaTransfers = betaTransfers;
    }

    public double getBetaWalkTime() {
        return this.betaWalkTime;
    }

    public void setBetaWalkTime(double betaWalkTime) {
        this.betaWalkTime = betaWalkTime;
    }

    public Integer getLimitSolutions() {
        return this.limitSolutions;
    }

    public void setLimitSolutions(Integer limitSolutions) {
        this.limitSolutions = limitSolutions;
    }

    public Instant getEarliestDepartureTime() {
        return this.earliestDepartureTime;
    }

    public void setEarliestDepartureTime(Instant earliestDepartureTime) {
        this.earliestDepartureTime = earliestDepartureTime;
    }

    public boolean isArriveBy() {
        return this.arriveBy;
    }

    public void setArriveBy(boolean arriveBy) {
        this.arriveBy = arriveBy;
    }

    public double getWalkSpeedKmH() {
        return this.walkSpeedKmH;
    }

    public void setWalkSpeedKmH(double walkSpeedKmH) {
        this.walkSpeedKmH = walkSpeedKmH;
    }

    public int getBlockedRouteTypes() {
        return this.blockedRouteTypes;
    }

    public void setBlockedRouteTypes(int blockedRouteTypes) {
        this.blockedRouteTypes = blockedRouteTypes;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<GHLocation> getPoints() {
        return this.points;
    }

    public double getMaxWalkDistancePerLeg() {
        return this.maxWalkDistancePerLeg;
    }

    public void setMaxWalkDistancePerLeg(double maxWalkDistancePerLeg) {
        this.maxWalkDistancePerLeg = maxWalkDistancePerLeg;
    }
}

