/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.PathWrapper;
import com.graphhopper.Trip;
import com.graphhopper.gtfs.fare.Fares;
import com.graphhopper.gtfs.fare.Trip;
import com.graphhopper.reader.gtfs.GtfsHelper;
import com.graphhopper.reader.gtfs.GtfsReader;
import com.graphhopper.reader.gtfs.GtfsStorage;
import com.graphhopper.reader.gtfs.Label;
import com.graphhopper.reader.gtfs.PtFlagEncoder;
import com.graphhopper.reader.gtfs.RealtimeFeed;
import com.graphhopper.routing.InstructionsFromEdges;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TripFromLabel {
    private static final Logger logger = LoggerFactory.getLogger(TripFromLabel.class);
    private final GtfsStorage gtfsStorage;
    private final RealtimeFeed realtimeFeed;
    private final GeometryFactory geometryFactory = new GeometryFactory();

    TripFromLabel(GtfsStorage gtfsStorage, RealtimeFeed realtimeFeed) {
        this.gtfsStorage = gtfsStorage;
        this.realtimeFeed = realtimeFeed;
    }

    PathWrapper createPathWrapper(Translation tr, PointList waypoints, List<Trip.Leg> legs) {
        if (legs.size() > 1 && legs.get(0) instanceof Trip.WalkLeg) {
            Trip.WalkLeg accessLeg = (Trip.WalkLeg)legs.get(0);
            legs.set(0, new Trip.WalkLeg(accessLeg.departureLocation, new Date(legs.get(1).getDepartureTime().getTime() - (accessLeg.getArrivalTime().getTime() - accessLeg.getDepartureTime().getTime())), accessLeg.geometry, accessLeg.distance, accessLeg.instructions, legs.get(1).getDepartureTime()));
        }
        if (legs.size() > 1 && legs.get(legs.size() - 1) instanceof Trip.WalkLeg) {
            Trip.WalkLeg egressLeg = (Trip.WalkLeg)legs.get(legs.size() - 1);
            legs.set(legs.size() - 1, new Trip.WalkLeg(egressLeg.departureLocation, legs.get(legs.size() - 2).getArrivalTime(), egressLeg.geometry, egressLeg.distance, egressLeg.instructions, new Date(legs.get(legs.size() - 2).getArrivalTime().getTime() + (egressLeg.getArrivalTime().getTime() - egressLeg.getDepartureTime().getTime()))));
        }
        PathWrapper path = new PathWrapper();
        path.setWaypoints(waypoints);
        path.getLegs().addAll(legs);
        InstructionList instructions = this.getInstructions(tr, path.getLegs());
        path.setInstructions(instructions);
        PointList pointsList = new PointList();
        for (Instruction instruction : instructions) {
            pointsList.add(instruction.getPoints());
        }
        path.setPoints(pointsList);
        path.setDistance(path.getLegs().stream().mapToDouble(Trip.Leg::getDistance).sum());
        path.setTime(legs.get(legs.size() - 1).getArrivalTime().toInstant().toEpochMilli() - legs.get(0).getDepartureTime().toInstant().toEpochMilli());
        path.setNumChanges((int)path.getLegs().stream().filter(l -> l instanceof Trip.PtLeg).filter(l -> !((Trip.PtLeg)l).isInSameVehicleAsPrevious).count() - 1);
        com.graphhopper.gtfs.fare.Trip faresTrip = new com.graphhopper.gtfs.fare.Trip();
        path.getLegs().stream().filter(leg -> leg instanceof Trip.PtLeg).map(leg -> (Trip.PtLeg)leg).findFirst().ifPresent(firstPtLeg -> {
            LocalDateTime firstPtDepartureTime = GtfsHelper.localDateTimeFromDate(firstPtLeg.getDepartureTime());
            path.getLegs().stream().filter(leg -> leg instanceof Trip.PtLeg).map(leg -> (Trip.PtLeg)leg).map(ptLeg -> {
                GTFSFeed gtfsFeed = this.gtfsStorage.getGtfsFeeds().get(ptLeg.feed_id);
                return new Trip.Segment(ptLeg.route_id, Duration.between(firstPtDepartureTime, GtfsHelper.localDateTimeFromDate(ptLeg.getDepartureTime())).getSeconds(), gtfsFeed.stops.get((Object)ptLeg.stops.get((int)0).stop_id).zone_id, gtfsFeed.stops.get((Object)ptLeg.stops.get((int)(ptLeg.stops.size() - 1)).stop_id).zone_id, ptLeg.stops.stream().map(s -> gtfsFeed.stops.get((Object)s.stop_id).zone_id).collect(Collectors.toSet()));
            }).forEach(faresTrip.segments::add);
            Fares.cheapestFare(this.gtfsStorage.getFares(), faresTrip).ifPresent(amount -> path.setFare(amount.getAmount()));
        });
        return path;
    }

    List<Trip.Leg> getTrip(Translation tr, Graph queryGraph, Weighting weighting, List<Label.Transition> transitions) {
        List<List<Label.Transition>> partitions = this.getPartitions(transitions);
        List<Trip.Leg> legs = this.getLegs(tr, queryGraph, weighting, partitions);
        return legs;
    }

    List<Label.Transition> getTransitions(boolean arriveBy, PtFlagEncoder encoder, Graph queryGraph, Label solution) {
        ArrayList<Label.Transition> transitions = new ArrayList<Label.Transition>();
        if (arriveBy) {
            Label.reverseEdges(solution, queryGraph, encoder, false).forEach(transitions::add);
        } else {
            Label.reverseEdges(solution, queryGraph, encoder, true).forEach(transitions::add);
            Collections.reverse(transitions);
        }
        return transitions;
    }

    private List<List<Label.Transition>> getPartitions(List<Label.Transition> transitions) {
        ArrayList<List<Label.Transition>> partitions = new ArrayList<List<Label.Transition>>();
        partitions.add(new ArrayList());
        Iterator<Label.Transition> iterator = transitions.iterator();
        ((List)partitions.get(partitions.size() - 1)).add(iterator.next());
        iterator.forEachRemaining(transition -> {
            List previous = (List)partitions.get(partitions.size() - 1);
            Label.EdgeLabel previousEdge = ((Label.Transition)previous.get((int)(previous.size() - 1))).edge;
            if (previousEdge != null && (transition.edge.edgeType == GtfsStorage.EdgeType.ENTER_PT || previousEdge.edgeType == GtfsStorage.EdgeType.EXIT_PT)) {
                ArrayList<Label.Transition> p = new ArrayList<Label.Transition>();
                p.add(new Label.Transition(((Label.Transition)previous.get((int)(previous.size() - 1))).label, null));
                partitions.add(p);
            }
            ((List)partitions.get(partitions.size() - 1)).add(transition);
        });
        return partitions;
    }

    private List<Trip.Leg> getLegs(Translation tr, Graph queryGraph, Weighting weighting, List<List<Label.Transition>> partitions) {
        return partitions.stream().flatMap(partition -> this.parsePathIntoLegs((List<Label.Transition>)partition, queryGraph, weighting, tr).stream()).collect(Collectors.toList());
    }

    private InstructionList getInstructions(Translation tr, List<Trip.Leg> legs) {
        InstructionList instructions = new InstructionList(tr);
        for (int i = 0; i < legs.size(); ++i) {
            PointList pl;
            Trip.Leg leg = legs.get(i);
            if (leg instanceof Trip.WalkLeg) {
                Trip.WalkLeg walkLeg = (Trip.WalkLeg)leg;
                instructions.addAll(walkLeg.instructions.subList(0, i < legs.size() - 1 ? walkLeg.instructions.size() - 1 : walkLeg.instructions.size()));
                continue;
            }
            if (!(leg instanceof Trip.PtLeg)) continue;
            Trip.PtLeg ptLeg = (Trip.PtLeg)leg;
            if (!ptLeg.isInSameVehicleAsPrevious) {
                pl = new PointList();
                Instruction departureInstruction = new Instruction(101, ptLeg.trip_headsign, InstructionAnnotation.EMPTY, pl);
                departureInstruction.setDistance(leg.getDistance());
                departureInstruction.setTime(ptLeg.travelTime);
                instructions.add(departureInstruction);
            } else {
                pl = instructions.get(instructions.size() - 2).getPoints();
            }
            pl.add(ptLeg.stops.get((int)0).geometry.getY(), ptLeg.stops.get((int)0).geometry.getX());
            for (Trip.Stop stop : ptLeg.stops.subList(0, ptLeg.stops.size() - 1)) {
                pl.add(stop.geometry.getY(), stop.geometry.getX());
            }
            PointList arrivalPointList = new PointList();
            Trip.Stop arrivalStop = ptLeg.stops.get(ptLeg.stops.size() - 1);
            arrivalPointList.add(arrivalStop.geometry.getY(), arrivalStop.geometry.getX());
            Instruction arrivalInstruction = new Instruction(103, arrivalStop.stop_name, InstructionAnnotation.EMPTY, arrivalPointList);
            if (ptLeg.isInSameVehicleAsPrevious) {
                instructions.set(instructions.size() - 1, arrivalInstruction);
                continue;
            }
            instructions.add(arrivalInstruction);
        }
        return instructions;
    }

    private List<Trip.Leg> parsePathIntoLegs(List<Label.Transition> path, Graph graph, Weighting weighting, Translation tr) {
        if (path.size() <= 1) {
            return Collections.emptyList();
        }
        if (GtfsStorage.EdgeType.ENTER_PT == path.get((int)1).edge.edgeType) {
            GtfsStorage.FeedIdWithTimezone feedIdWithTimezone = this.gtfsStorage.getTimeZones().get(path.get((int)2).edge.timeZoneId);
            ArrayList<Trip.Leg> result = new ArrayList<Trip.Leg>();
            long boardTime = -1L;
            ArrayList<Label.Transition> partition = null;
            for (int i = 1; i < path.size(); ++i) {
                GtfsRealtime.TripDescriptor tripDescriptor;
                Label.Transition transition = path.get(i);
                Label.EdgeLabel edge = path.get((int)i).edge;
                if (edge.edgeType == GtfsStorage.EdgeType.BOARD) {
                    boardTime = transition.label.currentTime;
                    partition = new ArrayList<Label.Transition>();
                }
                if (partition != null) {
                    partition.add(path.get(i));
                }
                if (!EnumSet.of(GtfsStorage.EdgeType.TRANSFER, GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK).contains((Object)edge.edgeType)) continue;
                Geometry lineString = this.lineStringFromEdges(partition);
                try {
                    tripDescriptor = GtfsRealtime.TripDescriptor.parseFrom(this.realtimeFeed.getTripDescriptor(((Label.Transition)partition.get((int)0)).edge.edgeIteratorState.getEdge()));
                }
                catch (InvalidProtocolBufferException e2) {
                    throw new RuntimeException(e2);
                }
                StopsFromBoardHopDwellEdges stopsFromBoardHopDwellEdges = new StopsFromBoardHopDwellEdges(feedIdWithTimezone.feedId, tripDescriptor);
                partition.stream().filter(e -> EnumSet.of(GtfsStorage.EdgeType.HOP, GtfsStorage.EdgeType.BOARD, GtfsStorage.EdgeType.DWELL).contains((Object)e.edge.edgeType)).forEach(stopsFromBoardHopDwellEdges::next);
                stopsFromBoardHopDwellEdges.finish();
                List stops = stopsFromBoardHopDwellEdges.stops;
                result.add(new Trip.PtLeg(feedIdWithTimezone.feedId, ((Label.Transition)partition.get((int)0)).edge.nTransfers == 0, tripDescriptor.getTripId(), tripDescriptor.getRouteId(), ((EdgeIteratorState)this.edges(partition).map(edgeLabel -> edgeLabel.edgeIteratorState).collect(Collectors.toList()).get(0)).getName(), stops, partition.stream().mapToDouble(t -> t.edge.distance).sum(), path.get((int)(i - 1)).label.currentTime - boardTime, lineString));
                partition = null;
            }
            return result;
        }
        InstructionList instructions = new InstructionList(tr);
        InstructionsFromEdges instructionsFromEdges = new InstructionsFromEdges(path.get((int)1).edge.edgeIteratorState.getBaseNode(), graph, weighting, weighting.getFlagEncoder(), weighting.getFlagEncoder().getBooleanEncodedValue("roundabout"), graph.getNodeAccess(), tr, instructions);
        int prevEdgeId = -1;
        for (int i = 1; i < path.size(); ++i) {
            if (path.get((int)i).edge.edgeType != GtfsStorage.EdgeType.HIGHWAY) {
                throw new IllegalStateException("Got a transit edge where I think I must be on a road.");
            }
            EdgeIteratorState edge = path.get((int)i).edge.edgeIteratorState;
            instructionsFromEdges.next(edge, i, prevEdgeId);
            prevEdgeId = edge.getEdge();
        }
        instructionsFromEdges.finish();
        Instant departureTime = Instant.ofEpochMilli(path.get((int)0).label.currentTime);
        Instant arrivalTime = Instant.ofEpochMilli(path.get((int)(path.size() - 1)).label.currentTime);
        return Collections.singletonList(new Trip.WalkLeg("Walk", Date.from(departureTime), this.lineStringFromEdges(path), this.edges(path).mapToDouble(edgeLabel -> edgeLabel.distance).sum(), instructions, Date.from(arrivalTime)));
    }

    private Stream<Label.EdgeLabel> edges(List<Label.Transition> path) {
        return path.stream().filter(t -> t.edge != null).map(t -> t.edge);
    }

    private Geometry lineStringFromEdges(List<Label.Transition> transitions) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Iterator<Label.Transition> iterator = transitions.iterator();
        iterator.next();
        coordinates.addAll(TripFromLabel.toCoordinateArray(iterator.next().edge.edgeIteratorState.fetchWayGeometry(3)));
        iterator.forEachRemaining(transition -> coordinates.addAll(TripFromLabel.toCoordinateArray(transition.edge.edgeIteratorState.fetchWayGeometry(2))));
        return this.geometryFactory.createLineString(coordinates.toArray(new Coordinate[coordinates.size()]));
    }

    private static List<Coordinate> toCoordinateArray(PointList pointList) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(pointList.size());
        for (int i = 0; i < pointList.size(); ++i) {
            coordinates.add(pointList.getDimension() == 3 ? new Coordinate(pointList.getLon(i), pointList.getLat(i)) : new Coordinate(pointList.getLon(i), pointList.getLat(i), pointList.getEle(i)));
        }
        return coordinates;
    }

    private class StopsFromBoardHopDwellEdges {
        private final GtfsRealtime.TripDescriptor tripDescriptor;
        private final List<Trip.Stop> stops = new ArrayList<Trip.Stop>();
        private final GTFSFeed gtfsFeed;
        private Instant boardTime;
        private Instant arrivalTimeFromHopEdge;
        private Optional<Instant> updatedArrival;
        private StopTime stopTime = null;
        private GtfsReader.TripWithStopTimes tripUpdate = null;
        private int stopSequence = 0;

        StopsFromBoardHopDwellEdges(String feedId, GtfsRealtime.TripDescriptor tripDescriptor) {
            this.tripDescriptor = tripDescriptor;
            this.gtfsFeed = TripFromLabel.this.gtfsStorage.getGtfsFeeds().get(feedId);
            if (this.tripUpdate != null) {
                this.validateTripUpdate(this.tripUpdate);
            }
        }

        void next(Label.Transition t) {
            switch (t.edge.edgeType) {
                case BOARD: {
                    this.boardTime = Instant.ofEpochMilli(t.label.currentTime);
                    this.stopSequence = TripFromLabel.this.realtimeFeed.getStopSequence(t.edge.edgeIteratorState.getEdge());
                    this.stopTime = TripFromLabel.this.realtimeFeed.getStopTime(this.gtfsFeed, this.tripDescriptor, t, this.boardTime, this.stopSequence);
                    this.tripUpdate = TripFromLabel.this.realtimeFeed.getTripUpdate(this.gtfsFeed, this.tripDescriptor, t, this.boardTime).orElse(null);
                    Instant plannedDeparture = Instant.ofEpochMilli(t.label.currentTime);
                    Optional<Instant> updatedDeparture = this.getDepartureDelay(this.stopSequence).map(delay -> plannedDeparture.plus((long)delay.intValue(), ChronoUnit.SECONDS));
                    Stop stop = this.gtfsFeed.stops.get(this.stopTime.stop_id);
                    this.stops.add(new Trip.Stop(stop.stop_id, stop.stop_name, TripFromLabel.this.geometryFactory.createPoint(new Coordinate(stop.stop_lon, stop.stop_lat)), null, null, null, this.isArrivalCancelled(this.stopSequence), updatedDeparture.map(Date::from).orElse(Date.from(plannedDeparture)), Date.from(plannedDeparture), updatedDeparture.map(Date::from).orElse(null), this.isDepartureCancelled(this.stopSequence)));
                    break;
                }
                case HOP: {
                    this.stopSequence = TripFromLabel.this.realtimeFeed.getStopSequence(t.edge.edgeIteratorState.getEdge());
                    this.stopTime = TripFromLabel.this.realtimeFeed.getStopTime(this.gtfsFeed, this.tripDescriptor, t, this.boardTime, this.stopSequence);
                    this.arrivalTimeFromHopEdge = Instant.ofEpochMilli(t.label.currentTime);
                    this.updatedArrival = this.getArrivalDelay(this.stopSequence).map(delay -> this.arrivalTimeFromHopEdge.plus((long)delay.intValue(), ChronoUnit.SECONDS));
                    break;
                }
                case DWELL: {
                    Instant plannedDeparture = Instant.ofEpochMilli(t.label.currentTime);
                    Optional<Instant> updatedDeparture = this.getDepartureDelay(this.stopTime.stop_sequence).map(delay -> plannedDeparture.plus((long)delay.intValue(), ChronoUnit.SECONDS));
                    Stop stop = this.gtfsFeed.stops.get(this.stopTime.stop_id);
                    this.stops.add(new Trip.Stop(stop.stop_id, stop.stop_name, TripFromLabel.this.geometryFactory.createPoint(new Coordinate(stop.stop_lon, stop.stop_lat)), this.updatedArrival.map(Date::from).orElse(Date.from(this.arrivalTimeFromHopEdge)), Date.from(this.arrivalTimeFromHopEdge), this.updatedArrival.map(Date::from).orElse(null), this.isArrivalCancelled(this.stopSequence), updatedDeparture.map(Date::from).orElse(Date.from(plannedDeparture)), Date.from(plannedDeparture), updatedDeparture.map(Date::from).orElse(null), this.isDepartureCancelled(this.stopSequence)));
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }

        private Optional<Integer> getArrivalDelay(int stopSequence) {
            if (this.tripUpdate != null) {
                int arrival_time = this.tripUpdate.stopTimes.stream().filter((Predicate<StopTime>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getArrivalDelay$3(int com.conveyal.gtfs.model.StopTime ), (Lcom/conveyal/gtfs/model/StopTime;)Z)((int)stopSequence)).findFirst().orElseThrow((Supplier<RuntimeException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getArrivalDelay$4(), ()Ljava/lang/RuntimeException;)()).arrival_time;
                logger.trace("stop_sequence {} scheduled arrival {} updated arrival {}", stopSequence, this.stopTime.arrival_time, arrival_time);
                return Optional.of(arrival_time - this.stopTime.arrival_time);
            }
            return Optional.empty();
        }

        private boolean isArrivalCancelled(int stopSequence) {
            if (this.tripUpdate != null) {
                return this.tripUpdate.cancelledArrivals.contains(stopSequence);
            }
            return false;
        }

        private Optional<Integer> getDepartureDelay(int stopSequence) {
            if (this.tripUpdate != null) {
                int departure_time = this.tripUpdate.stopTimes.stream().filter((Predicate<StopTime>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getDepartureDelay$5(int com.conveyal.gtfs.model.StopTime ), (Lcom/conveyal/gtfs/model/StopTime;)Z)((int)stopSequence)).findFirst().orElseThrow((Supplier<RuntimeException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getDepartureDelay$6(), ()Ljava/lang/RuntimeException;)()).departure_time;
                logger.trace("stop_sequence {} scheduled departure {} updated departure {}", stopSequence, this.stopTime.departure_time, departure_time);
                return Optional.of(departure_time - this.stopTime.departure_time);
            }
            return Optional.empty();
        }

        private boolean isDepartureCancelled(int stopSequence) {
            if (this.tripUpdate != null) {
                return this.tripUpdate.cancelledDeparture.contains(stopSequence);
            }
            return false;
        }

        void finish() {
            Stop stop = this.gtfsFeed.stops.get(this.stopTime.stop_id);
            this.stops.add(new Trip.Stop(stop.stop_id, stop.stop_name, TripFromLabel.this.geometryFactory.createPoint(new Coordinate(stop.stop_lon, stop.stop_lat)), this.updatedArrival.map(Date::from).orElse(Date.from(this.arrivalTimeFromHopEdge)), Date.from(this.arrivalTimeFromHopEdge), this.updatedArrival.map(Date::from).orElse(null), this.isArrivalCancelled(this.stopSequence), null, null, null, this.isDepartureCancelled(this.stopSequence)));
            for (Trip.Stop tripStop : this.stops) {
                logger.trace("{}", (Object)tripStop);
            }
        }

        private void validateTripUpdate(GtfsReader.TripWithStopTimes tripUpdate) {
            Trip originalTrip = this.gtfsFeed.trips.get(tripUpdate.trip.trip_id);
            try {
                Iterable<StopTime> interpolatedStopTimesForTrip = this.gtfsFeed.getInterpolatedStopTimesForTrip(tripUpdate.trip.trip_id);
                long nStopTimes = StreamSupport.stream(interpolatedStopTimesForTrip.spliterator(), false).count();
                logger.trace("Original stop times: {} Updated stop times: {}", (Object)nStopTimes, (Object)tripUpdate.stopTimes.size());
                if (nStopTimes != (long)tripUpdate.stopTimes.size()) {
                    logger.error("Original stop times: {} Updated stop times: {}", (Object)nStopTimes, (Object)tripUpdate.stopTimes.size());
                }
            }
            catch (GTFSFeed.FirstAndLastStopsDoNotHaveTimes firstAndLastStopsDoNotHaveTimes) {
                throw new RuntimeException(firstAndLastStopsDoNotHaveTimes);
            }
        }

        private static /* synthetic */ RuntimeException lambda$getDepartureDelay$6() {
            return new RuntimeException("Stop time not found.");
        }

        private static /* synthetic */ boolean lambda$getDepartureDelay$5(int stopSequence, StopTime st) {
            return st.stop_sequence == stopSequence;
        }

        private static /* synthetic */ RuntimeException lambda$getArrivalDelay$4() {
            return new RuntimeException("Stop time not found.");
        }

        private static /* synthetic */ boolean lambda$getArrivalDelay$3(int stopSequence, StopTime st) {
            return st.stop_sequence == stopSequence;
        }
    }
}

