/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GraphHopper;
import com.graphhopper.isochrone.algorithm.DelaunayTriangulationIsolineBuilder;
import com.graphhopper.isochrone.algorithm.Isochrone;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="isochrone")
public class IsochroneResource {
    private static final Logger logger = LoggerFactory.getLogger(IsochroneResource.class);
    private final GraphHopper graphHopper;
    private final EncodingManager encodingManager;
    private final DelaunayTriangulationIsolineBuilder delaunayTriangulationIsolineBuilder;
    private final GeometryFactory geometryFactory = new GeometryFactory();

    @Inject
    public IsochroneResource(GraphHopper graphHopper, EncodingManager encodingManager, DelaunayTriangulationIsolineBuilder delaunayTriangulationIsolineBuilder) {
        this.graphHopper = graphHopper;
        this.encodingManager = encodingManager;
        this.delaunayTriangulationIsolineBuilder = delaunayTriangulationIsolineBuilder;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @QueryParam(value="vehicle") @DefaultValue(value="car") String vehicle, @QueryParam(value="buckets") @DefaultValue(value="1") int nBuckets, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="point") GHPoint point, @QueryParam(value="result") @DefaultValue(value="polygon") String resultStr, @QueryParam(value="time_limit") @DefaultValue(value="600") long timeLimitInSeconds, @QueryParam(value="distance_limit") @DefaultValue(value="-1") double distanceInMeter) {
        if (nBuckets > 20 || nBuckets < 1) {
            throw new IllegalArgumentException("Number of buckets has to be in the range [1, 20]");
        }
        if (point == null) {
            throw new IllegalArgumentException("point parameter cannot be null");
        }
        StopWatch sw = new StopWatch().start();
        if (!this.encodingManager.hasEncoder(vehicle)) {
            throw new IllegalArgumentException("vehicle not supported:" + vehicle);
        }
        FlagEncoder encoder = this.encodingManager.getEncoder(vehicle);
        DefaultEdgeFilter edgeFilter = DefaultEdgeFilter.allEdges(encoder);
        LocationIndex locationIndex = this.graphHopper.getLocationIndex();
        QueryResult qr = locationIndex.findClosest(point.lat, point.lon, edgeFilter);
        if (!qr.isValid()) {
            throw new IllegalArgumentException("Point not found:" + point);
        }
        GraphHopperStorage graph = this.graphHopper.getGraphHopperStorage();
        QueryGraph queryGraph = new QueryGraph(graph);
        queryGraph.lookup(Collections.singletonList(qr));
        HintsMap hintsMap = new HintsMap();
        RouteResource.initHints(hintsMap, uriInfo.getQueryParameters());
        Weighting weighting = this.graphHopper.createWeighting(hintsMap, encoder, graph);
        Isochrone isochrone = new Isochrone((Graph)queryGraph, weighting, reverseFlow);
        if (distanceInMeter > 0.0) {
            isochrone.setDistanceLimit(distanceInMeter);
        } else {
            isochrone.setTimeLimit(timeLimitInSeconds);
        }
        List<List<Coordinate>> buckets = isochrone.searchGPS(qr.getClosestNode(), nBuckets);
        if (isochrone.getVisitedNodes() > this.graphHopper.getMaxVisitedNodes() / 5) {
            throw new IllegalArgumentException("Server side reset: too many junction nodes would have to explored (" + isochrone.getVisitedNodes() + "). Let us know if you need this increased.");
        }
        int counter = 0;
        for (List<Coordinate> bucket : buckets) {
            if (bucket.size() < 2) {
                throw new IllegalArgumentException("Too few points found for bucket " + counter + ". Please try a different 'point', a smaller 'buckets' count or a larger 'time_limit'. And let us know if you think this is a bug!");
            }
            ++counter;
        }
        if ("pointlist".equalsIgnoreCase(resultStr)) {
            sw.stop();
            logger.info("took: " + sw.getSeconds() + ", visited nodes:" + isochrone.getVisitedNodes() + ", " + uriInfo.getQueryParameters());
            return Response.fromResponse(this.jsonSuccessResponse(buckets, sw.getSeconds())).header("X-GH-Took", "" + sw.getSeconds() * 1000.0f).build();
        }
        if ("polygon".equalsIgnoreCase(resultStr)) {
            ArrayList<JsonFeature> features = new ArrayList<JsonFeature>();
            List<Coordinate[]> polygonShells = this.delaunayTriangulationIsolineBuilder.calcList(buckets, buckets.size() - 1);
            for (Coordinate[] polygonShell : polygonShells) {
                JsonFeature feature = new JsonFeature();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("bucket", features.size());
                feature.setProperties(properties);
                feature.setGeometry(this.geometryFactory.createPolygon(polygonShell));
                features.add(feature);
            }
            sw.stop();
            logger.info("took: " + sw.getSeconds() + ", visited nodes:" + isochrone.getVisitedNodes() + ", " + uriInfo.getQueryParameters());
            return Response.fromResponse(this.jsonSuccessResponse(features, sw.getSeconds())).header("X-GH-Took", "" + sw.getSeconds() * 1000.0f).build();
        }
        throw new IllegalArgumentException("type not supported:" + resultStr);
    }

    private Response jsonSuccessResponse(Object result, float took) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.putPOJO("polygons", result);
        ObjectNode info = json.putObject("info");
        info.putArray("copyrights").add("GraphHopper").add("OpenStreetMap contributors");
        info.put("took", Math.round(took * 1000.0f));
        return Response.ok(json).build();
    }
}

