/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AbstractBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.ch.AStarCHEntry;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.ConsistentWeightApproximator;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;

public class AStarBidirectionEdgeCHNoSOD
extends AbstractBidirectionEdgeCHNoSOD {
    private final boolean useHeuristicForNodeOrder = false;
    private ConsistentWeightApproximator weightApprox;

    public AStarBidirectionEdgeCHNoSOD(Graph graph, TurnWeighting weighting) {
        super(graph, weighting);
        this.setApproximation(new BeelineWeightApproximator(this.nodeAccess, weighting).setDistanceCalc(Helper.DIST_PLANE));
    }

    @Override
    public void init(int from, double fromWeight, int to, double toWeight) {
        this.weightApprox.setFrom(from);
        this.weightApprox.setTo(to);
        super.init(from, fromWeight, to, toWeight);
    }

    @Override
    protected boolean fwdSearchCanBeStopped() {
        return this.getMinCurrFromPathWeight() > this.bestPath.getWeight();
    }

    @Override
    protected boolean bwdSearchCanBeStopped() {
        return this.getMinCurrToPathWeight() > this.bestPath.getWeight();
    }

    @Override
    protected AStarCHEntry createStartEntry(int node, double weight, boolean reverse) {
        double heapWeight = this.getHeapWeight(node, reverse, weight);
        return new AStarCHEntry(node, heapWeight, weight);
    }

    @Override
    protected SPTEntry createEntry(EdgeIteratorState edge, int incEdge, double weight, SPTEntry parent, boolean reverse) {
        int neighborNode = edge.getAdjNode();
        double heapWeight = this.getHeapWeight(neighborNode, reverse, weight);
        AStarCHEntry entry = new AStarCHEntry(edge.getEdge(), incEdge, neighborNode, heapWeight, weight);
        entry.parent = parent;
        return entry;
    }

    @Override
    protected void updateEntry(SPTEntry entry, EdgeIteratorState edge, int edgeId, double weight, SPTEntry parent, boolean reverse) {
        entry.edge = edge.getEdge();
        ((AStarCHEntry)entry).incEdge = edgeId;
        entry.weight = this.getHeapWeight(edge.getAdjNode(), reverse, weight);
        ((AStarCHEntry)entry).weightOfVisitedPath = weight;
        entry.parent = parent;
    }

    public WeightApproximator getApproximation() {
        return this.weightApprox.getApproximation();
    }

    public AStarBidirectionEdgeCHNoSOD setApproximation(WeightApproximator weightApproximator) {
        this.weightApprox = new ConsistentWeightApproximator(weightApproximator);
        return this;
    }

    private double getHeapWeight(int node, boolean reverse, double weightOfVisitedPath) {
        return weightOfVisitedPath;
    }

    private double getMinCurrFromPathWeight() {
        return this.currFrom.weight + this.weightApprox.approximate(this.currFrom.adjNode, false);
    }

    private double getMinCurrToPathWeight() {
        return this.currTo.weight + this.weightApprox.approximate(this.currTo.adjNode, true);
    }

    @Override
    public String getName() {
        return "astarbi|ch|edge_based|no_sod";
    }
}

