/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.routing.DijkstraBidirectionCHNoSOD;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;

public class DijkstraBidirectionCH
extends DijkstraBidirectionCHNoSOD {
    public DijkstraBidirectionCH(Graph graph, Weighting weighting) {
        super(graph, weighting);
    }

    @Override
    protected boolean fromEntryCanBeSkipped() {
        return this.entryIsStallable(this.currFrom, this.bestWeightMapFrom, this.inEdgeExplorer, false);
    }

    @Override
    protected boolean toEntryCanBeSkipped() {
        return this.entryIsStallable(this.currTo, this.bestWeightMapTo, this.outEdgeExplorer, true);
    }

    @Override
    public String getName() {
        return "dijkstrabi|ch";
    }

    @Override
    public String toString() {
        return this.getName() + "|" + this.weighting;
    }

    private boolean entryIsStallable(SPTEntry entry, IntObjectMap<SPTEntry> bestWeightMap, EdgeExplorer edgeExplorer, boolean reverse) {
        EdgeIterator iter = edgeExplorer.setBaseNode(entry.adjNode);
        while (iter.next()) {
            if (iter.getEdge() == entry.adjNode) continue;
            int traversalId = this.traversalMode.createTraversalId(iter, reverse);
            SPTEntry adjNode = bestWeightMap.get(traversalId);
            double precision = 0.001;
            if (adjNode == null) continue;
            double d = adjNode.weight;
            boolean bl = !reverse;
            if (!(d + this.weighting.calcWeight(iter, bl, this.getIncomingEdge(entry)) - entry.weight < -0.001)) continue;
            return true;
        }
        return false;
    }
}

