/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.coll.GHIntArrayList;
import com.graphhopper.routing.InstructionsFromEdges;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FinishInstruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.details.PathDetailsBuilder;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.details.PathDetailsFromEdges;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Path {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    final StopWatch extractSW = new StopWatch("extract");
    protected Graph graph;
    protected double distance;
    protected boolean reverseOrder = true;
    protected long time;
    protected SPTEntry sptEntry;
    protected int endNode = -1;
    private List<String> description;
    protected Weighting weighting;
    private FlagEncoder encoder;
    private boolean found;
    private int fromNode = -1;
    private GHIntArrayList edgeIds;
    private double weight = Double.MAX_VALUE;
    private NodeAccess nodeAccess;

    public Path(Graph graph, Weighting weighting) {
        this.graph = graph;
        this.nodeAccess = graph.getNodeAccess();
        this.weighting = weighting;
        this.encoder = weighting.getFlagEncoder();
        this.edgeIds = new GHIntArrayList();
    }

    Path(Path p) {
        this(p.graph, p.weighting);
        this.weight = p.weight;
        this.edgeIds = new GHIntArrayList(p.edgeIds);
        this.sptEntry = p.sptEntry;
    }

    public List<String> getDescription() {
        if (this.description == null) {
            return Collections.emptyList();
        }
        return this.description;
    }

    public Path setDescription(List<String> description) {
        this.description = description;
        return this;
    }

    public Path setSPTEntry(SPTEntry sptEntry) {
        this.sptEntry = sptEntry;
        return this;
    }

    protected void addEdge(int edge) {
        this.edgeIds.add(edge);
    }

    protected Path setEndNode(int end) {
        this.endNode = end;
        return this;
    }

    private int getFromNode() {
        if (this.fromNode < 0) {
            throw new IllegalStateException("Call extract() before retrieving fromNode");
        }
        return this.fromNode;
    }

    protected Path setFromNode(int from) {
        this.fromNode = from;
        return this;
    }

    public int getEdgeCount() {
        return this.edgeIds.size();
    }

    public boolean isFound() {
        return this.found;
    }

    public Path setFound(boolean found) {
        this.found = found;
        return this;
    }

    void reverseOrder() {
        if (!this.reverseOrder) {
            throw new IllegalStateException("Switching order multiple times is not supported");
        }
        this.reverseOrder = false;
        this.edgeIds.reverse();
    }

    public Path setDistance(double distance) {
        this.distance = distance;
        return this;
    }

    public double getDistance() {
        return this.distance;
    }

    public long getTime() {
        return this.time;
    }

    public double getWeight() {
        return this.weight;
    }

    public Path setWeight(double w) {
        this.weight = w;
        return this;
    }

    public Path extract() {
        if (this.isFound()) {
            throw new IllegalStateException("Extract can only be called once");
        }
        this.extractSW.start();
        SPTEntry currEdge = this.sptEntry;
        this.setEndNode(currEdge.adjNode);
        boolean nextEdgeValid = EdgeIterator.Edge.isValid(currEdge.edge);
        while (nextEdgeValid) {
            nextEdgeValid = EdgeIterator.Edge.isValid(currEdge.parent.edge);
            int nextEdge = nextEdgeValid ? currEdge.parent.edge : -1;
            this.processEdge(currEdge.edge, currEdge.adjNode, nextEdge);
            currEdge = currEdge.parent;
        }
        this.setFromNode(currEdge.adjNode);
        this.reverseOrder();
        this.extractSW.stop();
        return this.setFound(true);
    }

    public EdgeIteratorState getFinalEdge() {
        return this.graph.getEdgeIteratorState(this.edgeIds.get(this.edgeIds.size() - 1), this.endNode);
    }

    public long getExtractTime() {
        return this.extractSW.getNanos();
    }

    public String getDebugInfo() {
        return this.extractSW.toString();
    }

    protected void processEdge(int edgeId, int adjNode, int prevEdgeId) {
        EdgeIteratorState iter = this.graph.getEdgeIteratorState(edgeId, adjNode);
        this.distance += iter.getDistance();
        this.time += this.weighting.calcMillis(iter, false, prevEdgeId);
        this.addEdge(edgeId);
    }

    private void forEveryEdge(EdgeVisitor visitor) {
        int tmpNode = this.getFromNode();
        int len = this.edgeIds.size();
        int prevEdgeId = -1;
        for (int i = 0; i < len; ++i) {
            EdgeIteratorState edgeBase = this.graph.getEdgeIteratorState(this.edgeIds.get(i), tmpNode);
            if (edgeBase == null) {
                throw new IllegalStateException("Edge " + this.edgeIds.get(i) + " was empty when requested with node " + tmpNode + ", array index:" + i + ", edges:" + this.edgeIds.size());
            }
            tmpNode = edgeBase.getBaseNode();
            edgeBase = this.graph.getEdgeIteratorState(edgeBase.getEdge(), tmpNode);
            visitor.next(edgeBase, i, prevEdgeId);
            prevEdgeId = edgeBase.getEdge();
        }
        visitor.finish();
    }

    public List<EdgeIteratorState> calcEdges() {
        final ArrayList<EdgeIteratorState> edges = new ArrayList<EdgeIteratorState>(this.edgeIds.size());
        if (this.edgeIds.isEmpty()) {
            return edges;
        }
        this.forEveryEdge(new EdgeVisitor(){

            @Override
            public void next(EdgeIteratorState eb, int index, int prevEdgeId) {
                edges.add(eb);
            }

            @Override
            public void finish() {
            }
        });
        return edges;
    }

    public IntIndexedContainer calcNodes() {
        final IntArrayList nodes = new IntArrayList(this.edgeIds.size() + 1);
        if (this.edgeIds.isEmpty()) {
            if (this.isFound()) {
                nodes.add(this.endNode);
            }
            return nodes;
        }
        int tmpNode = this.getFromNode();
        nodes.add(tmpNode);
        this.forEveryEdge(new EdgeVisitor(){

            @Override
            public void next(EdgeIteratorState eb, int index, int prevEdgeId) {
                nodes.add(eb.getAdjNode());
            }

            @Override
            public void finish() {
            }
        });
        return nodes;
    }

    public PointList calcPoints() {
        final PointList points = new PointList(this.edgeIds.size() + 1, this.nodeAccess.is3D());
        if (this.edgeIds.isEmpty()) {
            if (this.isFound()) {
                points.add(this.graph.getNodeAccess(), this.endNode);
            }
            return points;
        }
        int tmpNode = this.getFromNode();
        points.add(this.nodeAccess, tmpNode);
        this.forEveryEdge(new EdgeVisitor(){

            @Override
            public void next(EdgeIteratorState eb, int index, int prevEdgeId) {
                PointList pl = eb.fetchWayGeometry(2);
                for (int j = 0; j < pl.getSize(); ++j) {
                    points.add(pl, j);
                }
            }

            @Override
            public void finish() {
            }
        });
        return points;
    }

    public InstructionList calcInstructions(BooleanEncodedValue roundaboutEnc, Translation tr) {
        InstructionList ways = new InstructionList(this.edgeIds.size() / 4, tr);
        if (this.edgeIds.isEmpty()) {
            if (this.isFound()) {
                ways.add(new FinishInstruction(this.nodeAccess, this.endNode));
            }
            return ways;
        }
        this.forEveryEdge(new InstructionsFromEdges(this.getFromNode(), this.graph, this.weighting, this.encoder, roundaboutEnc, this.nodeAccess, tr, ways));
        return ways;
    }

    public Map<String, List<PathDetail>> calcDetails(List<String> requestedPathDetails, PathDetailsBuilderFactory pathBuilderFactory, int previousIndex) {
        if (!this.isFound() || requestedPathDetails.isEmpty()) {
            return Collections.emptyMap();
        }
        List<PathDetailsBuilder> pathBuilders = pathBuilderFactory.createPathDetailsBuilders(requestedPathDetails, this.encoder, this.weighting);
        if (pathBuilders.isEmpty()) {
            return Collections.emptyMap();
        }
        this.forEveryEdge(new PathDetailsFromEdges(pathBuilders, previousIndex));
        HashMap<String, List<PathDetail>> pathDetails = new HashMap<String, List<PathDetail>>(pathBuilders.size());
        for (PathDetailsBuilder builder : pathBuilders) {
            Map.Entry<String, List<PathDetail>> entry = builder.build();
            List<PathDetail> existing = pathDetails.put(entry.getKey(), entry.getValue());
            if (existing == null) continue;
            throw new IllegalStateException("Some PathDetailsBuilders use duplicate key: " + entry.getKey());
        }
        return pathDetails;
    }

    public String toString() {
        return "found: " + this.found + ", weight: " + this.weight + ", time: " + this.time + ", distance: " + this.distance + ", edges: " + this.edgeIds.size();
    }

    public String toDetailsString() {
        String str = "";
        for (int i = 0; i < this.edgeIds.size(); ++i) {
            if (i > 0) {
                str = str + "->";
            }
            str = str + this.edgeIds.get(i);
        }
        return this.toString() + ", found:" + this.isFound() + ", " + str;
    }

    public static interface EdgeVisitor {
        public void next(EdgeIteratorState var1, int var2, int var3);

        public void finish();
    }
}

