/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.profiles;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntIntHashMap;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.SimpleIntEncodedValue;
import com.graphhopper.storage.IntsRef;
import java.util.Collection;

public final class MappedDecimalEncodedValue
extends SimpleIntEncodedValue
implements DecimalEncodedValue {
    private final int[] toValueMap;
    private final IntIntHashMap toStorageMap;
    private final double precision;

    public MappedDecimalEncodedValue(String name, Collection<Double> values, double precision, boolean storeBothDirections) {
        super(name, 32 - Integer.numberOfLeadingZeros(values.size()), storeBothDirections);
        this.precision = precision;
        this.toValueMap = new int[values.size()];
        this.toStorageMap = new IntIntHashMap(values.size());
        int index = 0;
        IntHashSet dupCheck = new IntHashSet();
        for (double val : values) {
            int intVal = this.toInt(val);
            if (!dupCheck.add(intVal)) {
                throw new IllegalArgumentException("The value " + val + " was converted to " + intVal + " but this already exists. Remove it to improve efficiency.");
            }
            this.toValueMap[index] = intVal;
            this.toStorageMap.put(intVal, index);
            ++index;
        }
    }

    private int toInt(double val) {
        return (int)Math.round(val / this.precision);
    }

    @Override
    public final void setDecimal(boolean reverse, IntsRef ref, double value) {
        int storageInt = this.toStorageMap.getOrDefault(this.toInt(value), -1);
        if (storageInt < 0) {
            throw new IllegalArgumentException("Cannot find value " + value + " (" + this.toInt(value) + ") in map to store it");
        }
        super.setInt(reverse, ref, storageInt);
    }

    @Override
    public final double getDecimal(boolean reverse, IntsRef ref) {
        int value = this.getInt(reverse, ref);
        return (double)this.toValueMap[value] * this.precision;
    }
}

