/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.profiles;

import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.storage.IntsRef;
import java.util.Locale;

public class SimpleIntEncodedValue
implements IntEncodedValue {
    private final String name;
    protected int fwdDataIndex;
    protected int bwdDataIndex;
    final int bits;
    long maxValue;
    int fwdShift = -1;
    int bwdShift = -1;
    int fwdMask;
    int bwdMask;
    boolean storeBothDirections;

    SimpleIntEncodedValue() {
        this.bits = 0;
        this.name = "";
    }

    public SimpleIntEncodedValue(String name, int bits) {
        this(name, bits, false);
    }

    public SimpleIntEncodedValue(String name, int bits, boolean storeBothDirections) {
        if (!name.toLowerCase(Locale.ROOT).equals(name)) {
            throw new IllegalArgumentException("EncodedValue name must be lower case but was " + name);
        }
        if (bits <= 0) {
            throw new IllegalArgumentException(name + ": bits cannot be zero or negative");
        }
        if (bits > 32) {
            throw new IllegalArgumentException(name + ": at the moment bits cannot be >32");
        }
        this.bits = bits;
        this.name = name;
        this.storeBothDirections = storeBothDirections;
    }

    @Override
    public final int init(EncodedValue.InitializerConfig init) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot call init multiple times");
        }
        init.next(this.bits);
        this.fwdMask = init.bitMask;
        this.fwdDataIndex = init.dataIndex;
        this.fwdShift = init.shift;
        if (this.storeBothDirections) {
            init.next(this.bits);
            this.bwdMask = init.bitMask;
            this.bwdDataIndex = init.dataIndex;
            this.bwdShift = init.shift;
        }
        this.maxValue = (1L << this.bits) - 1L;
        return this.storeBothDirections ? 2 * this.bits : this.bits;
    }

    private boolean isInitialized() {
        return this.fwdMask != 0;
    }

    private void checkValue(int value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("EncodedValue " + this.getName() + " not initialized");
        }
        if ((long)value > this.maxValue) {
            throw new IllegalArgumentException(this.name + " value too large for encoding: " + value + ", maxValue:" + this.maxValue);
        }
        if (value < 0) {
            throw new IllegalArgumentException("negative value for " + this.name + " not allowed! " + value);
        }
    }

    @Override
    public final void setInt(boolean reverse, IntsRef ref, int value) {
        this.checkValue(value);
        this.uncheckedSet(reverse, ref, value);
    }

    final void uncheckedSet(boolean reverse, IntsRef ref, int value) {
        if (this.storeBothDirections && reverse) {
            int flags = ref.ints[this.bwdDataIndex + ref.offset];
            ref.ints[this.bwdDataIndex + ref.offset] = (flags &= ~this.bwdMask) | (value <<= this.bwdShift);
        } else {
            int flags = ref.ints[this.fwdDataIndex + ref.offset];
            ref.ints[this.fwdDataIndex + ref.offset] = (flags &= ~this.fwdMask) | (value <<= this.fwdShift);
        }
    }

    @Override
    public final int getInt(boolean reverse, IntsRef ref) {
        if (reverse && this.storeBothDirections) {
            int flags = ref.ints[this.bwdDataIndex + ref.offset];
            return (flags & this.bwdMask) >>> this.bwdShift;
        }
        int flags = ref.ints[this.fwdDataIndex + ref.offset];
        return (flags & this.fwdMask) >>> this.fwdShift;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.getName() + "|bits=" + this.bits + "|fwd_shift=" + this.fwdShift + "|store_both_directions=" + this.storeBothDirections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleIntEncodedValue that = (SimpleIntEncodedValue)o;
        if (this.fwdDataIndex != that.fwdDataIndex) {
            return false;
        }
        if (this.bwdDataIndex != that.bwdDataIndex) {
            return false;
        }
        if (this.bits != that.bits) {
            return false;
        }
        if (this.fwdShift != that.fwdShift) {
            return false;
        }
        if (this.bwdShift != that.bwdShift) {
            return false;
        }
        if (this.storeBothDirections != that.storeBothDirections) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fwdDataIndex;
        result = 31 * result + this.bwdDataIndex;
        result = 31 * result + this.bits;
        result = 31 * result + this.fwdShift;
        result = 31 * result + this.bwdShift;
        result = 31 * result + (this.storeBothDirections ? 1 : 0);
        return result;
    }
}

