/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.FactorizedDecimalEncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.routing.profiles.SimpleIntEncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.TransportationMode;
import com.graphhopper.routing.weighting.GenericWeighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.PMap;
import com.graphhopper.util.Translation;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFlagEncoder
extends AbstractFlagEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(DataFlagEncoder.class);
    private static final Map<String, Double> DEFAULT_SPEEDS = new LinkedHashMap<String, Double>(){
        {
            this.put("motorway", 100.0);
            this.put("motorway_link", 70.0);
            this.put("motorroad", 90.0);
            this.put("trunk", 70.0);
            this.put("trunk_link", 65.0);
            this.put("primary", 65.0);
            this.put("primary_link", 60.0);
            this.put("secondary", 60.0);
            this.put("secondary_link", 50.0);
            this.put("tertiary", 50.0);
            this.put("tertiary_link", 40.0);
            this.put("unclassified", 30.0);
            this.put("residential", 30.0);
            this.put("living_street", 5.0);
            this.put("service", 20.0);
            this.put("road", 20.0);
            this.put("forestry", 15.0);
            this.put("track", 15.0);
        }
    };
    private final Map<String, Integer> surfaceMap = new HashMap<String, Integer>();
    private final Map<String, Integer> highwayMap = new HashMap<String, Integer>();
    private final Map<String, Integer> accessMap = new HashMap<String, Integer>();
    private final List<String> transportModeList = new ArrayList<String>();
    private final Map<String, Integer> transportModeMap = new HashMap<String, Integer>();
    private final int transportModeTunnelValue;
    private final int transportModeBridgeValue;
    private final int transportModeFordValue;
    private IntEncodedValue dynAccessEncoder;
    private DecimalEncodedValue carMaxspeedEncoder;
    private DecimalEncodedValue heightEncoder;
    private DecimalEncodedValue weightEncoder;
    private DecimalEncodedValue widthEncoder;
    private IntEncodedValue surfaceEncoder;
    private IntEncodedValue highwayEncoder;
    private IntEncodedValue transportModeEncoder;
    private boolean storeHeight = false;
    private boolean storeWeight = false;
    private boolean storeWidth = false;
    private IntEncodedValue spatialEncoder;
    private SpatialRuleLookup spatialRuleLookup = SpatialRuleLookup.EMPTY;

    public DataFlagEncoder() {
        this(5, 5.0, 0);
    }

    public DataFlagEncoder(PMap properties) {
        this((int)properties.getLong("speed_bits", 5L), properties.getDouble("speed_factor", 5.0), properties.getBool("turn_costs", false) ? 1 : 0);
        this.properties = properties;
        this.setStoreHeight(properties.getBool("store_height", false));
        this.setStoreWeight(properties.getBool("store_weight", false));
        this.setStoreWidth(properties.getBool("store_width", false));
    }

    public DataFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        super(speedBits, speedFactor, maxTurnCosts);
        this.maxPossibleSpeed = 140;
        List<String> highwayList = Arrays.asList("_default", "motorway", "motorway_link", "motorroad", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "residential", "living_street", "service", "road", "track", "forestry", "cycleway", "steps", "path", "footway", "pedestrian", "ferry", "shuttle_train");
        int counter = 0;
        for (String string : highwayList) {
            this.highwayMap.put(string, counter++);
        }
        this.transportModeList.addAll(Arrays.asList("_default", "bridge", "tunnel", "ford", "aerialway"));
        counter = 0;
        for (String string : this.transportModeList) {
            this.transportModeMap.put(string, counter++);
        }
        this.transportModeTunnelValue = this.transportModeMap.get("tunnel");
        this.transportModeBridgeValue = this.transportModeMap.get("bridge");
        this.transportModeFordValue = this.transportModeMap.get("ford");
        List<String> surfaceList = Arrays.asList("_default", "asphalt", "unpaved", "paved", "gravel", "ground", "dirt", "grass", "concrete", "paving_stones", "sand", "compacted", "cobblestone", "mud", "ice");
        counter = 0;
        for (String s : surfaceList) {
            this.surfaceMap.put(s, counter++);
        }
        this.restrictions.addAll(Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access"));
        List<String> list = Arrays.asList("yes", "destination", "private", "no");
        counter = 0;
        for (String s : list) {
            this.accessMap.put(s, counter++);
        }
        this.accessMap.put("designated", this.accessMap.get("yes"));
        this.accessMap.put("permissive", this.accessMap.get("yes"));
        this.accessMap.put("customers", this.accessMap.get("destination"));
        this.accessMap.put("delivery", this.accessMap.get("destination"));
    }

    @Override
    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue, String prefix, int index) {
        super.createEncodedValues(registerNewEncodedValue, prefix, index);
        this.carMaxspeedEncoder = new FactorizedDecimalEncodedValue(prefix + "car_maxspeed", this.speedBits, this.speedFactor, true);
        registerNewEncodedValue.add(this.carMaxspeedEncoder);
        if (this.isStoreHeight()) {
            this.heightEncoder = new FactorizedDecimalEncodedValue(prefix + "height", 7, 0.1, false);
            registerNewEncodedValue.add(this.heightEncoder);
        }
        if (this.isStoreWeight()) {
            this.weightEncoder = new FactorizedDecimalEncodedValue(prefix + "weight", 10, 0.1, false);
            registerNewEncodedValue.add(this.weightEncoder);
        }
        if (this.isStoreWidth()) {
            this.widthEncoder = new FactorizedDecimalEncodedValue(prefix + "width", 6, 0.1, false);
            registerNewEncodedValue.add(this.widthEncoder);
        }
        this.highwayEncoder = new SimpleIntEncodedValue(prefix + "highway", 5, false);
        registerNewEncodedValue.add(this.highwayEncoder);
        this.surfaceEncoder = new SimpleIntEncodedValue(prefix + "surface", 4, false);
        registerNewEncodedValue.add(this.surfaceEncoder);
        this.transportModeEncoder = new SimpleIntEncodedValue(prefix + "transport_mode", 3, false);
        registerNewEncodedValue.add(this.transportModeEncoder);
        this.dynAccessEncoder = new SimpleIntEncodedValue(prefix + "car_dyn_access", 3, false);
        registerNewEncodedValue.add(this.dynAccessEncoder);
        int tmpMax = this.spatialRuleLookup.size() - 1;
        int bits = 32 - Integer.numberOfLeadingZeros(tmpMax);
        if (bits > 0) {
            this.spatialEncoder = new SimpleIntEncodedValue("spatial_location", bits, false);
            registerNewEncodedValue.add(this.spatialEncoder);
        }
        this.speedEncoder = this.carMaxspeedEncoder;
    }

    @Override
    protected void flagsDefault(IntsRef edgeFlags, boolean forward, boolean backward) {
        this.accessEnc.setBool(false, edgeFlags, forward);
        this.accessEnc.setBool(true, edgeFlags, backward);
    }

    @Override
    public long handleRelationTags(long oldRelationFlags, ReaderRelation relation) {
        return oldRelationFlags;
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        if (this.getHighwayValue(way) == 0) {
            return EncodingManager.Access.CAN_SKIP;
        }
        return EncodingManager.Access.WAY;
    }

    int getHighwayValue(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        Integer hwValue = this.highwayMap.get(highwayValue);
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            hwValue = 0;
        }
        if (hwValue == null) {
            hwValue = 0;
            if (way.hasTag("route", (Set<String>)this.ferries)) {
                String motorcarTag = way.getTag("motorcar");
                if (motorcarTag == null) {
                    motorcarTag = way.getTag("motor_vehicle");
                }
                if (motorcarTag == null && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0]) || "yes".equals(motorcarTag)) {
                    hwValue = this.highwayMap.get("ferry");
                }
            }
        }
        return hwValue;
    }

    int getAccessValue(ReaderWay way) {
        int accessValue = 0;
        for (String restriction : this.restrictions) {
            Integer tmpAccessValue = this.accessMap.get(way.getTag(restriction, "yes"));
            if (tmpAccessValue == null || tmpAccessValue <= accessValue) continue;
            accessValue = tmpAccessValue;
        }
        if (accessValue == 0) {
            switch (this.getSpatialRule(way).getAccess(way.getTag("highway", ""), TransportationMode.MOTOR_VEHICLE, SpatialRule.Access.YES)) {
                case YES: {
                    accessValue = this.accessMap.get("yes");
                    break;
                }
                case CONDITIONAL: {
                    accessValue = this.accessMap.get("destination");
                    break;
                }
                case NO: {
                    accessValue = this.accessMap.get("no");
                }
            }
        }
        return accessValue;
    }

    public SpatialRule.Access getAccessValue(IntsRef flags) {
        int accessValue = this.dynAccessEncoder.getInt(false, flags);
        switch (accessValue) {
            case 0: {
                return SpatialRule.Access.YES;
            }
            case 3: {
                return SpatialRule.Access.NO;
            }
        }
        return SpatialRule.Access.CONDITIONAL;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        if (access.canSkip()) {
            return edgeFlags;
        }
        try {
            GHPoint estimatedCenter;
            boolean isOneway;
            String surfaceValue;
            Integer sValue;
            double bwdSpeed;
            double fwdSpeed;
            int hwValue = this.getHighwayValue(way);
            if (hwValue == 0) {
                return edgeFlags;
            }
            if (access.isFerry()) {
                hwValue = this.highwayMap.get("ferry");
            }
            this.highwayEncoder.setInt(false, edgeFlags, hwValue);
            double maxSpeed = DataFlagEncoder.parseSpeed(way.getTag("maxspeed"));
            if (maxSpeed < 0.0) {
                maxSpeed = this.getSpatialRule(way).getMaxSpeed(way.getTag("highway", ""), maxSpeed);
            }
            if ((fwdSpeed = DataFlagEncoder.parseSpeed(way.getTag("maxspeed:forward"))) < 0.0 && maxSpeed > 0.0) {
                fwdSpeed = maxSpeed;
            }
            if (fwdSpeed > this.getMaxPossibleSpeed()) {
                fwdSpeed = this.getMaxPossibleSpeed();
            }
            if ((bwdSpeed = DataFlagEncoder.parseSpeed(way.getTag("maxspeed:backward"))) < 0.0 && maxSpeed > 0.0) {
                bwdSpeed = maxSpeed;
            }
            if (bwdSpeed > this.getMaxPossibleSpeed()) {
                bwdSpeed = this.getMaxPossibleSpeed();
            }
            if (fwdSpeed > 0.0) {
                this.carMaxspeedEncoder.setDecimal(false, edgeFlags, fwdSpeed);
            }
            if (bwdSpeed > 0.0) {
                this.carMaxspeedEncoder.setDecimal(true, edgeFlags, bwdSpeed);
            }
            if (this.isStoreHeight()) {
                List<String> heightTags = Arrays.asList("maxheight", "maxheight:physical");
                this.extractMeter(edgeFlags, way, this.heightEncoder, heightTags);
            }
            if (this.isStoreWeight()) {
                List<String> weightTags = Arrays.asList("maxweight", "maxgcweight");
                this.extractTons(edgeFlags, way, this.weightEncoder, weightTags);
            }
            if (this.isStoreWidth()) {
                List<String> widthTags = Arrays.asList("maxwidth", "maxwidth:physical");
                this.extractMeter(edgeFlags, way, this.widthEncoder, widthTags);
            }
            if ((sValue = this.surfaceMap.get(surfaceValue = way.getTag("surface"))) == null) {
                sValue = 0;
            }
            this.surfaceEncoder.setInt(false, edgeFlags, sValue);
            int tmValue = 0;
            for (String tm : this.transportModeList) {
                if (!way.hasTag(tm, new String[0])) continue;
                tmValue = this.transportModeMap.get(tm);
                break;
            }
            this.transportModeEncoder.setInt(false, edgeFlags, tmValue);
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeFlags);
            boolean bl = isOneway = way.hasTag("oneway", (Set<String>)this.oneways) || way.hasTag("vehicle:backward", new String[0]) || way.hasTag("vehicle:forward", new String[0]) || way.hasTag("motor_vehicle:backward", new String[0]) || way.hasTag("motor_vehicle:forward", new String[0]);
            if (isOneway || isRoundabout) {
                boolean isBackward;
                boolean bl2 = isBackward = way.hasTag("oneway", (Object)"-1") || way.hasTag("vehicle:forward", (Object)"no") || way.hasTag("motor_vehicle:forward", (Object)"no");
                if (isBackward) {
                    this.accessEnc.setBool(true, edgeFlags, true);
                } else {
                    this.accessEnc.setBool(false, edgeFlags, true);
                }
            } else {
                this.accessEnc.setBool(false, edgeFlags, true);
                this.accessEnc.setBool(true, edgeFlags, true);
            }
            this.dynAccessEncoder.setInt(false, edgeFlags, this.getAccessValue(way));
            if (this.spatialEncoder != null && (estimatedCenter = (GHPoint)way.getTag("estimated_center", null)) != null) {
                SpatialRule rule = this.spatialRuleLookup.lookupRule(estimatedCenter);
                this.spatialEncoder.setInt(false, edgeFlags, this.spatialRuleLookup.getSpatialId(rule));
            }
            return edgeFlags;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while parsing way " + way.toString(), ex);
        }
    }

    private SpatialRule getSpatialRule(ReaderWay way) {
        GHPoint estmCentre = way.getTag("estimated_center", null);
        if (estmCentre != null) {
            return this.spatialRuleLookup.lookupRule(estmCentre);
        }
        return SpatialRule.EMPTY;
    }

    private void extractMeter(IntsRef edgeFlags, ReaderWay way, DecimalEncodedValue valueEncoder, List<String> keys) {
        double val;
        String value = way.getFirstPriorityTag(keys);
        if (Helper.isEmpty(value)) {
            return;
        }
        try {
            val = DataFlagEncoder.stringToMeter(value);
        }
        catch (Exception ex) {
            LOG.warn("Unable to extract meter from malformed road attribute '{}' for way (OSM_ID = {}).", value, way.getId(), ex);
            return;
        }
        try {
            valueEncoder.setDecimal(false, edgeFlags, val);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to process value '{}' for way (OSM_ID = {}).", val, way.getId(), e);
        }
    }

    private void extractTons(IntsRef edgeFlags, ReaderWay way, DecimalEncodedValue valueEncoder, List<String> keys) {
        double val;
        String value = way.getFirstPriorityTag(keys);
        if (Helper.isEmpty(value)) {
            return;
        }
        try {
            val = DataFlagEncoder.stringToTons(value);
        }
        catch (Throwable t) {
            LOG.warn("Unable to extract tons from malformed road attribute '{}' for way (OSM_ID = {}).", value, way.getId(), t);
            return;
        }
        try {
            valueEncoder.setDecimal(false, edgeFlags, val);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to process tons value '{}' for way (OSM_ID = {}).", val, way.getId(), e);
        }
    }

    public static double stringToTons(String value) {
        value = Helper.toLowerCase(value).replaceAll(" ", "").replaceAll("(tons|ton)", "t");
        value = value.replace("mgw", "").trim();
        double factor = 1.0;
        if (value.endsWith("t")) {
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("lbs")) {
            value = value.substring(0, value.length() - 3);
            factor = 4.5359237E-4;
        }
        return Double.parseDouble(value) * factor;
    }

    public static double stringToMeter(String value) {
        value = Helper.toLowerCase(value).replaceAll(" ", "").replaceAll("(meters|meter|mtrs|mtr|mt|m\\.)", "m");
        double factor = 1.0;
        double offset = 0.0;
        if ((value = value.replaceAll("(\\\"|'')", "in").replaceAll("('|feet)", "ft")).startsWith("~") || value.contains("approx")) {
            value = value.replaceAll("(\\~|approx)", "").trim();
            factor = 0.8;
        }
        if (value.endsWith("in")) {
            int startIndex = value.indexOf("ft");
            startIndex = startIndex < 0 ? 0 : (startIndex += 2);
            String inchValue = value.substring(startIndex, value.length() - 2);
            value = value.substring(0, startIndex);
            offset = Double.parseDouble(inchValue) * 0.0254;
        }
        if (value.endsWith("ft")) {
            value = value.substring(0, value.length() - 2);
            factor *= 0.3048;
        } else if (value.endsWith("m")) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.isEmpty()) {
            return offset;
        }
        return Double.parseDouble(value) * factor + offset;
    }

    public int getSpatialId(IntsRef flags) {
        if (this.spatialEncoder == null) {
            return -1;
        }
        return this.spatialEncoder.getInt(false, flags);
    }

    public void setSpatialId(IntsRef flags, int id) {
        this.spatialEncoder.setInt(false, flags, id);
    }

    public int getHighway(EdgeIteratorState edge) {
        return this.highwayEncoder.getInt(false, edge.getFlags());
    }

    public String getHighwayAsString(EdgeIteratorState edge) {
        int val = this.getHighway(edge);
        for (Map.Entry<String, Integer> e : this.highwayMap.entrySet()) {
            if (e.getValue() != val) continue;
            return e.getKey();
        }
        return null;
    }

    double[] getHighwaySpeedMap(Map<String, Double> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map cannot be null when calling getHighwaySpeedMap");
        }
        double[] res = new double[this.highwayMap.size()];
        for (Map.Entry<String, Double> e : map.entrySet()) {
            Integer integ = this.highwayMap.get(e.getKey());
            if (integ == null) {
                throw new IllegalArgumentException("Graph not prepared for highway=" + e.getKey());
            }
            if (e.getValue() < 0.0) {
                throw new IllegalArgumentException("Negative speed " + e.getValue() + " not allowed. highway=" + e.getKey());
            }
            res[integ.intValue()] = e.getValue();
        }
        return res;
    }

    public int getSurface(EdgeIteratorState edge) {
        return this.surfaceEncoder.getInt(false, edge.getFlags());
    }

    public String getSurfaceAsString(EdgeIteratorState edge) {
        int val = this.getSurface(edge);
        for (Map.Entry<String, Integer> e : this.surfaceMap.entrySet()) {
            if (e.getValue() != val) continue;
            return e.getKey();
        }
        return null;
    }

    public int getTransportMode(EdgeIteratorState edge) {
        return this.transportModeEncoder.getInt(false, edge.getFlags());
    }

    public boolean isTransportModeTunnel(EdgeIteratorState edge) {
        return this.transportModeEncoder.getInt(false, edge.getFlags()) == this.transportModeTunnelValue;
    }

    public boolean isTransportModeBridge(EdgeIteratorState edge) {
        return this.transportModeEncoder.getInt(false, edge.getFlags()) == this.transportModeBridgeValue;
    }

    public boolean isTransportModeFord(IntsRef edgeFlags) {
        return this.transportModeEncoder.getInt(false, edgeFlags) == this.transportModeFordValue;
    }

    public String getTransportModeAsString(EdgeIteratorState edge) {
        int val = this.getTransportMode(edge);
        for (Map.Entry<String, Integer> e : this.transportModeMap.entrySet()) {
            if (e.getValue() != val) continue;
            return e.getKey();
        }
        return null;
    }

    public double[] getTransportModeMap(Map<String, Double> map) {
        double[] res = new double[this.transportModeMap.size()];
        for (Map.Entry<String, Double> e : map.entrySet()) {
            Integer integ = this.transportModeMap.get(e.getKey());
            if (integ == null) {
                throw new IllegalArgumentException("Graph not prepared for transport_mode=" + e.getKey());
            }
            if (e.getValue() < 0.0) {
                throw new IllegalArgumentException("Negative speed " + e.getValue() + " not allowed. transport_mode=" + e.getKey());
            }
            res[integ.intValue()] = e.getValue();
        }
        return res;
    }

    public int getAccessType(String accessStr) {
        return 0;
    }

    public double getMaxspeed(EdgeIteratorState edge, int accessType, boolean reverse) {
        double val;
        double d = val = reverse ? edge.getReverse(this.carMaxspeedEncoder) : edge.get(this.carMaxspeedEncoder);
        if (val < 0.0) {
            throw new IllegalStateException("maxspeed cannot be negative, edge:" + edge.getEdge() + ", access type" + accessType + ", reverse:" + reverse);
        }
        if (val == 0.0) {
            return -1.0;
        }
        return val;
    }

    public double getHeight(EdgeIteratorState edge) {
        IntsRef edgeFlags = edge.getFlags();
        return this.heightEncoder.getDecimal(false, edgeFlags);
    }

    public double getWeight(EdgeIteratorState edge) {
        IntsRef edgeFlags = edge.getFlags();
        return this.weightEncoder.getDecimal(false, edgeFlags);
    }

    public double getWidth(EdgeIteratorState edge) {
        IntsRef edgeFlags = edge.getFlags();
        return this.widthEncoder.getDecimal(false, edgeFlags);
    }

    @Override
    protected void setSpeed(boolean reverse, IntsRef edgeFlags, double speed) {
        throw new RuntimeException("do not call setSpeed");
    }

    @Override
    double getSpeed(boolean reverse, IntsRef flags) {
        throw new UnsupportedOperationException("Calculate speed via more customizable Weighting.calcMillis method");
    }

    @Override
    protected double getMaxSpeed(ReaderWay way) {
        throw new RuntimeException("do not call getMaxSpeed(ReaderWay)");
    }

    @Override
    public double getMaxSpeed() {
        throw new RuntimeException("do not call getMaxSpeed");
    }

    public double getMaxPossibleSpeed() {
        return this.maxPossibleSpeed;
    }

    @Override
    public boolean supports(Class<?> feature) {
        boolean ret = super.supports(feature);
        if (ret) {
            return true;
        }
        return GenericWeighting.class.isAssignableFrom(feature);
    }

    public DataFlagEncoder setStoreHeight(boolean storeHeight) {
        this.storeHeight = storeHeight;
        return this;
    }

    public boolean isStoreHeight() {
        return this.storeHeight;
    }

    public DataFlagEncoder setStoreWeight(boolean storeWeight) {
        this.storeWeight = storeWeight;
        return this;
    }

    public boolean isStoreWeight() {
        return this.storeWeight;
    }

    public DataFlagEncoder setStoreWidth(boolean storeWidth) {
        this.storeWidth = storeWidth;
        return this;
    }

    public boolean isStoreWidth() {
        return this.storeWidth;
    }

    public DataFlagEncoder setSpatialRuleLookup(SpatialRuleLookup spatialRuleLookup) {
        this.spatialRuleLookup = spatialRuleLookup;
        return this;
    }

    @Override
    public InstructionAnnotation getAnnotation(IntsRef flags, Translation tr) {
        if (this.isTransportModeFord(flags)) {
            return new InstructionAnnotation(1, tr.tr("way_contains_ford", new Object[0]));
        }
        return super.getAnnotation(flags, tr);
    }

    @Override
    protected String getPropertiesString() {
        return super.getPropertiesString() + "|store_height=" + this.storeHeight + "|store_weight=" + this.storeWeight + "|store_width=" + this.storeWidth;
    }

    @Override
    public int getVersion() {
        return 3;
    }

    public String toString() {
        return "generic";
    }

    public WeightingConfig createWeightingConfig(PMap pMap) {
        HashMap<String, Double> map = new HashMap<String, Double>(DEFAULT_SPEEDS.size());
        for (Map.Entry<String, Double> e : DEFAULT_SPEEDS.entrySet()) {
            map.put(e.getKey(), pMap.getDouble(e.getKey(), e.getValue()));
        }
        return new WeightingConfig(this.getHighwaySpeedMap(map));
    }

    public class WeightingConfig {
        private final double[] speedArray;

        public WeightingConfig(double[] speedArray) {
            this.speedArray = speedArray;
        }

        public double getSpeed(EdgeIteratorState edgeState) {
            int highwayKey = DataFlagEncoder.this.getHighway(edgeState);
            double speed = this.speedArray[highwayKey];
            if (speed < 0.0) {
                throw new IllegalStateException("speed was negative? " + edgeState.getEdge() + ", highway:" + highwayKey);
            }
            return speed;
        }

        public double getMaxSpecifiedSpeed() {
            double tmpSpeed = 0.0;
            for (double speed : this.speedArray) {
                if (!(speed > tmpSpeed)) continue;
                tmpSpeed = speed;
            }
            return tmpSpeed;
        }
    }
}

