/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.routing.profiles.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.util.TagParser;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EncodingManager
implements EncodedValueLookup {
    private static final String ERR = "Encoders are requesting %s bits, more than %s bits of %s flags. ";
    private static final String WAY_ERR = "Decrease the number of vehicles or increase the flags to take long via graph.bytes_for_flags: 8";
    private final List<AbstractFlagEncoder> edgeEncoders = new ArrayList<AbstractFlagEncoder>();
    private final Map<String, EncodedValue> encodedValueMap = new LinkedHashMap<String, EncodedValue>();
    private final Map<EncodedValue, TagParser> sharedEncodedValueMap = new LinkedHashMap<EncodedValue, TagParser>();
    private final int bitsForEdgeFlags;
    private final int bitsForTurnFlags = 32;
    private int nextNodeBit = 0;
    private int nextRelBit = 0;
    private int nextTurnBit = 0;
    private boolean enableInstructions = true;
    private String preferredLanguage = "";
    private EncodedValue.InitializerConfig config;
    public static final String ROUNDABOUT = "roundabout";

    public static EncodingManager create(String flagEncodersStr) {
        return EncodingManager.create(flagEncodersStr, 4);
    }

    public static EncodingManager create(String flagEncodersStr, int bytesForEdgeFlags) {
        return EncodingManager.create(FlagEncoderFactory.DEFAULT, flagEncodersStr, bytesForEdgeFlags);
    }

    public static EncodingManager create(FlagEncoderFactory factory, String flagEncodersStr, int bytesForEdgeFlags) {
        return EncodingManager.createBuilder(factory, flagEncodersStr, bytesForEdgeFlags).build();
    }

    public static Builder createBuilder(FlagEncoderFactory factory, String flagEncodersStr, int bytesForEdgeFlags) {
        return EncodingManager.createBuilder(EncodingManager.parseEncoderString(factory, flagEncodersStr), bytesForEdgeFlags);
    }

    public static EncodingManager create(FlagEncoder ... flagEncoders) {
        return EncodingManager.create(Arrays.asList(flagEncoders));
    }

    public static EncodingManager create(List<? extends FlagEncoder> flagEncoders) {
        return EncodingManager.create(flagEncoders, 4);
    }

    public static EncodingManager create(List<? extends FlagEncoder> flagEncoders, int bytesForEdgeFlags) {
        return EncodingManager.createBuilder(flagEncoders, bytesForEdgeFlags).build();
    }

    private static Builder createBuilder(List<? extends FlagEncoder> flagEncoders, int bytesForEdgeFlags) {
        Builder builder = new Builder(bytesForEdgeFlags);
        for (FlagEncoder flagEncoder : flagEncoders) {
            builder.add(flagEncoder);
        }
        return builder;
    }

    public static EncodingManager create(FlagEncoderFactory factory, String ghLoc) {
        RAMDirectory dir = new RAMDirectory(ghLoc, true);
        StorableProperties properties = new StorableProperties(dir);
        if (!properties.loadExisting()) {
            throw new IllegalStateException("Cannot load properties to fetch EncodingManager configuration at: " + dir.getLocation());
        }
        properties.checkVersions(false);
        String acceptStr = properties.get("graph.flag_encoders");
        if (acceptStr.isEmpty()) {
            throw new IllegalStateException("EncodingManager was not configured. And no one was found in the graph: " + dir.getLocation());
        }
        int bytesForFlags = 4;
        try {
            bytesForFlags = Integer.parseInt(properties.get("graph.bytes_for_flags"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return EncodingManager.createBuilder(factory, acceptStr, bytesForFlags).build();
    }

    public static Builder start() {
        return new Builder(4);
    }

    private EncodingManager(int bytes) {
        if (bytes <= 0 || bytes / 4 * 4 != bytes) {
            throw new IllegalStateException("bytesForEdgeFlags can be only a multiple of 4");
        }
        this.bitsForEdgeFlags = bytes * 8;
        this.config = new EncodedValue.InitializerConfig();
    }

    static List<FlagEncoder> parseEncoderString(FlagEncoderFactory factory, String encoderList) {
        if (encoderList.contains(":")) {
            throw new IllegalArgumentException("EncodingManager does no longer use reflection instantiate encoders directly.");
        }
        if (!encoderList.equals(Helper.toLowerCase(encoderList))) {
            throw new IllegalArgumentException("Since 0.7 EncodingManager does no longer accept upper case profiles: " + encoderList);
        }
        String[] entries = encoderList.split(",");
        ArrayList<FlagEncoder> resultEncoders = new ArrayList<FlagEncoder>();
        for (String entry : entries) {
            if ((entry = Helper.toLowerCase(entry.trim())).isEmpty()) continue;
            String entryVal = "";
            if (entry.contains("|")) {
                entryVal = entry;
                entry = entry.split("\\|")[0];
            }
            PMap configuration = new PMap(entryVal);
            FlagEncoder fe = factory.createFlagEncoder(entry, configuration);
            if (configuration.has("version") && fe.getVersion() != configuration.getInt("version", -1)) {
                throw new IllegalArgumentException("Encoder " + entry + " was used in version " + configuration.getLong("version", -1L) + ", but current version is " + fe.getVersion());
            }
            resultEncoders.add(fe);
        }
        return resultEncoders;
    }

    static String fixWayName(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll(";[ ]*", ", ");
    }

    public int getBytesForFlags() {
        return this.bitsForEdgeFlags / 8;
    }

    private void setEnableInstructions(boolean enableInstructions) {
        this.enableInstructions = enableInstructions;
    }

    public boolean isEnableInstructions() {
        return this.enableInstructions;
    }

    private void setPreferredLanguage(String preferredLanguage) {
        if (preferredLanguage == null) {
            throw new IllegalArgumentException("preferred language cannot be null");
        }
        this.preferredLanguage = preferredLanguage;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    private void addEncoder(AbstractFlagEncoder encoder) {
        if (encoder.isRegistered()) {
            throw new IllegalStateException("You must not register a FlagEncoder (" + encoder.toString() + ") twice!");
        }
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!flagEncoder.toString().equals(encoder.toString())) continue;
            throw new IllegalArgumentException("Cannot register edge encoder. Name already exists: " + flagEncoder.toString());
        }
        encoder.setRegistered(true);
        int encoderCount = this.edgeEncoders.size();
        int n = encoder.defineNodeBits(encoderCount, this.nextNodeBit);
        if (n > this.bitsForEdgeFlags) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, n, this.bitsForEdgeFlags, "node"));
        }
        encoder.setNodeBitMask(n - this.nextNodeBit, this.nextNodeBit);
        this.nextNodeBit = n;
        encoder.setEncodedValueLookup(this);
        ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
        encoder.createEncodedValues(list, encoder.toString() + ".", encoderCount);
        for (EncodedValue ev : list) {
            this.addEncodedValue(ev);
        }
        int n2 = encoder.defineRelationBits(encoderCount, this.nextRelBit);
        if (n2 > this.bitsForEdgeFlags) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, n2, this.bitsForEdgeFlags, "relation"));
        }
        encoder.setRelBitMask(n2 - this.nextRelBit, this.nextRelBit);
        this.nextRelBit = n2;
        int n3 = encoder.defineTurnBits(encoderCount, this.nextTurnBit);
        if (n3 > 32) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, n3, 32, "turn"));
        }
        this.nextTurnBit = n3;
        this.edgeEncoders.add(encoder);
    }

    private void addEncodedValue(EncodedValue ev) {
        ev.init(this.config);
        if (this.config.getRequiredBits() > this.getBytesForFlags() * 8) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Encoders are requesting %s bits, more than %s bits of %s flags. (Attempt to add EncodedValue " + ev.getName() + ") ", this.config.getRequiredBits(), this.bitsForEdgeFlags, "edge") + WAY_ERR);
        }
        if (this.encodedValueMap.containsKey(ev.getName())) {
            throw new IllegalStateException("EncodedValue " + ev.getName() + " already exists " + this.encodedValueMap.get(ev.getName()) + " vs " + ev);
        }
        this.encodedValueMap.put(ev.getName(), ev);
    }

    @Override
    public boolean hasEncoder(String encoder) {
        return this.getEncoder(encoder, false) != null;
    }

    public FlagEncoder getEncoder(String name) {
        return this.getEncoder(name, true);
    }

    private FlagEncoder getEncoder(String name, boolean throwExc) {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!name.equalsIgnoreCase(flagEncoder.toString())) continue;
            return flagEncoder;
        }
        if (throwExc) {
            throw new IllegalArgumentException("Encoder for " + name + " not found. Existing: " + this.toDetailsString());
        }
        return null;
    }

    public boolean acceptWay(ReaderWay way, AcceptWay acceptWay) {
        if (!acceptWay.isEmpty()) {
            throw new IllegalArgumentException("AcceptWay must be empty");
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            acceptWay.put(encoder.toString(), encoder.getAccess(way));
        }
        return acceptWay.hasAccepted();
    }

    public long handleRelationTags(long oldRelationFlags, ReaderRelation relation) {
        long flags = 0L;
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            flags |= encoder.handleRelationTags(oldRelationFlags, relation);
        }
        return flags;
    }

    public IntsRef handleWayTags(ReaderWay way, AcceptWay acceptWay, long relationFlags) {
        IntsRef edgeFlags = this.createEdgeFlags();
        Access access = acceptWay.getAccess();
        for (TagParser parser : this.sharedEncodedValueMap.values()) {
            parser.handleWayTags(edgeFlags, way, access, relationFlags);
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.handleWayTags(edgeFlags, way, acceptWay.get(encoder.toString()), relationFlags & encoder.getRelBitMask());
        }
        return edgeFlags;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(flagEncoder.toString());
        }
        return str.toString();
    }

    public String toDetailsString() {
        StringBuilder str = new StringBuilder();
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(encoder.toString()).append("|").append(encoder.getPropertiesString()).append("|version=").append(encoder.getVersion());
        }
        return str.toString();
    }

    public IntsRef createEdgeFlags() {
        return new IntsRef(this.bitsForEdgeFlags / 32);
    }

    public IntsRef flagsDefault(boolean forward, boolean backward) {
        IntsRef intsRef = this.createEdgeFlags();
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.flagsDefault(intsRef, forward, backward);
        }
        return intsRef;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.edgeEncoders != null ? this.edgeEncoders.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncodingManager other = (EncodingManager)obj;
        return this.edgeEncoders == other.edgeEncoders || this.edgeEncoders != null && this.edgeEncoders.equals(other.edgeEncoders);
    }

    public long handleNodeTags(ReaderNode node) {
        long flags = 0L;
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            flags |= encoder.handleNodeTags(node);
        }
        return flags;
    }

    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        if (this.enableInstructions) {
            String refName;
            String name = "";
            if (!this.preferredLanguage.isEmpty()) {
                name = EncodingManager.fixWayName(way.getTag("name:" + this.preferredLanguage));
            }
            if (name.isEmpty()) {
                name = EncodingManager.fixWayName(way.getTag("name"));
            }
            if (!(refName = EncodingManager.fixWayName(way.getTag("ref"))).isEmpty()) {
                name = name.isEmpty() ? refName : name + ", " + refName;
            }
            edge.setName(name);
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.applyWayTags(way, edge);
        }
    }

    public List<FlagEncoder> fetchEdgeEncoders() {
        return new ArrayList<FlagEncoder>(this.edgeEncoders);
    }

    public boolean needsTurnCostsSupport() {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!flagEncoder.supports(TurnWeighting.class)) continue;
            return true;
        }
        return false;
    }

    public List<BooleanEncodedValue> getAccessEncFromNodeFlags(long importNodeFlags) {
        ArrayList<BooleanEncodedValue> list = new ArrayList<BooleanEncodedValue>(this.edgeEncoders.size());
        for (int i = 0; i < this.edgeEncoders.size(); ++i) {
            FlagEncoder encoder = this.edgeEncoders.get(i);
            if ((1L << i & importNodeFlags) == 0L) continue;
            list.add(encoder.getAccessEnc());
        }
        return list;
    }

    @Override
    public BooleanEncodedValue getBooleanEncodedValue(String key) {
        return this.getEncodedValue(key, BooleanEncodedValue.class);
    }

    @Override
    public IntEncodedValue getIntEncodedValue(String key) {
        return this.getEncodedValue(key, IntEncodedValue.class);
    }

    @Override
    public DecimalEncodedValue getDecimalEncodedValue(String key) {
        return this.getEncodedValue(key, DecimalEncodedValue.class);
    }

    @Override
    public <T extends Enum> EnumEncodedValue<T> getEnumEncodedValue(String key, Class<T> type) {
        return this.getEncodedValue(key, EnumEncodedValue.class);
    }

    @Override
    public <T extends EncodedValue> T getEncodedValue(String key, Class<T> encodedValueType) {
        EncodedValue ev = this.encodedValueMap.get(key);
        if (ev == null) {
            throw new IllegalArgumentException("Cannot find EncodedValue " + key + " in collection: " + ev);
        }
        return (T)ev;
    }

    public static final String getKey(FlagEncoder encoder, String str) {
        return encoder.toString() + "." + str;
    }

    public static enum Access {
        WAY,
        FERRY,
        OTHER,
        CAN_SKIP;


        public boolean isFerry() {
            return this.ordinal() == FERRY.ordinal();
        }

        public boolean isWay() {
            return this.ordinal() == WAY.ordinal();
        }

        public boolean isOther() {
            return this.ordinal() == OTHER.ordinal();
        }

        public boolean canSkip() {
            return this.ordinal() == CAN_SKIP.ordinal();
        }
    }

    public static class AcceptWay {
        private Map<String, Access> accessMap = new HashMap<String, Access>(5);
        boolean hasAccepted = false;

        private Access get(String key) {
            Access res = this.accessMap.get(key);
            if (res == null) {
                throw new IllegalArgumentException("Couldn't fetch access value for key " + key);
            }
            return res;
        }

        private AcceptWay put(String key, Access access) {
            this.accessMap.put(key, access);
            if (access != Access.CAN_SKIP) {
                this.hasAccepted = true;
            }
            return this;
        }

        public boolean isEmpty() {
            return this.accessMap.isEmpty();
        }

        public boolean hasAccepted() {
            return this.hasAccepted;
        }

        private boolean has(String key) {
            return this.accessMap.containsKey(key);
        }

        public Access getAccess() {
            if (this.accessMap.isEmpty()) {
                throw new IllegalStateException("Cannot determine Access if map is empty");
            }
            return this.accessMap.values().iterator().next();
        }
    }

    public static class Builder {
        private EncodingManager em;

        public Builder(int bytes) {
            this.em = new EncodingManager(bytes);
            final SimpleBooleanEncodedValue roundaboutEnc = new SimpleBooleanEncodedValue(EncodingManager.ROUNDABOUT, false);
            this.put(roundaboutEnc, new TagParser(){

                @Override
                public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, Access access, long relationFlags) {
                    boolean isRoundabout;
                    if (!access.isWay()) {
                        return edgeFlags;
                    }
                    boolean bl = isRoundabout = way.hasTag("junction", (Object)EncodingManager.ROUNDABOUT) || way.hasTag("junction", (Object)"circular");
                    if (isRoundabout) {
                        roundaboutEnc.setBool(false, edgeFlags, true);
                    }
                    return edgeFlags;
                }
            });
        }

        public Builder setPreferredLanguage(String language) {
            this.check();
            this.em.setPreferredLanguage(language);
            return this;
        }

        public Builder setEnableInstructions(boolean enable) {
            this.check();
            this.em.setEnableInstructions(enable);
            return this;
        }

        public Builder addAll(FlagEncoderFactory factory, String flagEncodersStr) {
            for (FlagEncoder fe : EncodingManager.parseEncoderString(factory, flagEncodersStr)) {
                this.add(fe);
            }
            return this;
        }

        public Builder add(FlagEncoder encoder) {
            this.check();
            this.em.addEncoder((AbstractFlagEncoder)encoder);
            return this;
        }

        public Builder add(EncodedValue encodedValue) {
            this.check();
            this.em.addEncodedValue(encodedValue);
            return this;
        }

        public Builder put(EncodedValue encodedValue, TagParser tagParser) {
            this.add(encodedValue);
            this.em.sharedEncodedValueMap.put(encodedValue, tagParser);
            return this;
        }

        private void check() {
            if (this.em == null) {
                throw new IllegalStateException("Cannot call method after Builder.build() was called");
            }
        }

        public EncodingManager build() {
            this.check();
            if (this.em.encodedValueMap.isEmpty()) {
                throw new IllegalStateException("No EncodedValues found");
            }
            EncodingManager tmp = this.em;
            this.em = null;
            return tmp;
        }
    }
}

