/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.FactorizedDecimalEncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodedValueOld;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FootFlagEncoder
extends AbstractFlagEncoder {
    static final int SLOW_SPEED = 2;
    static final int MEAN_SPEED = 5;
    static final int FERRY_SPEED = 15;
    final Set<String> safeHighwayTags = new HashSet<String>();
    final Set<String> allowedHighwayTags = new HashSet<String>();
    final Set<String> avoidHighwayTags = new HashSet<String>();
    final Map<String, Integer> hikingNetworkToCode = new HashMap<String, Integer>();
    protected HashSet<String> sidewalkValues = new HashSet(5);
    protected HashSet<String> sidewalksNoValues = new HashSet(5);
    private DecimalEncodedValue priorityWayEncoder;
    private EncodedValueOld relationCodeEncoder;

    public FootFlagEncoder() {
        this(4, 1.0);
    }

    public FootFlagEncoder(PMap properties) {
        this((int)properties.getLong("speedBits", 4L), properties.getDouble("speedFactor", 1.0));
        this.properties = properties;
        this.setBlockFords(properties.getBool("block_fords", true));
    }

    public FootFlagEncoder(String propertiesStr) {
        this(new PMap(propertiesStr));
    }

    public FootFlagEncoder(int speedBits, double speedFactor) {
        super(speedBits, speedFactor, 0);
        this.restrictions.addAll(Arrays.asList("foot", "access"));
        this.restrictedValues.add("private");
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("official");
        this.intendedValues.add("permissive");
        this.sidewalksNoValues.add("no");
        this.sidewalksNoValues.add("none");
        this.sidewalksNoValues.add("separate");
        this.sidewalkValues.add("yes");
        this.sidewalkValues.add("both");
        this.sidewalkValues.add("left");
        this.sidewalkValues.add("right");
        this.setBlockByDefault(false);
        this.absoluteBarriers.add("fence");
        this.potentialBarriers.add("gate");
        this.potentialBarriers.add("cattle_grid");
        this.safeHighwayTags.add("footway");
        this.safeHighwayTags.add("path");
        this.safeHighwayTags.add("steps");
        this.safeHighwayTags.add("pedestrian");
        this.safeHighwayTags.add("living_street");
        this.safeHighwayTags.add("track");
        this.safeHighwayTags.add("residential");
        this.safeHighwayTags.add("service");
        this.safeHighwayTags.add("platform");
        this.avoidHighwayTags.add("trunk");
        this.avoidHighwayTags.add("trunk_link");
        this.avoidHighwayTags.add("primary");
        this.avoidHighwayTags.add("primary_link");
        this.avoidHighwayTags.add("secondary");
        this.avoidHighwayTags.add("secondary_link");
        this.avoidHighwayTags.add("tertiary");
        this.avoidHighwayTags.add("tertiary_link");
        this.allowedHighwayTags.addAll(this.safeHighwayTags);
        this.allowedHighwayTags.addAll(this.avoidHighwayTags);
        this.allowedHighwayTags.add("cycleway");
        this.allowedHighwayTags.add("unclassified");
        this.allowedHighwayTags.add("road");
        this.hikingNetworkToCode.put("iwn", PriorityCode.UNCHANGED.getValue());
        this.hikingNetworkToCode.put("nwn", PriorityCode.UNCHANGED.getValue());
        this.hikingNetworkToCode.put("rwn", PriorityCode.UNCHANGED.getValue());
        this.hikingNetworkToCode.put("lwn", PriorityCode.UNCHANGED.getValue());
        this.maxPossibleSpeed = 15;
        this.speedDefault = 5.0;
        this.init();
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Override
    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue, String prefix, int index) {
        super.createEncodedValues(registerNewEncodedValue, prefix, index);
        this.speedEncoder = new FactorizedDecimalEncodedValue(prefix + "average_speed", this.speedBits, this.speedFactor, false);
        registerNewEncodedValue.add(this.speedEncoder);
        this.priorityWayEncoder = new FactorizedDecimalEncodedValue(prefix + "priority", 3, PriorityCode.getFactor(1), false);
        registerNewEncodedValue.add(this.priorityWayEncoder);
    }

    @Override
    public int defineRelationBits(int index, int shift) {
        this.relationCodeEncoder = new EncodedValueOld("RelationCode", shift, 3, 1.0, 0L, 7);
        return shift + this.relationCodeEncoder.getBits();
    }

    @Override
    public int defineTurnBits(int index, int shift) {
        return shift;
    }

    @Override
    public boolean isTurnRestricted(long flags) {
        return false;
    }

    @Override
    public double getTurnCost(long flag) {
        return 0.0;
    }

    @Override
    public long getTurnFlags(boolean restricted, double costs) {
        return 0L;
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            String footTag;
            EncodingManager.Access acceptPotentially = EncodingManager.Access.CAN_SKIP;
            if (way.hasTag("route", (Set<String>)this.ferries) && ((footTag = way.getTag("foot")) == null || this.intendedValues.contains(footTag))) {
                acceptPotentially = EncodingManager.Access.FERRY;
            }
            if (way.hasTag("railway", (Object)"platform")) {
                acceptPotentially = EncodingManager.Access.WAY;
            }
            if (way.hasTag("man_made", (Object)"pier")) {
                acceptPotentially = EncodingManager.Access.WAY;
            }
            if (!acceptPotentially.canSkip()) {
                if (way.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                    return EncodingManager.Access.CAN_SKIP;
                }
                return acceptPotentially;
            }
            return EncodingManager.Access.CAN_SKIP;
        }
        String sacScale = way.getTag("sac_scale");
        if (!(sacScale == null || "hiking".equals(sacScale) || "mountain_hiking".equals(sacScale) || "demanding_mountain_hiking".equals(sacScale) || "alpine_hiking".equals(sacScale))) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("foot", (Set<String>)this.intendedValues)) {
            return EncodingManager.Access.WAY;
        }
        if (way.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("sidewalk", this.sidewalkValues)) {
            return EncodingManager.Access.WAY;
        }
        if (!this.allowedHighwayTags.contains(highwayValue)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("motorroad", (Object)"yes")) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (this.isBlockFords() && (way.hasTag("highway", (Object)"ford") || way.hasTag("ford", new String[0]))) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        return EncodingManager.Access.WAY;
    }

    @Override
    public long handleRelationTags(long oldRelationFlags, ReaderRelation relation) {
        int code = 0;
        if (relation.hasTag("route", (Object)"hiking") || relation.hasTag("route", (Object)"foot")) {
            Integer val = this.hikingNetworkToCode.get(relation.getTag("network"));
            code = val != null ? val.intValue() : this.hikingNetworkToCode.get("lwn").intValue();
        } else if (relation.hasTag("route", (Object)"ferry")) {
            code = PriorityCode.AVOID_IF_POSSIBLE.getValue();
        }
        int oldCode = (int)this.relationCodeEncoder.getValue(oldRelationFlags);
        if (oldCode < code) {
            return this.relationCodeEncoder.setValue(0L, code);
        }
        return oldRelationFlags;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        if (access.canSkip()) {
            return edgeFlags;
        }
        if (!access.isFerry()) {
            String sacScale = way.getTag("sac_scale");
            if (sacScale != null) {
                if ("hiking".equals(sacScale)) {
                    this.speedEncoder.setDecimal(false, edgeFlags, 5.0);
                } else {
                    this.speedEncoder.setDecimal(false, edgeFlags, 2.0);
                }
            } else {
                this.speedEncoder.setDecimal(false, edgeFlags, 5.0);
            }
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
        } else {
            double ferrySpeed = this.getFerrySpeed(way);
            this.setSpeed(false, edgeFlags, ferrySpeed);
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
        }
        int priorityFromRelation = 0;
        if (relationFlags != 0L) {
            priorityFromRelation = (int)this.relationCodeEncoder.getValue(relationFlags);
        }
        this.priorityWayEncoder.setDecimal(false, edgeFlags, PriorityCode.getFactor(this.handlePriority(way, priorityFromRelation)));
        return edgeFlags;
    }

    protected int handlePriority(ReaderWay way, int priorityFromRelation) {
        TreeMap<Double, Integer> weightToPrioMap = new TreeMap<Double, Integer>();
        if (priorityFromRelation == 0) {
            weightToPrioMap.put(0.0, PriorityCode.UNCHANGED.getValue());
        } else {
            weightToPrioMap.put(110.0, priorityFromRelation);
        }
        this.collect(way, weightToPrioMap);
        return weightToPrioMap.lastEntry().getValue();
    }

    void collect(ReaderWay way, TreeMap<Double, Integer> weightToPrioMap) {
        String highway = way.getTag("highway");
        if (way.hasTag("foot", (Object)"designated")) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        double maxSpeed = this.getMaxSpeed(way);
        if (this.safeHighwayTags.contains(highway) || maxSpeed > 0.0 && maxSpeed <= 20.0) {
            weightToPrioMap.put(40.0, PriorityCode.PREFER.getValue());
            if (way.hasTag("tunnel", (Set<String>)this.intendedValues)) {
                if (way.hasTag("sidewalk", this.sidewalksNoValues)) {
                    weightToPrioMap.put(40.0, PriorityCode.AVOID_IF_POSSIBLE.getValue());
                } else {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        } else if ((maxSpeed > 50.0 || this.avoidHighwayTags.contains(highway)) && !way.hasTag("sidewalk", this.sidewalkValues)) {
            weightToPrioMap.put(45.0, PriorityCode.AVOID_IF_POSSIBLE.getValue());
        }
        if (way.hasTag("bicycle", (Object)"official") || way.hasTag("bicycle", (Object)"designated")) {
            weightToPrioMap.put(44.0, PriorityCode.AVOID_IF_POSSIBLE.getValue());
        }
    }

    @Override
    public boolean supports(Class<?> feature) {
        if (super.supports(feature)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(feature);
    }

    public String toString() {
        return "foot";
    }

    @Override
    double getSpeed(boolean reverse, IntsRef edgeFlags) {
        double speed = super.getSpeed(reverse, edgeFlags);
        if (speed == this.getMaxSpeed()) {
            return 20.0;
        }
        return speed;
    }
}

