/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.apache.commons.lang3.StringUtils;
import com.graphhopper.debatty.java.stringsimilarity.JaroWinkler;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class NameSimilarityEdgeFilter
implements EdgeFilter {
    private static final Map<String, String> DEFAULT_REWRITE_MAP = new HashMap<String, String>(){
        {
            for (String remove : Arrays.asList("ally", "alley", "arc", "arcade", "bvd", "bvd.", "boulevard", "av.", "avenue", "avenida", "calle", "cl.", "close", "crescend", "cres", "cres.", "rd.", "road", "ln.", "lane", "pde.", "pde", "parade", "pl.", "place", "plaza", "str.", "str", "stra\u00dfe", "strasse", "st.", "street", "strada", "sq.", "square", "tr.", "track", "via")) {
                this.put(remove, "");
            }
        }
    };
    private static final Pattern NON_WORD_CHAR = Pattern.compile("[^\\p{L}]+");
    private static final JaroWinkler jaroWinkler = new JaroWinkler();
    private static final double JARO_WINKLER_ACCEPT_FACTOR = 0.9;
    private final EdgeFilter edgeFilter;
    private final String pointHint;
    private final Map<String, String> rewriteMap;

    public NameSimilarityEdgeFilter(EdgeFilter edgeFilter, String pointHint) {
        this(edgeFilter, pointHint, DEFAULT_REWRITE_MAP);
    }

    public NameSimilarityEdgeFilter(EdgeFilter edgeFilter, String pointHint, Map<String, String> rewriteMap) {
        this.edgeFilter = edgeFilter;
        this.rewriteMap = rewriteMap;
        this.pointHint = this.prepareName(this.removeRelation(pointHint == null ? "" : pointHint));
    }

    private String prepareName(String name) {
        String[] arr = name.split("\\s");
        ArrayList<String> list = new ArrayList<String>(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            String rewrite = NON_WORD_CHAR.matcher(Helper.toLowerCase(arr[i])).replaceAll("");
            String tmp = this.rewriteMap.get(rewrite);
            if (tmp != null) {
                rewrite = tmp;
            }
            if (rewrite.isEmpty() || rewrite.length() <= 2) continue;
            list.add(rewrite);
        }
        return this.listToString(list);
    }

    private String removeRelation(String edgeName) {
        if (edgeName != null && edgeName.contains(", ")) {
            edgeName = edgeName.substring(0, edgeName.lastIndexOf(44));
        }
        return edgeName;
    }

    @Override
    public final boolean accept(EdgeIteratorState iter) {
        if (!this.edgeFilter.accept(iter)) {
            return false;
        }
        if (this.pointHint.isEmpty()) {
            return true;
        }
        String name = iter.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        name = this.removeRelation(name);
        String edgeName = this.prepareName(name);
        return this.isJaroWinklerSimilar(this.pointHint, edgeName);
    }

    private boolean isJaroWinklerSimilar(String str1, String str2) {
        double jwSimilarity = jaroWinkler.similarity(str1, str2);
        return jwSimilarity > 0.9;
    }

    private final String listToString(List<String> list) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            b.append(list.get(i));
        }
        return b.toString();
    }

    private boolean isLevenshteinSimilar(String hint, String name) {
        if (Math.min(name.length(), hint.length()) * 4 < Math.max(name.length(), hint.length())) {
            return false;
        }
        int factor = 1 + Math.abs(hint.length() - name.length());
        int levDistance = StringUtils.getLevenshteinDistance(hint, name);
        return levDistance <= factor;
    }
}

