/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.json.geo.JsonFeatureCollection;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupArray;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialRuleLookupBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SpatialRuleLookupBuilder.class);

    public static SpatialRuleLookup buildIndex(JsonFeatureCollection jsonFeatureCollection, String jsonIdField, SpatialRuleFactory spatialRuleFactory, double resolution, BBox maxBBox) {
        BBox polygonBounds = BBox.createInverse(false);
        ArrayList<SpatialRule> spatialRules = new ArrayList<SpatialRule>();
        for (int jsonFeatureIdx = 0; jsonFeatureIdx < jsonFeatureCollection.getFeatures().size(); ++jsonFeatureIdx) {
            String id;
            JsonFeature jsonFeature = jsonFeatureCollection.getFeatures().get(jsonFeatureIdx);
            String string = id = jsonIdField.isEmpty() || Helper.toLowerCase(jsonIdField).equals("id") ? jsonFeature.getId() : (String)jsonFeature.getProperty(jsonIdField);
            if (id == null || id.isEmpty()) {
                throw new IllegalArgumentException("ID cannot be empty but was for JsonFeature " + jsonFeatureIdx);
            }
            ArrayList<com.graphhopper.util.shapes.Polygon> borders = new ArrayList<com.graphhopper.util.shapes.Polygon>();
            for (int i = 0; i < jsonFeature.getGeometry().getNumGeometries(); ++i) {
                Geometry poly = jsonFeature.getGeometry().getGeometryN(i);
                if (!(poly instanceof Polygon)) {
                    throw new IllegalArgumentException("Geometry for " + id + " (" + i + ") not supported " + poly.getClass().getSimpleName());
                }
                borders.add(com.graphhopper.util.shapes.Polygon.create((Polygon)poly));
            }
            SpatialRule spatialRule = spatialRuleFactory.createSpatialRule(id, borders);
            if (spatialRule == SpatialRule.EMPTY) continue;
            spatialRules.add(spatialRule);
            for (com.graphhopper.util.shapes.Polygon polygon : spatialRule.getBorders()) {
                polygonBounds.update(polygon.getMinLat(), polygon.getMinLon());
                polygonBounds.update(polygon.getMaxLat(), polygon.getMaxLon());
            }
        }
        if (!polygonBounds.isValid()) {
            return SpatialRuleLookup.EMPTY;
        }
        BBox calculatedBounds = polygonBounds.calculateIntersection(maxBBox);
        if (calculatedBounds == null) {
            return SpatialRuleLookup.EMPTY;
        }
        SpatialRuleLookupArray spatialRuleLookup = new SpatialRuleLookupArray(spatialRules, resolution, true, calculatedBounds);
        logger.info("Created the SpatialRuleLookup with the following rules: " + Arrays.toString(spatialRules.toArray()));
        return spatialRuleLookup;
    }

    public static SpatialRuleLookup buildIndex(JsonFeatureCollection jsonFeatureCollection, String jsonIdField, SpatialRuleFactory spatialRuleFactory) {
        return SpatialRuleLookupBuilder.buildIndex(jsonFeatureCollection, jsonIdField, spatialRuleFactory, 0.1, new BBox(-180.0, 180.0, -90.0, 90.0));
    }

    public static interface SpatialRuleFactory {
        public SpatialRule createSpatialRule(String var1, List<com.graphhopper.util.shapes.Polygon> var2);
    }
}

