/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class FastestWeighting
extends AbstractWeighting {
    protected static final double SPEED_CONV = 3.6;
    private final double headingPenalty;
    private final long headingPenaltyMillis;
    private final double maxSpeed;

    public FastestWeighting(FlagEncoder encoder, PMap map) {
        super(encoder);
        this.headingPenalty = map.getDouble("heading_penalty", 300.0);
        this.headingPenaltyMillis = Math.round(this.headingPenalty * 1000.0);
        this.maxSpeed = encoder.getMaxSpeed() / 3.6;
    }

    public FastestWeighting(FlagEncoder encoder) {
        this(encoder, new HintsMap(0));
    }

    @Override
    public double getMinWeight(double distance) {
        return distance / this.maxSpeed;
    }

    @Override
    public double calcWeight(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
        double speed;
        double d = speed = reverse ? edge.getReverse(this.avSpeedEnc) : edge.get(this.avSpeedEnc);
        if (speed == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double time = edge.getDistance() / speed * 3.6;
        boolean unfavoredEdge = edge.get(EdgeIteratorState.UNFAVORED_EDGE);
        if (unfavoredEdge) {
            time += this.headingPenalty;
        }
        return time;
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        long time = 0L;
        boolean unfavoredEdge = edgeState.get(EdgeIteratorState.UNFAVORED_EDGE);
        if (unfavoredEdge) {
            time += this.headingPenaltyMillis;
        }
        return time + super.calcMillis(edgeState, reverse, prevOrNextEdgeId);
    }

    @Override
    public String getName() {
        return "fastest";
    }
}

