/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.Graph;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Locale;

public class ShortcutUnpacker {
    private final Graph graph;
    private final Visitor visitor;
    private final boolean edgeBased;
    private boolean reverseOrder;

    public ShortcutUnpacker(Graph graph, Visitor visitor, boolean edgeBased) {
        this.graph = graph;
        this.visitor = visitor;
        this.edgeBased = edgeBased;
    }

    public void visitOriginalEdgesFwd(int edgeId, int adjNode, boolean reverseOrder, int prevOrNextEdgeId) {
        this.doVisitOriginalEdges(edgeId, adjNode, reverseOrder, false, prevOrNextEdgeId);
    }

    public void visitOriginalEdgesBwd(int edgeId, int adjNode, boolean reverseOrder, int prevOrNextEdgeId) {
        this.doVisitOriginalEdges(edgeId, adjNode, reverseOrder, true, prevOrNextEdgeId);
    }

    private void doVisitOriginalEdges(int edgeId, int adjNode, boolean reverseOrder, boolean reverse, int prevOrNextEdgeId) {
        this.reverseOrder = reverseOrder;
        CHEdgeIteratorState edge = this.getEdge(edgeId, adjNode);
        if (edge == null) {
            throw new IllegalArgumentException("Edge with id: " + edgeId + " does not exist or does not touch node " + adjNode);
        }
        this.expandEdge(edge, reverse, prevOrNextEdgeId);
    }

    private void expandEdge(CHEdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
        if (!edge.isShortcut()) {
            this.visitor.visit(edge, reverse, prevOrNextEdgeId);
            return;
        }
        if (this.edgeBased) {
            this.expandSkippedEdgesEdgeBased(edge.getSkippedEdge1(), edge.getSkippedEdge2(), edge.getBaseNode(), edge.getAdjNode(), reverse, prevOrNextEdgeId);
        } else {
            this.expandSkippedEdgesNodeBased(edge.getSkippedEdge1(), edge.getSkippedEdge2(), edge.getBaseNode(), edge.getAdjNode(), reverse);
        }
    }

    private void expandSkippedEdgesEdgeBased(int skippedEdge1, int skippedEdge2, int base, int adj, boolean reverse, int prevOrNextEdgeId) {
        if (reverse) {
            int tmp = skippedEdge1;
            skippedEdge1 = skippedEdge2;
            skippedEdge2 = tmp;
        }
        CHEdgeIteratorState sk2 = this.getEdge(skippedEdge2, adj);
        assert (sk2 != null) : "skipped edge " + skippedEdge2 + " + is not attached to adjNode " + adj + ". this should never happen because edge-based CH does not use bidirectional shortcuts at the moment";
        CHEdgeIteratorState sk1 = this.getEdge(skippedEdge1, sk2.getBaseNode());
        if (base == adj && (sk1.getAdjNode() == sk1.getBaseNode() || sk2.getAdjNode() == sk2.getBaseNode())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "error: detected edge where a skipped edges is a loop. this should never happen. base: %d, adj: %d, skip-edge1: %d, skip-edge2: %d, reverse: %b", base, adj, skippedEdge1, skippedEdge2, reverse));
        }
        int adjEdge = this.getOppositeEdge(sk1, base);
        if (this.reverseOrder) {
            this.expandEdge(sk2, reverse, adjEdge);
            this.expandEdge(sk1, reverse, prevOrNextEdgeId);
        } else {
            this.expandEdge(sk1, reverse, prevOrNextEdgeId);
            this.expandEdge(sk2, reverse, adjEdge);
        }
    }

    private void expandSkippedEdgesNodeBased(int skippedEdge1, int skippedEdge2, int base, int adj, boolean reverse) {
        CHEdgeIteratorState sk1;
        CHEdgeIteratorState sk2 = this.getEdge(skippedEdge2, adj);
        if (sk2 == null) {
            sk2 = this.getEdge(skippedEdge1, adj);
            sk1 = this.getEdge(skippedEdge2, sk2.getBaseNode());
        } else {
            sk1 = this.getEdge(skippedEdge1, sk2.getBaseNode());
        }
        if (this.reverseOrder) {
            this.expandEdge(sk2, reverse, -1);
            this.expandEdge(sk1, reverse, -1);
        } else {
            this.expandEdge(sk1, reverse, -1);
            this.expandEdge(sk2, reverse, -1);
        }
    }

    private int getOppositeEdge(CHEdgeIteratorState edgeState, int adjNode) {
        assert (edgeState.getBaseNode() == adjNode || edgeState.getAdjNode() == adjNode) : "adjNode " + adjNode + " must be one of adj/base of edgeState: " + edgeState;
        return this.graph.isAdjacentToNode(edgeState.getOrigEdgeLast(), adjNode) ? edgeState.getOrigEdgeFirst() : edgeState.getOrigEdgeLast();
    }

    private CHEdgeIteratorState getEdge(int edgeId, int adjNode) {
        return (CHEdgeIteratorState)this.graph.getEdgeIteratorState(edgeId, adjNode);
    }

    public static interface Visitor {
        public void visit(EdgeIteratorState var1, boolean var2, int var3);
    }
}

