/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.PathWrapper;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PathSimplification;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import com.graphhopper.util.ViaInstruction;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PathMerger {
    private static final DouglasPeucker DP = new DouglasPeucker();
    private boolean enableInstructions = true;
    private boolean simplifyResponse = true;
    private DouglasPeucker douglasPeucker = DP;
    private boolean calcPoints = true;
    private PathDetailsBuilderFactory pathBuilderFactory;
    private List<String> requestedPathDetails = Collections.EMPTY_LIST;
    private double favoredHeading = Double.NaN;

    public PathMerger setCalcPoints(boolean calcPoints) {
        this.calcPoints = calcPoints;
        return this;
    }

    public PathMerger setDouglasPeucker(DouglasPeucker douglasPeucker) {
        this.douglasPeucker = douglasPeucker;
        return this;
    }

    public PathMerger setPathDetailsBuilders(PathDetailsBuilderFactory pathBuilderFactory, List<String> requestedPathDetails) {
        this.pathBuilderFactory = pathBuilderFactory;
        this.requestedPathDetails = requestedPathDetails;
        return this;
    }

    public PathMerger setSimplifyResponse(boolean simplifyRes) {
        this.simplifyResponse = simplifyRes;
        return this;
    }

    public PathMerger setEnableInstructions(boolean enableInstructions) {
        this.enableInstructions = enableInstructions;
        return this;
    }

    public void doWork(PathWrapper altRsp, List<Path> paths, EncodingManager encodingManager, Translation tr) {
        int origPoints = 0;
        long fullTimeInMillis = 0L;
        double fullWeight = 0.0;
        double fullDistance = 0.0;
        boolean allFound = true;
        InstructionList fullInstructions = new InstructionList(tr);
        PointList fullPoints = PointList.EMPTY;
        ArrayList<String> description = new ArrayList<String>();
        BooleanEncodedValue roundaboutEnc = encodingManager.getBooleanEncodedValue("roundabout");
        for (int pathIndex = 0; pathIndex < paths.size(); ++pathIndex) {
            InstructionList il;
            Path path = paths.get(pathIndex);
            if (!path.isFound()) {
                allFound = false;
                continue;
            }
            description.addAll(path.getDescription());
            fullTimeInMillis += path.getTime();
            fullDistance += path.getDistance();
            fullWeight += path.getWeight();
            if (this.enableInstructions && !(il = path.calcInstructions(roundaboutEnc, tr)).isEmpty()) {
                fullInstructions.addAll(il);
                if (pathIndex + 1 < paths.size()) {
                    ViaInstruction newInstr = new ViaInstruction(fullInstructions.get(fullInstructions.size() - 1));
                    newInstr.setViaCount(pathIndex + 1);
                    fullInstructions.set(fullInstructions.size() - 1, newInstr);
                }
            }
            if (this.calcPoints || this.enableInstructions) {
                PointList tmpPoints = path.calcPoints();
                if (fullPoints.isEmpty()) {
                    fullPoints = new PointList(tmpPoints.size(), tmpPoints.is3D());
                }
                if (pathIndex + 1 < paths.size()) {
                    tmpPoints.removeLastPoint();
                }
                fullPoints.add(tmpPoints);
                altRsp.addPathDetails(path.calcDetails(this.requestedPathDetails, this.pathBuilderFactory, origPoints));
                origPoints = fullPoints.size();
            }
            allFound = allFound && path.isFound();
        }
        if (!fullPoints.isEmpty()) {
            String debug = altRsp.getDebugInfo() + ", simplify (" + origPoints + "->" + fullPoints.getSize() + ")";
            altRsp.addDebugInfo(debug);
            if (fullPoints.is3D) {
                this.calcAscendDescend(altRsp, fullPoints);
            }
        }
        if (this.enableInstructions) {
            fullInstructions = this.updateInstructionsWithContext(fullInstructions);
            altRsp.setInstructions(fullInstructions);
        }
        if (!allFound) {
            altRsp.addError(new ConnectionNotFoundException("Connection between locations not found", Collections.emptyMap()));
        }
        altRsp.setDescription(description).setPoints(fullPoints).setRouteWeight(fullWeight).setDistance(fullDistance).setTime(fullTimeInMillis);
        if (allFound && this.simplifyResponse && (this.calcPoints || this.enableInstructions)) {
            PathSimplification ps = new PathSimplification(altRsp, this.douglasPeucker, this.enableInstructions);
            ps.simplify();
        }
    }

    private InstructionList updateInstructionsWithContext(InstructionList instructions) {
        for (int i = 0; i < instructions.size() - 1; ++i) {
            double heading;
            double lastHeading;
            double diff;
            Instruction nextInstruction;
            double heading2;
            double diff2;
            Instruction instruction = instructions.get(i);
            if (i == 0 && !Double.isNaN(this.favoredHeading) && instruction.extraInfo.containsKey("heading") && (diff2 = Math.abs((heading2 = ((Double)instruction.extraInfo.get("heading")).doubleValue()) - this.favoredHeading) % 360.0) > 170.0 && diff2 < 190.0) {
                instruction.setSign(-98);
            }
            if (instruction.getSign() != 5 || (nextInstruction = instructions.get(i + 1)).getSign() != 0 || !instruction.extraInfo.containsKey("last_heading") || !nextInstruction.extraInfo.containsKey("heading") || !((diff = Math.abs((lastHeading = ((Double)instruction.extraInfo.get("last_heading")).doubleValue()) - (heading = ((Double)nextInstruction.extraInfo.get("heading")).doubleValue())) % 360.0) > 179.0) || !(diff < 181.0)) continue;
            nextInstruction.setSign(-98);
        }
        return instructions;
    }

    private void calcAscendDescend(PathWrapper rsp, PointList pointList) {
        double ascendMeters = 0.0;
        double descendMeters = 0.0;
        double lastEle = pointList.getElevation(0);
        for (int i = 1; i < pointList.size(); ++i) {
            double ele = pointList.getElevation(i);
            double diff = Math.abs(ele - lastEle);
            if (ele > lastEle) {
                ascendMeters += diff;
            } else {
                descendMeters += diff;
            }
            lastEle = ele;
        }
        rsp.setAscend(ascendMeters);
        rsp.setDescend(descendMeters);
    }

    public void setFavoredHeading(double favoredHeading) {
        this.favoredHeading = favoredHeading;
    }
}

