/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.PointList;

public final class ShallowImmutablePointList
extends PointList {
    private static final String IMMUTABLE_ERR = "This class is immutable, you are not allowed to change it";
    final int fromOffset;
    final int toOffset;
    final PointList wrappedPointList;

    public ShallowImmutablePointList(int fromOffset, int toOffset, PointList wrappedPointList) {
        if (fromOffset > toOffset) {
            throw new IllegalArgumentException("from must be smaller or equal to end");
        }
        if (fromOffset < 0 || toOffset > wrappedPointList.getSize()) {
            throw new IllegalArgumentException("Illegal interval: " + fromOffset + ", " + toOffset);
        }
        this.fromOffset = fromOffset;
        this.toOffset = toOffset;
        this.wrappedPointList = wrappedPointList;
    }

    @Override
    public int size() {
        return this.toOffset - this.fromOffset;
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public double getLatitude(int index) {
        if (index > this.getSize()) {
            throw new ArrayIndexOutOfBoundsException("Tried to access PointList with too big index! index:" + index + ", size:" + this.getSize());
        }
        return this.wrappedPointList.getLatitude(this.fromOffset + index);
    }

    @Override
    public double getLongitude(int index) {
        if (index > this.getSize()) {
            throw new ArrayIndexOutOfBoundsException("Tried to access PointList with too big index! index:" + index + ", size:" + this.getSize());
        }
        return this.wrappedPointList.getLongitude(this.fromOffset + index);
    }

    @Override
    public double getElevation(int index) {
        if (index > this.getSize()) {
            throw new ArrayIndexOutOfBoundsException("Tried to access PointList with too big index! index:" + index + ", size:" + this.getSize());
        }
        return this.wrappedPointList.getElevation(this.fromOffset + index);
    }

    @Override
    public void setElevation(int index, double ele) {
        this.wrappedPointList.setElevation(this.fromOffset + index, ele);
    }

    @Override
    public void makeImmutable() {
        this.wrappedPointList.makeImmutable();
    }

    @Override
    public boolean isImmutable() {
        return this.wrappedPointList.isImmutable();
    }

    @Override
    public boolean is3D() {
        return this.wrappedPointList.is3D();
    }

    @Override
    public int getDimension() {
        return this.wrappedPointList.getDimension();
    }

    @Override
    public void ensureNode(int nodeId) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void setNode(int nodeId, double lat, double lon) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void setNode(int nodeId, double lat, double lon, double ele) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void set(int index, double lat, double lon, double ele) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void add(double lat, double lon, double ele) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void add(PointList points) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void removeLastPoint() {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void reverse() {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void trimToSize(int newSize) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void parse2DJSON(String str) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }
}

