/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;

public class StopWatch {
    private long lastTime;
    private long elapsedNanos;
    private String name = "";

    public StopWatch(String name) {
        this.name = name;
    }

    public StopWatch() {
    }

    public StopWatch setName(String name) {
        this.name = name;
        return this;
    }

    public StopWatch start() {
        this.lastTime = System.nanoTime();
        return this;
    }

    public StopWatch stop() {
        if (this.lastTime < 0L) {
            return this;
        }
        this.elapsedNanos += System.nanoTime() - this.lastTime;
        this.lastTime = -1L;
        return this;
    }

    public float getSeconds() {
        return (float)this.elapsedNanos / 1.0E9f;
    }

    public float getCurrentSeconds() {
        if (this.notStarted()) {
            return 0.0f;
        }
        long lastNanos = this.lastTime < 0L ? 0L : System.nanoTime() - this.lastTime;
        return (float)(this.elapsedNanos + lastNanos) / 1.0E9f;
    }

    public long getMillis() {
        return this.elapsedNanos / 1000000L;
    }

    public long getNanos() {
        return this.elapsedNanos;
    }

    public String toString() {
        String str = "";
        if (!Helper.isEmpty(this.name)) {
            str = str + this.name + " ";
        }
        return str + "time:" + this.getSeconds();
    }

    private boolean notStarted() {
        return this.lastTime == 0L && this.elapsedNanos == 0L;
    }
}

