/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class AverageSpeedDetails
extends AbstractPathDetailsBuilder {
    private final DecimalEncodedValue avSpeedEnc;
    private double curAvgSpeed = -1.0;

    public AverageSpeedDetails(FlagEncoder encoder) {
        super("average_speed");
        this.avSpeedEnc = encoder.getDecimalEncodedValue(EncodingManager.getKey(encoder, "average_speed"));
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        double tmpSpeed = edge.get(this.avSpeedEnc);
        if (Math.abs(tmpSpeed - this.curAvgSpeed) > 1.0E-4) {
            this.curAvgSpeed = tmpSpeed;
            return true;
        }
        return false;
    }

    @Override
    public Object getCurrentValue() {
        return this.curAvgSpeed;
    }
}

