/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.details.AverageSpeedDetails;
import com.graphhopper.util.details.DistanceDetails;
import com.graphhopper.util.details.EdgeIdDetails;
import com.graphhopper.util.details.PathDetailsBuilder;
import com.graphhopper.util.details.StreetNameDetails;
import com.graphhopper.util.details.TimeDetails;
import java.util.ArrayList;
import java.util.List;

public class PathDetailsBuilderFactory {
    public List<PathDetailsBuilder> createPathDetailsBuilders(List<String> requestedPathDetails, FlagEncoder encoder, Weighting weighting) {
        ArrayList<PathDetailsBuilder> builders = new ArrayList<PathDetailsBuilder>();
        if (requestedPathDetails.contains("average_speed")) {
            builders.add(new AverageSpeedDetails(encoder));
        }
        if (requestedPathDetails.contains("street_name")) {
            builders.add(new StreetNameDetails());
        }
        if (requestedPathDetails.contains("edge_id")) {
            builders.add(new EdgeIdDetails());
        }
        if (requestedPathDetails.contains("time")) {
            builders.add(new TimeDetails(weighting));
        }
        if (requestedPathDetails.contains("distance")) {
            builders.add(new DistanceDetails());
        }
        if (requestedPathDetails.size() != builders.size()) {
            throw new IllegalArgumentException("You requested the details " + requestedPathDetails + " but we could only find " + builders);
        }
        return builders;
    }
}

