/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import io.dropwizard.client.ssl.TlsConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;

public class DropwizardSSLConnectionSocketFactory {
    private final TlsConfiguration configuration;
    @Nullable
    private final HostnameVerifier verifier;

    public DropwizardSSLConnectionSocketFactory(TlsConfiguration configuration) {
        this(configuration, null);
    }

    public DropwizardSSLConnectionSocketFactory(TlsConfiguration configuration, @Nullable HostnameVerifier verifier) {
        this.configuration = configuration;
        this.verifier = verifier;
    }

    public SSLConnectionSocketFactory getSocketFactory() throws SSLInitializationException {
        return new SSLConnectionSocketFactory(this.buildSslContext(), this.getSupportedProtocols(), this.getSupportedCiphers(), this.chooseHostnameVerifier());
    }

    @Nullable
    private String[] getSupportedCiphers() {
        List<String> supportedCiphers = this.configuration.getSupportedCiphers();
        if (supportedCiphers == null) {
            return null;
        }
        return supportedCiphers.toArray(new String[supportedCiphers.size()]);
    }

    @Nullable
    private String[] getSupportedProtocols() {
        List<String> supportedProtocols = this.configuration.getSupportedProtocols();
        if (supportedProtocols == null) {
            return null;
        }
        return supportedProtocols.toArray(new String[supportedProtocols.size()]);
    }

    private HostnameVerifier chooseHostnameVerifier() {
        if (this.configuration.isVerifyHostname()) {
            return this.verifier != null ? this.verifier : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        }
        return new NoopHostnameVerifier();
    }

    private SSLContext buildSslContext() throws SSLInitializationException {
        SSLContext sslContext;
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.setProtocol(this.configuration.getProtocol());
            String configuredProvider = this.configuration.getProvider();
            if (configuredProvider != null) {
                sslContextBuilder.setProvider(configuredProvider);
            }
            this.loadKeyMaterial(sslContextBuilder);
            this.loadTrustMaterial(sslContextBuilder);
            sslContext = sslContextBuilder.build();
        }
        catch (Exception e) {
            throw new SSLInitializationException(e.getMessage(), e);
        }
        return sslContext;
    }

    @Nullable
    private PrivateKeyStrategy choosePrivateKeyStrategy() {
        PrivateKeyStrategy privateKeyStrategy = null;
        if (this.configuration.getCertAlias() != null) {
            privateKeyStrategy = (aliases, socket) -> this.configuration.getCertAlias();
        }
        return privateKeyStrategy;
    }

    private void loadKeyMaterial(SSLContextBuilder sslContextBuilder) throws Exception {
        if (this.configuration.getKeyStorePath() != null) {
            KeyStore keystore = DropwizardSSLConnectionSocketFactory.loadKeyStore(this.configuration.getKeyStoreType(), this.configuration.getKeyStorePath(), Objects.requireNonNull(this.configuration.getKeyStorePassword()));
            sslContextBuilder.loadKeyMaterial(keystore, Objects.requireNonNull(this.configuration.getKeyStorePassword()).toCharArray(), this.choosePrivateKeyStrategy());
        }
    }

    private void loadTrustMaterial(SSLContextBuilder sslContextBuilder) throws Exception {
        KeyStore trustStore = null;
        if (this.configuration.getTrustStorePath() != null) {
            trustStore = DropwizardSSLConnectionSocketFactory.loadKeyStore(this.configuration.getTrustStoreType(), this.configuration.getTrustStorePath(), Objects.requireNonNull(this.configuration.getTrustStorePassword()));
        }
        TrustSelfSignedStrategy trustStrategy = null;
        if (this.configuration.isTrustSelfSignedCertificates()) {
            trustStrategy = new TrustSelfSignedStrategy();
        }
        sslContextBuilder.loadTrustMaterial(trustStore, trustStrategy);
    }

    private static KeyStore loadKeyStore(String type, File path, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(type);
        try (FileInputStream inputStream = new FileInputStream(path);){
            keyStore.load(inputStream, password.toCharArray());
        }
        return keyStore;
    }
}

