/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=5000)
public class RequestIdFilter
implements ContainerResponseFilter {
    private static final String REQUEST_ID = "X-Request-Id";
    private Logger logger = LoggerFactory.getLogger(RequestIdFilter.class);

    @VisibleForTesting
    void setLogger(Logger logger2) {
        this.logger = logger2;
    }

    @Override
    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        String id = request.getHeaderString(REQUEST_ID);
        if (Strings.isNullOrEmpty(id)) {
            id = RequestIdFilter.generateRandomUuid().toString();
        }
        this.logger.trace("method={} path={} request_id={} status={} length={}", request.getMethod(), request.getUriInfo().getPath(), id, response.getStatus(), response.getLength());
        response.getHeaders().putSingle(REQUEST_ID, id);
    }

    private static UUID generateRandomUuid() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long mostSig = ((Random)rnd).nextLong();
        long leastSig = ((Random)rnd).nextLong();
        mostSig &= 0xFFFFFFFFFFFF0FFFL;
        leastSig &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(mostSig |= 0x4000L, leastSig |= Long.MIN_VALUE);
    }
}

