/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.params;

import com.google.common.base.Strings;
import io.dropwizard.jersey.params.AbstractParam;
import io.dropwizard.jersey.params.NonEmptyStringParam;
import io.dropwizard.jersey.validation.JerseyParameterNameProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.server.internal.LocalizationMessages;

public class AbstractParamConverterProvider
implements ParamConverterProvider {
    @Override
    @Nullable
    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (AbstractParam.class.isAssignableFrom(rawType)) {
            Constructor<T> constructor;
            final String parameterName = JerseyParameterNameProvider.getParameterNameFromAnnotations(annotations).orElse("Parameter");
            try {
                constructor = rawType.getConstructor(String.class, String.class);
            }
            catch (NoSuchMethodException ignored) {
                return null;
            }
            return new ParamConverter<T>(){

                @Override
                @Nullable
                public T fromString(String value) {
                    if (rawType != NonEmptyStringParam.class && Strings.isNullOrEmpty(value)) {
                        return null;
                    }
                    try {
                        return this._fromString(value);
                    }
                    catch (InvocationTargetException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof WebApplicationException) {
                            throw (WebApplicationException)cause;
                        }
                        throw new ExtractorException(cause);
                    }
                    catch (Exception ex) {
                        throw new ProcessingException(ex);
                    }
                }

                protected T _fromString(String value) throws Exception {
                    return constructor.newInstance(value, parameterName);
                }

                @Override
                public String toString(T value) throws IllegalArgumentException {
                    if (value == null) {
                        throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
                    }
                    return value.toString();
                }
            };
        }
        return null;
    }
}

