/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.jetty.ConnectorFactory;
import io.dropwizard.jetty.Jetty93InstrumentedConnectionFactory;
import io.dropwizard.jetty.NetUtil;
import io.dropwizard.util.Duration;
import io.dropwizard.util.Size;
import io.dropwizard.util.SizeUnit;
import io.dropwizard.validation.MinDuration;
import io.dropwizard.validation.MinSize;
import io.dropwizard.validation.PortRange;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.hibernate.validator.valuehandling.UnwrapValidatedValue;

@JsonTypeName(value="http")
public class HttpConnectorFactory
implements ConnectorFactory {
    @PortRange
    private int port = 8080;
    @Nullable
    private String bindHost;
    private boolean inheritChannel = false;
    @NotNull
    @MinSize(value=128L)
    private @MinSize(value=128L) Size headerCacheSize = Size.bytes(512L);
    @NotNull
    @MinSize(value=8L, unit=SizeUnit.KILOBYTES)
    private @MinSize(value=8L, unit=SizeUnit.KILOBYTES) Size outputBufferSize = Size.kilobytes(32L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.KILOBYTES)
    private @MinSize(value=1L, unit=SizeUnit.KILOBYTES) Size maxRequestHeaderSize = Size.kilobytes(8L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.KILOBYTES)
    private @MinSize(value=1L, unit=SizeUnit.KILOBYTES) Size maxResponseHeaderSize = Size.kilobytes(8L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.KILOBYTES)
    private @MinSize(value=1L, unit=SizeUnit.KILOBYTES) Size inputBufferSize = Size.kilobytes(8L);
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS) Duration idleTimeout = Duration.seconds(30L);
    @Nullable
    private Duration blockingTimeout;
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.BYTES)
    private @MinSize(value=1L, unit=SizeUnit.BYTES) Size minBufferPoolSize = Size.bytes(64L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.BYTES)
    private @MinSize(value=1L, unit=SizeUnit.BYTES) Size bufferPoolIncrement = Size.bytes(1024L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.BYTES)
    private @MinSize(value=1L, unit=SizeUnit.BYTES) Size maxBufferPoolSize = Size.kilobytes(64L);
    private long minRequestDataRate = 0L;
    @Min(value=1L)
    @UnwrapValidatedValue
    private Optional<Integer> acceptorThreads = Optional.empty();
    @Min(value=1L)
    @UnwrapValidatedValue
    private Optional<Integer> selectorThreads = Optional.empty();
    @Min(value=0L)
    @Nullable
    private Integer acceptQueueSize;
    private boolean reuseAddress = true;
    @Nullable
    private Duration soLingerTime;
    private boolean useServerHeader = false;
    private boolean useDateHeader = true;
    private boolean useForwardedHeaders = true;
    private HttpCompliance httpCompliance = HttpCompliance.RFC7230;

    public static ConnectorFactory application() {
        HttpConnectorFactory factory = new HttpConnectorFactory();
        factory.port = 8080;
        return factory;
    }

    public static ConnectorFactory admin() {
        HttpConnectorFactory factory = new HttpConnectorFactory();
        factory.port = 8081;
        return factory;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    @Nullable
    public String getBindHost() {
        return this.bindHost;
    }

    @JsonProperty
    public void setBindHost(String bindHost) {
        this.bindHost = bindHost;
    }

    @JsonProperty
    public boolean isInheritChannel() {
        return this.inheritChannel;
    }

    @JsonProperty
    public void setInheritChannel(boolean inheritChannel) {
        this.inheritChannel = inheritChannel;
    }

    @JsonProperty
    public Size getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    @JsonProperty
    public void setHeaderCacheSize(Size headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }

    @JsonProperty
    public Size getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @JsonProperty
    public void setOutputBufferSize(Size outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    @JsonProperty
    public Size getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    @JsonProperty
    public void setMaxRequestHeaderSize(Size maxRequestHeaderSize) {
        this.maxRequestHeaderSize = maxRequestHeaderSize;
    }

    @JsonProperty
    public Size getMaxResponseHeaderSize() {
        return this.maxResponseHeaderSize;
    }

    @JsonProperty
    public void setMaxResponseHeaderSize(Size maxResponseHeaderSize) {
        this.maxResponseHeaderSize = maxResponseHeaderSize;
    }

    @JsonProperty
    public Size getInputBufferSize() {
        return this.inputBufferSize;
    }

    @JsonProperty
    public void setInputBufferSize(Size inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    @JsonProperty
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @JsonProperty
    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @JsonProperty
    @Nullable
    public Duration getBlockingTimeout() {
        return this.blockingTimeout;
    }

    @JsonProperty
    public void setBlockingTimeout(Duration blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
    }

    @JsonProperty
    public Size getMinBufferPoolSize() {
        return this.minBufferPoolSize;
    }

    @JsonProperty
    public void setMinBufferPoolSize(Size minBufferPoolSize) {
        this.minBufferPoolSize = minBufferPoolSize;
    }

    @JsonProperty
    public Size getBufferPoolIncrement() {
        return this.bufferPoolIncrement;
    }

    @JsonProperty
    public void setBufferPoolIncrement(Size bufferPoolIncrement) {
        this.bufferPoolIncrement = bufferPoolIncrement;
    }

    @JsonProperty
    public Size getMaxBufferPoolSize() {
        return this.maxBufferPoolSize;
    }

    @JsonProperty
    public void setMaxBufferPoolSize(Size maxBufferPoolSize) {
        this.maxBufferPoolSize = maxBufferPoolSize;
    }

    @JsonProperty
    public long getMinRequestDataRate() {
        return this.minRequestDataRate;
    }

    @JsonProperty
    public void setMinRequestDataRate(long minRequestDataRate) {
        this.minRequestDataRate = minRequestDataRate;
    }

    @JsonProperty
    public Optional<Integer> getAcceptorThreads() {
        return this.acceptorThreads;
    }

    @JsonProperty
    public void setAcceptorThreads(Optional<Integer> acceptorThreads) {
        this.acceptorThreads = acceptorThreads;
    }

    @JsonProperty
    public Optional<Integer> getSelectorThreads() {
        return this.selectorThreads;
    }

    @JsonProperty
    public void setSelectorThreads(Optional<Integer> selectorThreads) {
        this.selectorThreads = selectorThreads;
    }

    @JsonProperty
    @Nullable
    public Integer getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    @JsonProperty
    public void setAcceptQueueSize(Integer acceptQueueSize) {
        this.acceptQueueSize = acceptQueueSize;
    }

    @JsonProperty
    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    @JsonProperty
    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @JsonProperty
    @Nullable
    public Duration getSoLingerTime() {
        return this.soLingerTime;
    }

    @JsonProperty
    public void setSoLingerTime(Duration soLingerTime) {
        this.soLingerTime = soLingerTime;
    }

    @JsonProperty
    public boolean isUseServerHeader() {
        return this.useServerHeader;
    }

    @JsonProperty
    public void setUseServerHeader(boolean useServerHeader) {
        this.useServerHeader = useServerHeader;
    }

    @JsonProperty
    public boolean isUseDateHeader() {
        return this.useDateHeader;
    }

    @JsonProperty
    public void setUseDateHeader(boolean useDateHeader) {
        this.useDateHeader = useDateHeader;
    }

    @JsonProperty
    public boolean isUseForwardedHeaders() {
        return this.useForwardedHeaders;
    }

    @JsonProperty
    public void setUseForwardedHeaders(boolean useForwardedHeaders) {
        this.useForwardedHeaders = useForwardedHeaders;
    }

    @JsonProperty
    public HttpCompliance getHttpCompliance() {
        return this.httpCompliance;
    }

    @JsonProperty
    public void setHttpCompliance(HttpCompliance httpCompliance) {
        this.httpCompliance = httpCompliance;
    }

    @Override
    public Connector build(Server server, MetricRegistry metrics, String name, @Nullable ThreadPool threadPool) {
        HttpConfiguration httpConfig = this.buildHttpConfiguration();
        HttpConnectionFactory httpConnectionFactory = this.buildHttpConnectionFactory(httpConfig);
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        ByteBufferPool bufferPool = this.buildBufferPool();
        return this.buildConnector(server, scheduler, bufferPool, name, threadPool, new Jetty93InstrumentedConnectionFactory(httpConnectionFactory, metrics.timer(this.httpConnections())));
    }

    protected String httpConnections() {
        return MetricRegistry.name(HttpConnectionFactory.class, this.bindHost, Integer.toString(this.port), "connections");
    }

    protected ServerConnector buildConnector(Server server, Scheduler scheduler, ByteBufferPool bufferPool, String name, @Nullable ThreadPool threadPool, ConnectionFactory ... factories) {
        ServerConnector connector = new ServerConnector(server, (Executor)threadPool, scheduler, bufferPool, (int)this.acceptorThreads.orElse(-1), this.selectorThreads.orElse(-1), factories);
        connector.setPort(this.port);
        connector.setHost(this.bindHost);
        connector.setInheritChannel(this.inheritChannel);
        if (this.acceptQueueSize != null) {
            connector.setAcceptQueueSize(this.acceptQueueSize);
        } else {
            connector.setAcceptQueueSize(NetUtil.getTcpBacklog());
        }
        connector.setReuseAddress(this.reuseAddress);
        if (this.soLingerTime != null) {
            connector.setSoLingerTime((int)this.soLingerTime.toMilliseconds());
        }
        connector.setIdleTimeout(this.idleTimeout.toMilliseconds());
        connector.setName(name);
        return connector;
    }

    protected HttpConnectionFactory buildHttpConnectionFactory(HttpConfiguration httpConfig) {
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig, this.httpCompliance);
        httpConnectionFactory.setInputBufferSize((int)this.inputBufferSize.toBytes());
        return httpConnectionFactory;
    }

    protected HttpConfiguration buildHttpConfiguration() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setHeaderCacheSize((int)this.headerCacheSize.toBytes());
        httpConfig.setOutputBufferSize((int)this.outputBufferSize.toBytes());
        httpConfig.setRequestHeaderSize((int)this.maxRequestHeaderSize.toBytes());
        httpConfig.setResponseHeaderSize((int)this.maxResponseHeaderSize.toBytes());
        httpConfig.setSendDateHeader(this.useDateHeader);
        httpConfig.setSendServerVersion(this.useServerHeader);
        httpConfig.setMinRequestDataRate(this.minRequestDataRate);
        if (this.useForwardedHeaders) {
            httpConfig.addCustomizer(new ForwardedRequestCustomizer());
        }
        if (this.blockingTimeout != null) {
            httpConfig.setBlockingTimeout(this.blockingTimeout.toMilliseconds());
        }
        return httpConfig;
    }

    protected ByteBufferPool buildBufferPool() {
        return new ArrayByteBufferPool((int)this.minBufferPoolSize.toBytes(), (int)this.bufferPoolIncrement.toBytes(), (int)this.maxBufferPoolSize.toBytes());
    }
}

