/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.util.FileSize;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.AbstractOutputStreamAppenderFactory;
import io.dropwizard.util.Size;
import io.dropwizard.validation.MinSize;
import io.dropwizard.validation.ValidationMethod;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;

@JsonTypeName(value="file")
public class FileAppenderFactory<E extends DeferredProcessingAware>
extends AbstractOutputStreamAppenderFactory<E> {
    @Nullable
    private String currentLogFilename;
    private boolean archive = true;
    @Nullable
    private String archivedLogFilenamePattern;
    @Min(value=0L)
    private int archivedFileCount = 5;
    @Nullable
    private Size maxFileSize;
    @MinSize(value=1L)
    private @MinSize(value=1L) Size bufferSize = Size.bytes(8192L);
    private boolean immediateFlush = true;

    @JsonProperty
    @Nullable
    public String getCurrentLogFilename() {
        return this.currentLogFilename;
    }

    @JsonProperty
    public void setCurrentLogFilename(@Nullable String currentLogFilename) {
        this.currentLogFilename = currentLogFilename;
    }

    @JsonProperty
    public boolean isArchive() {
        return this.archive;
    }

    @JsonProperty
    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    @JsonProperty
    @Nullable
    public String getArchivedLogFilenamePattern() {
        return this.archivedLogFilenamePattern;
    }

    @JsonProperty
    public void setArchivedLogFilenamePattern(String archivedLogFilenamePattern) {
        this.archivedLogFilenamePattern = archivedLogFilenamePattern;
    }

    @JsonProperty
    public int getArchivedFileCount() {
        return this.archivedFileCount;
    }

    @JsonProperty
    public void setArchivedFileCount(int archivedFileCount) {
        this.archivedFileCount = archivedFileCount;
    }

    @JsonProperty
    @Nullable
    public Size getMaxFileSize() {
        return this.maxFileSize;
    }

    @JsonProperty
    public void setMaxFileSize(Size maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    @JsonProperty
    public Size getBufferSize() {
        return this.bufferSize;
    }

    @JsonProperty
    public void setBufferSize(Size bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    @JsonProperty
    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    @JsonIgnore
    @ValidationMethod(message="must have archivedLogFilenamePattern if archive is true")
    public boolean isValidArchiveConfiguration() {
        return !this.archive || this.archivedLogFilenamePattern != null;
    }

    @JsonIgnore
    @ValidationMethod(message="when specifying maxFileSize, archivedLogFilenamePattern must contain %i")
    public boolean isValidForMaxFileSizeSetting() {
        return !this.archive || this.maxFileSize == null || this.archivedLogFilenamePattern != null && this.archivedLogFilenamePattern.contains("%i");
    }

    @JsonIgnore
    @ValidationMethod(message="when archivedLogFilenamePattern contains %i, maxFileSize must be specified")
    public boolean isMaxFileSizeSettingSpecified() {
        return !this.archive || this.archivedLogFilenamePattern == null || !this.archivedLogFilenamePattern.contains("%i") || this.maxFileSize != null;
    }

    @JsonIgnore
    @ValidationMethod(message="currentLogFilename can only be null when archiving is enabled")
    public boolean isValidFileConfiguration() {
        return this.archive || this.currentLogFilename != null;
    }

    @Override
    protected OutputStreamAppender<E> appender(LoggerContext context) {
        FileAppender<E> appender = this.buildAppender(context);
        appender.setName("file-appender");
        appender.setAppend(true);
        appender.setContext(context);
        appender.setImmediateFlush(this.immediateFlush);
        appender.setPrudent(false);
        return appender;
    }

    protected FileAppender<E> buildAppender(LoggerContext context) {
        if (this.archive) {
            TimeBasedRollingPolicy rollingPolicy;
            RollingFileAppender appender = new RollingFileAppender();
            appender.setContext(context);
            appender.setFile(this.currentLogFilename);
            appender.setBufferSize(new FileSize(this.bufferSize.toBytes()));
            if (this.maxFileSize != null && !Objects.requireNonNull(this.archivedLogFilenamePattern).contains("%d")) {
                FixedWindowRollingPolicy rollingPolicy2 = new FixedWindowRollingPolicy();
                rollingPolicy2.setContext(context);
                rollingPolicy2.setMaxIndex(this.getArchivedFileCount());
                rollingPolicy2.setFileNamePattern(this.getArchivedLogFilenamePattern());
                rollingPolicy2.setParent(appender);
                rollingPolicy2.start();
                appender.setRollingPolicy(rollingPolicy2);
                SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
                triggeringPolicy.setMaxFileSize(new FileSize(this.maxFileSize.toBytes()));
                triggeringPolicy.setContext(context);
                triggeringPolicy.start();
                appender.setTriggeringPolicy(triggeringPolicy);
                return appender;
            }
            if (this.maxFileSize == null) {
                rollingPolicy = new TimeBasedRollingPolicy();
                DefaultTimeBasedFileNamingAndTriggeringPolicy triggeringPolicy = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
                triggeringPolicy.setContext(context);
                triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
                appender.setTriggeringPolicy(triggeringPolicy);
            } else {
                SizeAndTimeBasedRollingPolicy sizeAndTimeBasedRollingPolicy = new SizeAndTimeBasedRollingPolicy();
                sizeAndTimeBasedRollingPolicy.setMaxFileSize(new FileSize(this.maxFileSize.toBytes()));
                rollingPolicy = sizeAndTimeBasedRollingPolicy;
            }
            rollingPolicy.setContext(context);
            rollingPolicy.setFileNamePattern(this.archivedLogFilenamePattern);
            rollingPolicy.setMaxHistory(this.archivedFileCount);
            appender.setRollingPolicy(rollingPolicy);
            rollingPolicy.setParent(appender);
            rollingPolicy.start();
            return appender;
        }
        FileAppender appender = new FileAppender();
        appender.setContext(context);
        appender.setFile(this.currentLogFilename);
        appender.setBufferSize(new FileSize(this.bufferSize.toBytes()));
        return appender;
    }
}

