/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.MetricFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.dropwizard.metrics.DefaultStringMatchingStrategy;
import io.dropwizard.metrics.RegexStringMatchingStrategy;
import io.dropwizard.metrics.ReporterFactory;
import io.dropwizard.metrics.SubstringMatchingStrategy;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.valuehandling.UnwrapValidatedValue;

public abstract class BaseReporterFactory
implements ReporterFactory {
    private static final DefaultStringMatchingStrategy DEFAULT_STRING_MATCHING_STRATEGY = new DefaultStringMatchingStrategy();
    private static final RegexStringMatchingStrategy REGEX_STRING_MATCHING_STRATEGY = new RegexStringMatchingStrategy();
    private static final SubstringMatchingStrategy SUBSTRING_MATCHING_STRATEGY = new SubstringMatchingStrategy();
    @NotNull
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    @NotNull
    private TimeUnit rateUnit = TimeUnit.SECONDS;
    @NotNull
    private ImmutableSet<String> excludes = ImmutableSet.of();
    @NotNull
    private ImmutableSet<String> includes = ImmutableSet.of();
    @Valid
    @MinDuration(value=0L)
    @UnwrapValidatedValue
    private @MinDuration(value=0L) Optional<Duration> frequency = Optional.empty();
    private boolean useRegexFilters = false;
    private boolean useSubstringMatching = false;
    private EnumSet<MetricAttribute> excludesAttributes = EnumSet.noneOf(MetricAttribute.class);
    private EnumSet<MetricAttribute> includesAttributes = EnumSet.allOf(MetricAttribute.class);

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    @JsonProperty
    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    @JsonProperty
    public TimeUnit getRateUnit() {
        return this.rateUnit;
    }

    @JsonProperty
    public void setRateUnit(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    @JsonProperty
    public ImmutableSet<String> getIncludes() {
        return this.includes;
    }

    @JsonProperty
    public void setIncludes(ImmutableSet<String> includes) {
        this.includes = includes;
    }

    @JsonProperty
    public ImmutableSet<String> getExcludes() {
        return this.excludes;
    }

    @JsonProperty
    public void setExcludes(ImmutableSet<String> excludes) {
        this.excludes = excludes;
    }

    @Override
    @JsonProperty
    public Optional<Duration> getFrequency() {
        return this.frequency;
    }

    @JsonProperty
    public void setFrequency(Optional<Duration> frequency) {
        this.frequency = frequency;
    }

    @JsonProperty
    public boolean getUseRegexFilters() {
        return this.useRegexFilters;
    }

    @JsonProperty
    public void setUseRegexFilters(boolean useRegexFilters) {
        this.useRegexFilters = useRegexFilters;
    }

    @JsonProperty
    public boolean getUseSubstringMatching() {
        return this.useSubstringMatching;
    }

    @JsonProperty
    public void setUseSubstringMatching(boolean useSubstringMatching) {
        this.useSubstringMatching = useSubstringMatching;
    }

    @JsonProperty
    public EnumSet<MetricAttribute> getExcludesAttributes() {
        return this.excludesAttributes;
    }

    @JsonProperty
    public void setExcludesAttributes(EnumSet<MetricAttribute> excludesAttributes) {
        this.excludesAttributes = excludesAttributes;
    }

    @JsonProperty
    public EnumSet<MetricAttribute> getIncludesAttributes() {
        return this.includesAttributes;
    }

    @JsonProperty
    public void setIncludesAttributes(EnumSet<MetricAttribute> includesAttributes) {
        this.includesAttributes = includesAttributes;
    }

    @JsonIgnore
    public MetricFilter getFilter() {
        RegexStringMatchingStrategy stringMatchingStrategy = this.getUseRegexFilters() ? REGEX_STRING_MATCHING_STRATEGY : (this.getUseSubstringMatching() ? SUBSTRING_MATCHING_STRATEGY : DEFAULT_STRING_MATCHING_STRATEGY);
        return (name, metric) -> !stringMatchingStrategy.containsMatch(this.getExcludes(), name) && (this.getIncludes().isEmpty() || stringMatchingStrategy.containsMatch(this.getIncludes(), name));
    }

    protected Set<MetricAttribute> getDisabledAttributes() {
        return ImmutableSet.copyOf(Sets.union(Sets.difference(EnumSet.allOf(MetricAttribute.class), this.getIncludesAttributes()), this.getExcludesAttributes()));
    }
}

