/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation.selfvalidating;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import io.dropwizard.validation.selfvalidating.SelfValidating;
import io.dropwizard.validation.selfvalidating.SelfValidation;
import io.dropwizard.validation.selfvalidating.ValidationCaller;
import io.dropwizard.validation.selfvalidating.ViolationCollector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfValidatingValidator
implements ConstraintValidator<SelfValidating, Object> {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final Logger log = LoggerFactory.getLogger(SelfValidatingValidator.class);
    private final ConcurrentMap<Class<?>, List<ValidationCaller<?>>> methodMap = Maps.newConcurrentMap();

    @Override
    public void initialize(SelfValidating constraintAnnotation) {
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        ViolationCollector collector = new ViolationCollector(context);
        context.disableDefaultConstraintViolation();
        for (ValidationCaller caller : this.methodMap.computeIfAbsent(value.getClass(), this::findMethods)) {
            caller.setValidationObject(value);
            caller.call(collector);
        }
        return !collector.hasViolationOccurred();
    }

    private List<ValidationCaller<?>> findMethods(Class<?> annotated) {
        CtClass[] callingParameters;
        CtClass callerSuperclass;
        ClassPool cp;
        try {
            cp = ClassPool.getDefault();
            callerSuperclass = cp.get(ValidationCaller.class.getName());
            callingParameters = new CtClass[]{cp.get(ViolationCollector.class.getName())};
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("Failed to load included class", e);
        }
        List<ValidationCaller<?>> callers = Arrays.stream(annotated.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(SelfValidation.class)).filter(this::isCorrectMethod).map(m -> {
            try {
                CtClass cc = cp.makeClass("ValidationCallerGeneratedImpl" + COUNTER.getAndIncrement());
                cc.setSuperclass(callerSuperclass);
                CtMethod cm = new CtMethod(CtClass.voidType, "call", callingParameters, cc);
                cc.addMethod(cm);
                cm.setBody("{ return ((" + annotated.getName() + ")getValidationObject())." + m.getName() + "($1); }");
                cc.setModifiers(1);
                return (ValidationCaller)cc.toClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to generate ValidationCaller for method " + m, e);
            }
        }).collect(Collectors.toList());
        if (callers.isEmpty()) {
            log.error("The class {} is annotated with @SelfValidating but contains no valid methods that are annotated with @SelfValidation", (Object)annotated);
        }
        return callers;
    }

    @VisibleForTesting
    boolean isCorrectMethod(Method m) {
        if (!Void.TYPE.equals(m.getReturnType())) {
            log.error("The method {} is annotated with @SelfValidation but does not return void. It is ignored", (Object)m);
            return false;
        }
        if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].equals(ViolationCollector.class)) {
            log.error("The method {} is annotated with @SelfValidation but does not have a single parameter of type {}", (Object)m, (Object)ViolationCollector.class);
            return false;
        }
        if (!Modifier.isPublic(m.getModifiers())) {
            log.error("The method {} is annotated with @SelfValidation but is not public", (Object)m);
            return false;
        }
        return true;
    }
}

