/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.rx;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.rx.RxInvocationBuilder;
import org.glassfish.jersey.client.rx.RxInvoker;
import org.glassfish.jersey.client.rx.spi.RxInvokerProvider;
import org.glassfish.jersey.internal.ServiceFinder;

final class JerseyRxInvocationBuilder<RX extends RxInvoker>
implements RxInvocationBuilder<RX> {
    private static final Set<RxInvokerProvider> INVOKER_PROVIDERS = new HashSet<RxInvokerProvider>();
    private static final Map<Class<? extends RxInvoker>, RxInvokerProvider> PROVIDER_MAP = new IdentityHashMap<Class<? extends RxInvoker>, RxInvokerProvider>();
    private final Class<RX> invokerType;
    private final ExecutorService executor;
    private RX invoker;
    private Invocation.Builder builder;

    JerseyRxInvocationBuilder(Invocation.Builder builder, Class<RX> invokerType, ExecutorService executor) {
        this.builder = builder;
        this.executor = executor;
        this.invokerType = invokerType;
    }

    @Override
    public RX rx() {
        if (this.invoker == null) {
            this.invoker = this.rx(this.invokerType, this.executor);
        }
        return this.invoker;
    }

    @Override
    public RX rx(ExecutorService executorService) {
        return this.rx(this.invokerType, executorService);
    }

    private <CX extends RxInvoker> CX rx(Class<CX> customType, ExecutorService executor) {
        RxInvokerProvider provider = PROVIDER_MAP.get(customType);
        RxInvoker customInvoker = null;
        if (provider == null) {
            for (RxInvokerProvider invokerProvider : INVOKER_PROVIDERS) {
                customInvoker = (RxInvoker)invokerProvider.getInvoker(customType, this.builder, executor);
                if (customInvoker == null) continue;
                PROVIDER_MAP.put(customType, invokerProvider);
                break;
            }
        } else {
            customInvoker = (RxInvoker)provider.getInvoker(customType, this.builder, executor);
        }
        return (CX)((RxInvoker)customType.cast(customInvoker));
    }

    @Override
    public JerseyRxInvocationBuilder<RX> accept(String ... mediaTypes) {
        this.builder = this.builder.accept(mediaTypes);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> accept(MediaType ... mediaTypes) {
        this.builder = this.builder.accept(mediaTypes);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> acceptLanguage(Locale ... locales) {
        this.builder = this.builder.acceptLanguage(locales);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> acceptLanguage(String ... locales) {
        this.builder = this.builder.acceptLanguage(locales);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> acceptEncoding(String ... encodings) {
        this.builder = this.builder.acceptEncoding(encodings);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> cookie(Cookie cookie) {
        this.builder = this.builder.cookie(cookie);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> cookie(String name, String value) {
        this.builder = this.builder.cookie(name, value);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> cacheControl(CacheControl cacheControl) {
        this.builder = this.builder.cacheControl(cacheControl);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> header(String name, Object value) {
        this.builder = this.builder.header(name, value);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> headers(MultivaluedMap<String, Object> headers) {
        this.builder = this.builder.headers(headers);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> property(String name, Object value) {
        this.builder = this.builder.property(name, value);
        return this;
    }

    @Override
    public Response get() {
        return this.builder.get();
    }

    @Override
    public <T> T get(Class<T> responseType) {
        return this.builder.get(responseType);
    }

    @Override
    public <T> T get(GenericType<T> responseType) {
        return this.builder.get(responseType);
    }

    @Override
    public Response put(Entity<?> entity) {
        return this.builder.put(entity);
    }

    @Override
    public <T> T put(Entity<?> entity, Class<T> responseType) {
        return this.builder.put(entity, responseType);
    }

    @Override
    public <T> T put(Entity<?> entity, GenericType<T> responseType) {
        return this.builder.put(entity, responseType);
    }

    @Override
    public Response post(Entity<?> entity) {
        return this.builder.post(entity);
    }

    @Override
    public <T> T post(Entity<?> entity, Class<T> responseType) {
        return this.builder.post(entity, responseType);
    }

    @Override
    public <T> T post(Entity<?> entity, GenericType<T> responseType) {
        return this.builder.post(entity, responseType);
    }

    @Override
    public Response delete() {
        return this.builder.delete();
    }

    @Override
    public <T> T delete(Class<T> responseType) {
        return this.builder.delete(responseType);
    }

    @Override
    public <T> T delete(GenericType<T> responseType) {
        return this.builder.delete(responseType);
    }

    @Override
    public Response head() {
        return this.builder.head();
    }

    @Override
    public Response options() {
        return this.builder.options();
    }

    @Override
    public <T> T options(Class<T> responseType) {
        return this.builder.options(responseType);
    }

    @Override
    public <T> T options(GenericType<T> responseType) {
        return this.builder.options(responseType);
    }

    @Override
    public Response trace() {
        return this.builder.trace();
    }

    @Override
    public <T> T trace(Class<T> responseType) {
        return this.builder.trace(responseType);
    }

    @Override
    public <T> T trace(GenericType<T> responseType) {
        return this.builder.trace(responseType);
    }

    @Override
    public Response method(String name) {
        return this.builder.method(name);
    }

    @Override
    public <T> T method(String name, Class<T> responseType) {
        return this.builder.method(name, responseType);
    }

    @Override
    public <T> T method(String name, GenericType<T> responseType) {
        return this.builder.method(name, responseType);
    }

    @Override
    public Response method(String name, Entity<?> entity) {
        return this.builder.method(name, entity);
    }

    @Override
    public <T> T method(String name, Entity<?> entity, Class<T> responseType) {
        return this.builder.method(name, entity, responseType);
    }

    @Override
    public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.builder.method(name, entity, responseType);
    }

    @Override
    public Invocation build(String method) {
        return this.builder.build(method);
    }

    @Override
    public Invocation build(String method, Entity<?> entity) {
        return this.builder.build(method, entity);
    }

    @Override
    public Invocation buildGet() {
        return this.builder.buildGet();
    }

    @Override
    public Invocation buildDelete() {
        return this.builder.buildDelete();
    }

    @Override
    public Invocation buildPost(Entity<?> entity) {
        return this.builder.buildPost(entity);
    }

    @Override
    public Invocation buildPut(Entity<?> entity) {
        return this.builder.buildPut(entity);
    }

    @Override
    public AsyncInvoker async() {
        return this.builder.async();
    }

    static {
        for (RxInvokerProvider provider : ServiceFinder.find(RxInvokerProvider.class)) {
            INVOKER_PROVIDERS.add(provider);
        }
    }
}

