/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.ConstraintValidator;
import javax.validation.ParameterNameProvider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.validation.Schema;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.NewJaxbContext;
import org.hibernate.validator.internal.util.privilegedactions.SetContextClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.Unmarshal;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.ConstrainedExecutableBuilder;
import org.hibernate.validator.internal.xml.ConstrainedFieldBuilder;
import org.hibernate.validator.internal.xml.ConstrainedGetterBuilder;
import org.hibernate.validator.internal.xml.ConstrainedTypeBuilder;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.XmlParserHelper;
import org.hibernate.validator.internal.xml.binding.BeanType;
import org.hibernate.validator.internal.xml.binding.ConstraintDefinitionType;
import org.hibernate.validator.internal.xml.binding.ConstraintMappingsType;
import org.hibernate.validator.internal.xml.binding.ValidatedByType;

public class MappingXmlParser {
    private static final Log log = LoggerFactory.make();
    private final Set<Class<?>> processedClasses = CollectionHelper.newHashSet();
    private final ConstraintHelper constraintHelper;
    private final AnnotationProcessingOptionsImpl annotationProcessingOptions;
    private final Map<Class<?>, List<Class<?>>> defaultSequences;
    private final Map<Class<?>, Set<ConstrainedElement>> constrainedElements;
    private final XmlParserHelper xmlParserHelper;
    private final ParameterNameProvider parameterNameProvider;
    private final ClassLoadingHelper classLoadingHelper;
    private static final ConcurrentMap<String, String> SCHEMAS_BY_VERSION = new ConcurrentHashMap<String, String>(2, 0.75f, 1);

    public MappingXmlParser(ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider, ClassLoader externalClassLoader) {
        this.constraintHelper = constraintHelper;
        this.annotationProcessingOptions = new AnnotationProcessingOptionsImpl();
        this.defaultSequences = CollectionHelper.newHashMap();
        this.constrainedElements = CollectionHelper.newHashMap();
        this.xmlParserHelper = new XmlParserHelper();
        this.parameterNameProvider = parameterNameProvider;
        this.classLoadingHelper = new ClassLoadingHelper(externalClassLoader);
    }

    public final void parse(Set<InputStream> mappingStreams) {
        try {
            JAXBContext jc = this.run(NewJaxbContext.action(ConstraintMappingsType.class));
            MetaConstraintBuilder metaConstraintBuilder = new MetaConstraintBuilder(this.classLoadingHelper, this.constraintHelper);
            GroupConversionBuilder groupConversionBuilder = new GroupConversionBuilder(this.classLoadingHelper);
            ConstrainedTypeBuilder constrainedTypeBuilder = new ConstrainedTypeBuilder(this.classLoadingHelper, metaConstraintBuilder, this.annotationProcessingOptions, this.defaultSequences);
            ConstrainedFieldBuilder constrainedFieldBuilder = new ConstrainedFieldBuilder(metaConstraintBuilder, groupConversionBuilder, this.annotationProcessingOptions);
            ConstrainedExecutableBuilder constrainedExecutableBuilder = new ConstrainedExecutableBuilder(this.classLoadingHelper, this.parameterNameProvider, metaConstraintBuilder, groupConversionBuilder, this.annotationProcessingOptions);
            ConstrainedGetterBuilder constrainedGetterBuilder = new ConstrainedGetterBuilder(metaConstraintBuilder, groupConversionBuilder, this.annotationProcessingOptions);
            HashSet<String> alreadyProcessedConstraintDefinitions = CollectionHelper.newHashSet();
            for (InputStream in : mappingStreams) {
                boolean markSupported = in.markSupported();
                if (markSupported) {
                    in.mark(Integer.MAX_VALUE);
                }
                ConstraintMappingsType mapping = this.unmarshal(jc, in);
                String defaultPackage = mapping.getDefaultPackage();
                this.parseConstraintDefinitions(mapping.getConstraintDefinition(), defaultPackage, alreadyProcessedConstraintDefinitions);
                for (BeanType bean : mapping.getBean()) {
                    this.processBeanType(constrainedTypeBuilder, constrainedFieldBuilder, constrainedExecutableBuilder, constrainedGetterBuilder, defaultPackage, bean);
                }
                if (!markSupported) continue;
                try {
                    in.reset();
                }
                catch (IOException e) {
                    log.debug("Unable to reset input stream.");
                }
            }
        }
        catch (JAXBException e) {
            throw log.getErrorParsingMappingFileException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConstraintMappingsType unmarshal(JAXBContext jc, InputStream in) throws JAXBException {
        ClassLoader previousTccl = MappingXmlParser.run(GetClassLoader.fromContext());
        try {
            MappingXmlParser.run(SetContextClassLoader.action(MappingXmlParser.class.getClassLoader()));
            XMLEventReader xmlEventReader = this.xmlParserHelper.createXmlEventReader("constraint mapping file", new CloseIgnoringInputStream(in));
            String schemaVersion = this.xmlParserHelper.getSchemaVersion("constraint mapping file", xmlEventReader);
            String schemaResourceName = this.getSchemaResourceName(schemaVersion);
            Schema schema = this.xmlParserHelper.getSchema(schemaResourceName);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            ConstraintMappingsType constraintMappingsType = this.getValidationConfig(xmlEventReader, unmarshaller);
            return constraintMappingsType;
        }
        finally {
            MappingXmlParser.run(SetContextClassLoader.action(previousTccl));
        }
    }

    public final Set<Class<?>> getXmlConfiguredClasses() {
        return this.processedClasses;
    }

    public final AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return this.annotationProcessingOptions;
    }

    public final Set<ConstrainedElement> getConstrainedElementsForClass(Class<?> beanClass) {
        if (this.constrainedElements.containsKey(beanClass)) {
            return this.constrainedElements.get(beanClass);
        }
        return Collections.emptySet();
    }

    public final List<Class<?>> getDefaultSequenceForClass(Class<?> beanClass) {
        return this.defaultSequences.get(beanClass);
    }

    private void processBeanType(ConstrainedTypeBuilder constrainedTypeBuilder, ConstrainedFieldBuilder constrainedFieldBuilder, ConstrainedExecutableBuilder constrainedExecutableBuilder, ConstrainedGetterBuilder constrainedGetterBuilder, String defaultPackage, BeanType bean) {
        Class<?> beanClass = this.classLoadingHelper.loadClass(bean.getClazz(), defaultPackage);
        this.checkClassHasNotBeenProcessed(this.processedClasses, beanClass);
        this.annotationProcessingOptions.ignoreAnnotationConstraintForClass(beanClass, bean.getIgnoreAnnotations());
        ConstrainedType constrainedType = constrainedTypeBuilder.buildConstrainedType(bean.getClassType(), beanClass, defaultPackage);
        if (constrainedType != null) {
            this.addConstrainedElement(beanClass, constrainedType);
        }
        Set<ConstrainedField> constrainedFields = constrainedFieldBuilder.buildConstrainedFields(bean.getField(), beanClass, defaultPackage);
        this.addConstrainedElements(beanClass, constrainedFields);
        Set<ConstrainedExecutable> constrainedGetters = constrainedGetterBuilder.buildConstrainedGetters(bean.getGetter(), beanClass, defaultPackage);
        this.addConstrainedElements(beanClass, constrainedGetters);
        Set<ConstrainedExecutable> constrainedConstructors = constrainedExecutableBuilder.buildConstructorConstrainedExecutable(bean.getConstructor(), beanClass, defaultPackage);
        this.addConstrainedElements(beanClass, constrainedConstructors);
        Set<ConstrainedExecutable> constrainedMethods = constrainedExecutableBuilder.buildMethodConstrainedExecutable(bean.getMethod(), beanClass, defaultPackage);
        this.addConstrainedElements(beanClass, constrainedMethods);
        this.processedClasses.add(beanClass);
    }

    private void parseConstraintDefinitions(List<ConstraintDefinitionType> constraintDefinitionList, String defaultPackage, Set<String> alreadyProcessedConstraintDefinitions) {
        for (ConstraintDefinitionType constraintDefinition : constraintDefinitionList) {
            String annotationClassName = constraintDefinition.getAnnotation();
            if (alreadyProcessedConstraintDefinitions.contains(annotationClassName)) {
                throw log.getOverridingConstraintDefinitionsInMultipleMappingFilesException(annotationClassName);
            }
            alreadyProcessedConstraintDefinitions.add(annotationClassName);
            Class<?> clazz = this.classLoadingHelper.loadClass(annotationClassName, defaultPackage);
            if (!clazz.isAnnotation()) {
                throw log.getIsNotAnAnnotationException(clazz);
            }
            Class<?> annotationClass = clazz;
            this.addValidatorDefinitions(annotationClass, defaultPackage, constraintDefinition.getValidatedBy());
        }
    }

    private <A extends Annotation> void addValidatorDefinitions(Class<A> annotationClass, String defaultPackage, ValidatedByType validatedByType) {
        ArrayList constraintValidatorClasses = CollectionHelper.newArrayList();
        for (String validatorClassName : validatedByType.getValue()) {
            Class<?> validatorClass = this.classLoadingHelper.loadClass(validatorClassName, defaultPackage);
            if (!ConstraintValidator.class.isAssignableFrom(validatorClass)) {
                throw log.getIsNotAConstraintValidatorClassException(validatorClass);
            }
            constraintValidatorClasses.add(validatorClass);
        }
        this.constraintHelper.putValidatorClasses(annotationClass, constraintValidatorClasses, Boolean.TRUE.equals(validatedByType.getIncludeExistingValidators()));
    }

    private void checkClassHasNotBeenProcessed(Set<Class<?>> processedClasses, Class<?> beanClass) {
        if (processedClasses.contains(beanClass)) {
            throw log.getBeanClassHasAlreadyBeConfiguredInXmlException(beanClass);
        }
    }

    private void addConstrainedElement(Class<?> beanClass, ConstrainedElement constrainedElement) {
        if (this.constrainedElements.containsKey(beanClass)) {
            this.constrainedElements.get(beanClass).add(constrainedElement);
        } else {
            HashSet tmpList = CollectionHelper.newHashSet();
            tmpList.add(constrainedElement);
            this.constrainedElements.put(beanClass, tmpList);
        }
    }

    private void addConstrainedElements(Class<?> beanClass, Set<? extends ConstrainedElement> newConstrainedElements) {
        if (this.constrainedElements.containsKey(beanClass)) {
            Set<ConstrainedElement> existingConstrainedElements = this.constrainedElements.get(beanClass);
            for (ConstrainedElement constrainedElement : newConstrainedElements) {
                for (ConstrainedElement existingConstrainedElement : existingConstrainedElements) {
                    if (existingConstrainedElement.getLocation().getMember() == null || !existingConstrainedElement.getLocation().getMember().equals(constrainedElement.getLocation().getMember())) continue;
                    ConstraintLocation location = constrainedElement.getLocation();
                    throw log.getConstrainedElementConfiguredMultipleTimesException(location.getMember().toString());
                }
                existingConstrainedElements.add(constrainedElement);
            }
        } else {
            HashSet tmpSet = CollectionHelper.newHashSet();
            tmpSet.addAll(newConstrainedElements);
            this.constrainedElements.put(beanClass, tmpSet);
        }
    }

    private ConstraintMappingsType getValidationConfig(XMLEventReader xmlEventReader, Unmarshaller unmarshaller) {
        ConstraintMappingsType constraintMappings;
        try {
            JAXBElement root = (JAXBElement)((Object)this.run(Unmarshal.action(unmarshaller, xmlEventReader, ConstraintMappingsType.class)));
            constraintMappings = (ConstraintMappingsType)root.getValue();
        }
        catch (Exception e) {
            throw log.getErrorParsingMappingFileException(e);
        }
        return constraintMappings;
    }

    private String getSchemaResourceName(String schemaVersion) {
        String schemaResource = (String)SCHEMAS_BY_VERSION.get(schemaVersion);
        if (schemaResource == null) {
            throw log.getUnsupportedSchemaVersionException("constraint mapping file", schemaVersion);
        }
        return schemaResource;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private <T> T run(PrivilegedExceptionAction<T> action) throws JAXBException {
        try {
            return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (Exception e) {
            throw log.getErrorParsingMappingFileException(e);
        }
    }

    static {
        SCHEMAS_BY_VERSION.put("1.0", "META-INF/validation-mapping-1.0.xsd");
        SCHEMAS_BY_VERSION.put("1.1", "META-INF/validation-mapping-1.1.xsd");
    }

    private static class CloseIgnoringInputStream
    extends FilterInputStream {
        public CloseIgnoringInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

