/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import java.util.SortedMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.mapdb.Fun;

public class Shape {
    public static GeometryFactory geometryFactory = new GeometryFactory();
    public LineString geometry;
    public double[] shape_dist_traveled;

    public Shape(GTFSFeed feed, String shape_id) {
        SortedMap points = feed.shape_points.subMap(new Fun.Tuple2((Object)shape_id, null), new Fun.Tuple2((Object)shape_id, Fun.HI));
        Coordinate[] coords = (Coordinate[])points.values().stream().map(point -> new Coordinate(point.shape_pt_lon, point.shape_pt_lat)).toArray(Coordinate[]::new);
        this.geometry = geometryFactory.createLineString(coords);
        this.shape_dist_traveled = points.values().stream().mapToDouble(point -> point.shape_dist_traveled).toArray();
    }
}

