/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import java.io.IOException;

public class Transfer
extends Entity {
    private static final long serialVersionUID = -4944512120812641063L;
    public String from_stop_id;
    public String to_stop_id;
    public int transfer_type;
    public int min_transfer_time;
    public String from_route_id;
    public String to_route_id;
    public String from_trip_id;
    public String to_trip_id;

    public String toString() {
        return "Transfer{from_stop_id='" + this.from_stop_id + "', to_stop_id='" + this.to_stop_id + "', transfer_type=" + this.transfer_type + ", min_transfer_time=" + this.min_transfer_time + ", from_route_id='" + this.from_route_id + "', to_route_id='" + this.to_route_id + "', from_trip_id='" + this.from_trip_id + "', to_trip_id='" + this.to_trip_id + "'}";
    }

    public Transfer clone() {
        try {
            return (Transfer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Loader
    extends Entity.Loader<Transfer> {
        public Loader(GTFSFeed feed) {
            super(feed, "transfers");
        }

        @Override
        protected boolean isRequired() {
            return false;
        }

        @Override
        public void loadOneRow() throws IOException {
            Transfer tr = new Transfer();
            tr.sourceFileLine = this.row + 1L;
            tr.from_stop_id = this.getStringField("from_stop_id", true);
            tr.to_stop_id = this.getStringField("to_stop_id", true);
            tr.transfer_type = this.getIntField("transfer_type", true, 0, 3);
            tr.min_transfer_time = this.getIntField("min_transfer_time", false, 0, Integer.MAX_VALUE);
            tr.from_route_id = this.getStringField("from_route_id", false);
            tr.to_route_id = this.getStringField("to_route_id", false);
            tr.from_trip_id = this.getStringField("from_trip_id", false);
            tr.to_trip_id = this.getStringField("to_trip_id", false);
            this.getRefField("from_stop_id", true, this.feed.stops);
            this.getRefField("to_stop_id", true, this.feed.stops);
            this.getRefField("from_route_id", false, this.feed.routes);
            this.getRefField("to_route_id", false, this.feed.routes);
            this.getRefField("from_trip_id", false, this.feed.trips);
            this.getRefField("to_trip_id", false, this.feed.trips);
            tr.feed = this.feed;
            this.feed.transfers.put(Long.toString(this.row), tr);
        }
    }
}

