/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Transfer;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsReader;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.gtfs.TripFromLabel;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.InMemConstructionIndex;
import com.graphhopper.storage.index.IndexStructureInfo;
import com.graphhopper.storage.index.LineIntIndex;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.BBox;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperGtfs
extends GraphHopper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphHopperGtfs.class);
    private final GraphHopperConfig ghConfig;
    private GtfsStorage gtfsStorage;
    private PtGraph ptGraph;

    public GraphHopperGtfs(GraphHopperConfig ghConfig) {
        this.ghConfig = ghConfig;
    }

    protected void importOSM() {
        if (this.ghConfig.has("datareader.file")) {
            super.importOSM();
        } else {
            this.createBaseGraphAndProperties();
        }
    }

    protected void importPublicTransit() {
        this.ptGraph = new PtGraph(this.getBaseGraph().getDirectory(), 100);
        this.gtfsStorage = new GtfsStorage(this.getBaseGraph().getDirectory());
        LineIntIndex stopIndex = new LineIntIndex(new BBox(-180.0, 180.0, -90.0, 90.0), this.getBaseGraph().getDirectory(), "stop_index");
        if (this.getGtfsStorage().loadExisting()) {
            this.ptGraph.loadExisting();
            stopIndex.loadExisting();
        } else {
            this.ensureWriteAccess();
            this.getGtfsStorage().create();
            this.ptGraph.create(100L);
            InMemConstructionIndex indexBuilder = new InMemConstructionIndex(IndexStructureInfo.create((BBox)new BBox(-180.0, 180.0, -90.0, 90.0), (int)300));
            try {
                int idx = 0;
                List<String> gtfsFiles = this.ghConfig.has("gtfs.file") ? Arrays.asList(this.ghConfig.getString("gtfs.file", "").split(",")) : Collections.emptyList();
                for (String gtfsFile : gtfsFiles) {
                    this.getGtfsStorage().loadGtfsFromZipFileOrDirectory("gtfs_" + idx++, new File(gtfsFile));
                }
                this.getGtfsStorage().postInit();
                HashMap<String, Transfers> allTransfers = new HashMap<String, Transfers>();
                HashMap<String, GtfsReader> allReaders = new HashMap<String, GtfsReader>();
                this.getGtfsStorage().getGtfsFeeds().forEach((id, gtfsFeed) -> {
                    Transfers transfers = new Transfers((GTFSFeed)gtfsFeed);
                    allTransfers.put((String)id, transfers);
                    GtfsReader gtfsReader = new GtfsReader((String)id, this.ptGraph, this.ptGraph, this.getGtfsStorage(), this.getLocationIndex(), transfers, indexBuilder);
                    List snapFilters = this.getProfiles().stream().map(p -> new DefaultSnapFilter(this.createWeighting((Profile)p, new PMap()), this.getEncodingManager().getBooleanEncodedValue(Subnetwork.key((String)p.getName())))).collect(Collectors.toList());
                    gtfsReader.connectStopsToStreetNetwork(e -> {
                        for (DefaultSnapFilter snapFilter : snapFilters) {
                            if (snapFilter.accept(e)) continue;
                            return false;
                        }
                        return true;
                    });
                    LOGGER.info("Building transit graph for feed {}", (Object)gtfsFeed.feedId);
                    gtfsReader.buildPtNetwork();
                    allReaders.put((String)id, gtfsReader);
                });
                this.interpolateTransfers(allReaders, allTransfers);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while constructing transit network. Is your GTFS file valid? Please check log for possible causes.", e);
            }
            this.ptGraph.flush();
            this.getGtfsStorage().flush();
            stopIndex.store(indexBuilder);
            stopIndex.flush();
        }
        this.gtfsStorage.setStopIndex(stopIndex);
        this.gtfsStorage.setPtGraph(this.ptGraph);
    }

    private void interpolateTransfers(HashMap<String, GtfsReader> readers, Map<String, Transfers> allTransfers) {
        LOGGER.info("Looking for transfers");
        int maxTransferWalkTimeSeconds = this.ghConfig.getInt("gtfs.max_transfer_interpolation_walk_time_seconds", 120);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.getBaseGraph(), Collections.emptyList());
        Weighting transferWeighting = this.createWeighting(this.getProfile("foot"), new PMap());
        GraphExplorer graphExplorer = new GraphExplorer((Graph)queryGraph, this.ptGraph, transferWeighting, this.getGtfsStorage(), RealtimeFeed.empty(), true, true, false, 5.0, false, 0);
        this.getGtfsStorage().getStationNodes().values().stream().distinct().map(n -> new Label.NodeId(this.gtfsStorage.getPtToStreet().getOrDefault(n.intValue(), -1), (int)n)).forEach(stationNode -> {
            MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, true, false, false, 0L, new ArrayList<Label>());
            router.setLimitStreetTime(Duration.ofSeconds(maxTransferWalkTimeSeconds).toMillis());
            for (Label label : router.calcLabels((Label.NodeId)stationNode, Instant.ofEpochMilli(0L))) {
                if (label.parent == null || label.edge.getType() != GtfsStorage.EdgeType.EXIT_PT) continue;
                GtfsStorage.PlatformDescriptor fromPlatformDescriptor = label.edge.getPlatformDescriptor();
                Transfers transfers = (Transfers)allTransfers.get(fromPlatformDescriptor.feed_id);
                for (PtGraph.PtEdge ptEdge : this.ptGraph.edgesAround(stationNode.ptNode)) {
                    if (ptEdge.getType() != GtfsStorage.EdgeType.ENTER_PT) continue;
                    GtfsStorage.PlatformDescriptor toPlatformDescriptor = ptEdge.getAttrs().platformDescriptor;
                    LOGGER.debug(fromPlatformDescriptor + " -> " + toPlatformDescriptor);
                    if (!toPlatformDescriptor.feed_id.equals(fromPlatformDescriptor.feed_id)) {
                        LOGGER.debug(" Different feed. Inserting transfer with " + (int)(label.streetTime / 1000L) + " s.");
                        this.insertInterpolatedTransfer(label, toPlatformDescriptor, readers);
                        continue;
                    }
                    List<Transfer> transfersToStop = transfers.getTransfersToStop(toPlatformDescriptor.stop_id, this.routeIdOrNull(toPlatformDescriptor));
                    if (!transfersToStop.stream().noneMatch(t -> t.from_stop_id.equals(fromPlatformDescriptor.stop_id))) continue;
                    LOGGER.debug("  Inserting transfer with " + (int)(label.streetTime / 1000L) + " s.");
                    this.insertInterpolatedTransfer(label, toPlatformDescriptor, readers);
                }
            }
        });
    }

    private void insertInterpolatedTransfer(Label label, GtfsStorage.PlatformDescriptor toPlatformDescriptor, HashMap<String, GtfsReader> readers) {
        GtfsReader toFeedReader = readers.get(toPlatformDescriptor.feed_id);
        ArrayList<Integer> transferEdgeIds = toFeedReader.insertTransferEdges(label.node.ptNode, (int)(label.streetTime / 1000L), toPlatformDescriptor);
        List<Label.Transition> transitions = Label.getTransitions(label.parent, true);
        int[] skippedEdgesForTransfer = transitions.stream().filter(t -> t.edge != null).mapToInt(t -> {
            Label.NodeId adjNode = t.label.node;
            EdgeIteratorState edgeIteratorState = this.getBaseGraph().getEdgeIteratorState(t.edge.getId(), adjNode.streetNode);
            return edgeIteratorState.getEdgeKey();
        }).toArray();
        if (skippedEdgesForTransfer.length > 0) {
            assert (this.isValidPath(skippedEdgesForTransfer));
            for (Integer transferEdgeId : transferEdgeIds) {
                this.gtfsStorage.getSkippedEdgesForTransfer().put(transferEdgeId.intValue(), (Object)skippedEdgesForTransfer);
            }
        }
    }

    private boolean isValidPath(int[] edgeKeys) {
        List edges = Arrays.stream(edgeKeys).mapToObj(i -> this.getBaseGraph().getEdgeIteratorStateForKey(i)).collect(Collectors.toList());
        for (int i2 = 1; i2 < edges.size(); ++i2) {
            if (((EdgeIteratorState)edges.get(i2)).getBaseNode() == ((EdgeIteratorState)edges.get(i2 - 1)).getAdjNode()) continue;
            return false;
        }
        TripFromLabel tripFromLabel = new TripFromLabel((Graph)this.getBaseGraph(), (EncodedValueLookup)this.getEncodingManager(), this.gtfsStorage, RealtimeFeed.empty(), this.getPathDetailsBuilderFactory(), 6.0);
        tripFromLabel.transferPath(edgeKeys, this.createWeighting(this.getProfile("foot"), new PMap()), 0L);
        return true;
    }

    private String routeIdOrNull(GtfsStorage.PlatformDescriptor platformDescriptor) {
        if (platformDescriptor instanceof GtfsStorage.RouteTypePlatform) {
            return null;
        }
        return ((GtfsStorage.RoutePlatform)platformDescriptor).route_id;
    }

    public void close() {
        this.getGtfsStorage().close();
        super.close();
    }

    public GtfsStorage getGtfsStorage() {
        return this.gtfsStorage;
    }

    public PtGraph getPtGraph() {
        return this.ptGraph;
    }
}

