/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.graphhopper.gtfs.GHLocation;
import com.graphhopper.gtfs.GHPointLocation;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.GHPoint;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Request {
    private List<GHLocation> points;
    private Instant earliestDepartureTime;
    private int maxVisitedNodes = 1000000;
    private boolean profileQuery;
    private Boolean ignoreTransfers;
    private double betaTransfers = 0.0;
    private double betaStreetTime = 1.0;
    private double betaAccessTime = 1.0;
    private double betaEgressTime = 1.0;
    private Integer limitSolutions;
    private boolean arriveBy;
    private double walkSpeedKmH = 5.0;
    private int blockedRouteTypes;
    private Map<Integer, Long> boardingPenaltiesByRouteType = new HashMap<Integer, Long>();
    private Locale locale = Helper.getLocale((String)"en");
    private Duration limitTripTime;
    private Duration limitStreetTime;
    private Duration maxProfileDuration = Duration.ofDays(1L);
    private List<String> pathDetails = new ArrayList<String>();
    private String accessProfile = "foot";
    private String egressProfile = "foot";

    public Request(List<GHLocation> points, Instant departureTime) {
        this.points = points;
        this.earliestDepartureTime = departureTime;
    }

    public Request(double from_lat, double from_lon, double to_lat, double to_lon) {
        this.points = Arrays.asList(new GHPointLocation(new GHPoint(from_lat, from_lon)), new GHPointLocation(new GHPoint(to_lat, to_lon)));
    }

    public int getMaxVisitedNodes() {
        return this.maxVisitedNodes;
    }

    public void setMaxVisitedNodes(int maxVisitedNodes) {
        this.maxVisitedNodes = maxVisitedNodes;
    }

    public boolean isProfileQuery() {
        return this.profileQuery;
    }

    public void setProfileQuery(boolean profileQuery) {
        this.profileQuery = profileQuery;
    }

    public Boolean getIgnoreTransfers() {
        return this.ignoreTransfers;
    }

    public void setIgnoreTransfers(Boolean ignoreTransfers) {
        this.ignoreTransfers = ignoreTransfers;
    }

    public double getBetaTransfers() {
        return this.betaTransfers;
    }

    public void setBetaTransfers(double betaTransfers) {
        this.betaTransfers = betaTransfers;
    }

    public double getBetaStreetTime() {
        return this.betaStreetTime;
    }

    public void setBetaStreetTime(double betaStreetTime) {
        this.betaStreetTime = betaStreetTime;
    }

    public Integer getLimitSolutions() {
        return this.limitSolutions;
    }

    public void setLimitSolutions(Integer limitSolutions) {
        this.limitSolutions = limitSolutions;
    }

    public Instant getEarliestDepartureTime() {
        return this.earliestDepartureTime;
    }

    public void setEarliestDepartureTime(Instant earliestDepartureTime) {
        this.earliestDepartureTime = earliestDepartureTime;
    }

    public boolean isArriveBy() {
        return this.arriveBy;
    }

    public void setArriveBy(boolean arriveBy) {
        this.arriveBy = arriveBy;
    }

    public double getWalkSpeedKmH() {
        return this.walkSpeedKmH;
    }

    public void setWalkSpeedKmH(double walkSpeedKmH) {
        this.walkSpeedKmH = walkSpeedKmH;
    }

    public int getBlockedRouteTypes() {
        return this.blockedRouteTypes;
    }

    public void setBlockedRouteTypes(int blockedRouteTypes) {
        this.blockedRouteTypes = blockedRouteTypes;
    }

    public Map<Integer, Long> getBoardingPenaltiesByRouteType() {
        return this.boardingPenaltiesByRouteType;
    }

    public void setBoardingPenaltiesByRouteType(Map<Integer, Long> boardingPenaltiesByRouteType) {
        this.boardingPenaltiesByRouteType = boardingPenaltiesByRouteType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<GHLocation> getPoints() {
        return this.points;
    }

    public Duration getLimitTripTime() {
        return this.limitTripTime;
    }

    public Duration getLimitStreetTime() {
        return this.limitStreetTime;
    }

    public void setLimitTripTime(Duration tripTime) {
        this.limitTripTime = tripTime;
    }

    public void setLimitStreetTime(Duration streetTime) {
        this.limitStreetTime = streetTime;
    }

    public Duration getMaxProfileDuration() {
        return this.maxProfileDuration;
    }

    public void setMaxProfileDuration(Duration maxProfileDuration) {
        this.maxProfileDuration = maxProfileDuration;
    }

    public List<String> getPathDetails() {
        return this.pathDetails;
    }

    public void setPathDetails(List<String> pathDetails) {
        this.pathDetails = pathDetails;
    }

    public String getAccessProfile() {
        return this.accessProfile;
    }

    public void setAccessProfile(String accessProfile) {
        this.accessProfile = accessProfile;
    }

    public String getEgressProfile() {
        return this.egressProfile;
    }

    public void setEgressProfile(String egressProfile) {
        this.egressProfile = egressProfile;
    }

    public double getBetaAccessTime() {
        return this.betaAccessTime;
    }

    public void setBetaAccessTime(double betaAccessTime) {
        this.betaAccessTime = betaAccessTime;
    }

    public double getBetaEgressTime() {
        return this.betaEgressTime;
    }

    public void setBetaEgressTime(double betaEgressTime) {
        this.betaEgressTime = betaEgressTime;
    }
}

