/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.StopTime;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.ResponsePath;
import com.graphhopper.Trip;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsHelper;
import com.graphhopper.gtfs.GtfsReader;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.fare.Fares;
import com.graphhopper.gtfs.fare.Trip;
import com.graphhopper.routing.InstructionsFromEdges;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.details.PathDetailsFromEdges;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TripFromLabel {
    private static final Logger logger = LoggerFactory.getLogger(TripFromLabel.class);
    private final Graph graph;
    private final EncodedValueLookup encodedValueLookup;
    private final GtfsStorage gtfsStorage;
    private final RealtimeFeed realtimeFeed;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final PathDetailsBuilderFactory pathDetailsBuilderFactory;
    private final double walkSpeedKmH;

    TripFromLabel(Graph graph, EncodedValueLookup encodedValueLookup, GtfsStorage gtfsStorage, RealtimeFeed realtimeFeed, PathDetailsBuilderFactory pathDetailsBuilderFactory, double walkSpeedKmH) {
        this.graph = graph;
        this.encodedValueLookup = encodedValueLookup;
        this.gtfsStorage = gtfsStorage;
        this.realtimeFeed = realtimeFeed;
        this.pathDetailsBuilderFactory = pathDetailsBuilderFactory;
        this.walkSpeedKmH = walkSpeedKmH;
    }

    ResponsePath createResponsePath(Translation tr, PointList waypoints, Graph queryGraph, Weighting accessWeighting, Weighting egressWeighting, Weighting transferWeighting, List<Label.Transition> solution, List<String> requestedPathDetails) {
        List<List<Label.Transition>> partitions = this.parsePathToPartitions(solution);
        ArrayList<Object> legs = new ArrayList<Object>();
        for (int i = 0; i < partitions.size(); ++i) {
            Weighting weighting = i == 0 ? accessWeighting : (i == partitions.size() - 1 ? egressWeighting : transferWeighting);
            legs.addAll(this.parsePartitionToLegs(partitions.get(i), queryGraph, this.encodedValueLookup, weighting, tr, requestedPathDetails));
        }
        if (legs.size() > 1 && legs.get(0) instanceof Trip.WalkLeg) {
            Trip.WalkLeg accessLeg = (Trip.WalkLeg)legs.get(0);
            legs.set(0, new Trip.WalkLeg(accessLeg.departureLocation, new Date(((Trip.Leg)legs.get(1)).getDepartureTime().getTime() - (accessLeg.getArrivalTime().getTime() - accessLeg.getDepartureTime().getTime())), accessLeg.geometry, accessLeg.distance, accessLeg.instructions, accessLeg.details, ((Trip.Leg)legs.get(1)).getDepartureTime()));
        }
        if (legs.size() > 1 && legs.get(legs.size() - 1) instanceof Trip.WalkLeg) {
            Trip.WalkLeg egressLeg = (Trip.WalkLeg)legs.get(legs.size() - 1);
            legs.set(legs.size() - 1, new Trip.WalkLeg(egressLeg.departureLocation, ((Trip.Leg)legs.get(legs.size() - 2)).getArrivalTime(), egressLeg.geometry, egressLeg.distance, egressLeg.instructions, egressLeg.details, new Date(((Trip.Leg)legs.get(legs.size() - 2)).getArrivalTime().getTime() + (egressLeg.getArrivalTime().getTime() - egressLeg.getDepartureTime().getTime()))));
        }
        ResponsePath path = new ResponsePath();
        path.setWaypoints(waypoints);
        path.getLegs().addAll(legs);
        InstructionList instructions = new InstructionList(tr);
        PointList pointsList = new PointList();
        HashMap pathDetails = new HashMap();
        for (int i = 0; i < path.getLegs().size(); ++i) {
            PointList pl;
            Trip.Leg leg2 = (Trip.Leg)path.getLegs().get(i);
            if (leg2 instanceof Trip.WalkLeg) {
                Trip.WalkLeg walkLeg = (Trip.WalkLeg)leg2;
                List theseInstructions = walkLeg.instructions.subList(0, i < path.getLegs().size() - 1 ? walkLeg.instructions.size() - 1 : walkLeg.instructions.size());
                int previousPointsCount = pointsList.size();
                for (Instruction instruction : theseInstructions) {
                    pointsList.add(instruction.getPoints());
                }
                instructions.addAll((Collection)theseInstructions);
                Map<String, List<PathDetail>> shiftedLegPathDetails = this.shift(((Trip.WalkLeg)leg2).details, previousPointsCount);
                shiftedLegPathDetails.forEach((k, v) -> pathDetails.merge(k, (List)shiftedLegPathDetails.get(k), (a, b) -> Lists.newArrayList((Iterable)Iterables.concat((Iterable)a, (Iterable)b))));
                continue;
            }
            if (!(leg2 instanceof Trip.PtLeg)) continue;
            Trip.PtLeg ptLeg = (Trip.PtLeg)leg2;
            if (!ptLeg.isInSameVehicleAsPrevious) {
                pl = new PointList();
                Instruction departureInstruction = new Instruction(101, ptLeg.trip_headsign, pl);
                departureInstruction.setDistance(leg2.getDistance());
                departureInstruction.setTime(ptLeg.travelTime);
                instructions.add((Object)departureInstruction);
            } else {
                pl = instructions.get(instructions.size() - 2).getPoints();
            }
            pl.add(((Trip.Stop)ptLeg.stops.get((int)0)).geometry.getY(), ((Trip.Stop)ptLeg.stops.get((int)0)).geometry.getX());
            pointsList.add(((Trip.Stop)ptLeg.stops.get((int)0)).geometry.getY(), ((Trip.Stop)ptLeg.stops.get((int)0)).geometry.getX());
            for (Trip.Stop stop : ptLeg.stops.subList(0, ptLeg.stops.size() - 1)) {
                pl.add(stop.geometry.getY(), stop.geometry.getX());
                pointsList.add(stop.geometry.getY(), stop.geometry.getX());
            }
            PointList arrivalPointList = new PointList();
            Trip.Stop arrivalStop = (Trip.Stop)ptLeg.stops.get(ptLeg.stops.size() - 1);
            arrivalPointList.add(arrivalStop.geometry.getY(), arrivalStop.geometry.getX());
            pointsList.add(arrivalStop.geometry.getY(), arrivalStop.geometry.getX());
            Instruction arrivalInstruction = new Instruction(103, arrivalStop.stop_name, arrivalPointList);
            if (ptLeg.isInSameVehicleAsPrevious) {
                instructions.set(instructions.size() - 1, arrivalInstruction);
                continue;
            }
            instructions.add((Object)arrivalInstruction);
        }
        path.setInstructions(instructions);
        path.setPoints(pointsList);
        path.addPathDetails(pathDetails);
        path.setDistance(path.getLegs().stream().mapToDouble(Trip.Leg::getDistance).sum());
        path.setTime(((Trip.Leg)legs.get(legs.size() - 1)).getArrivalTime().toInstant().toEpochMilli() - ((Trip.Leg)legs.get(0)).getDepartureTime().toInstant().toEpochMilli());
        path.setNumChanges((int)path.getLegs().stream().filter(l -> l instanceof Trip.PtLeg).filter(l -> !((Trip.PtLeg)l).isInSameVehicleAsPrevious).count() - 1);
        Trip faresTrip = new Trip();
        path.getLegs().stream().filter(leg -> leg instanceof Trip.PtLeg).map(leg -> (Trip.PtLeg)leg).findFirst().ifPresent(firstPtLeg -> {
            LocalDateTime firstPtDepartureTime = GtfsHelper.localDateTimeFromDate(firstPtLeg.getDepartureTime());
            path.getLegs().stream().filter(leg -> leg instanceof Trip.PtLeg).map(leg -> (Trip.PtLeg)leg).map(ptLeg -> {
                GTFSFeed gtfsFeed = this.gtfsStorage.getGtfsFeeds().get(ptLeg.feed_id);
                return new Trip.Segment(ptLeg.feed_id, ptLeg.route_id, Duration.between(firstPtDepartureTime, GtfsHelper.localDateTimeFromDate(ptLeg.getDepartureTime())).getSeconds(), gtfsFeed.stops.get((Object)((Trip.Stop)ptLeg.stops.get((int)0)).stop_id).zone_id, gtfsFeed.stops.get((Object)((Trip.Stop)ptLeg.stops.get((int)(ptLeg.stops.size() - 1))).stop_id).zone_id, ptLeg.stops.stream().map(s -> gtfsFeed.stops.get((Object)s.stop_id).zone_id).collect(Collectors.toSet()));
            }).forEach(faresTrip.segments::add);
            Fares.cheapestFare(this.gtfsStorage.getFares(), faresTrip).ifPresent(amount -> path.setFare(amount.getAmount()));
        });
        return path;
    }

    private Map<String, List<PathDetail>> shift(Map<String, List<PathDetail>> pathDetailss, int previousPointsCount) {
        return Maps.transformEntries(pathDetailss, (s, pathDetails) -> pathDetails.stream().map(p -> {
            PathDetail pathDetail = new PathDetail(p.getValue());
            pathDetail.setFirst(p.getFirst() + previousPointsCount);
            pathDetail.setLast(p.getLast() + previousPointsCount);
            return pathDetail;
        }).collect(Collectors.toList()));
    }

    private List<List<Label.Transition>> parsePathToPartitions(List<Label.Transition> path) {
        ArrayList<List<Label.Transition>> partitions = new ArrayList<List<Label.Transition>>();
        partitions.add(new ArrayList());
        Iterator<Label.Transition> iterator = path.iterator();
        ((List)partitions.get(partitions.size() - 1)).add(iterator.next());
        iterator.forEachRemaining(transition -> {
            List previous = (List)partitions.get(partitions.size() - 1);
            GraphExplorer.MultiModalEdge previousEdge = ((Label.Transition)previous.get((int)(previous.size() - 1))).edge;
            if (previousEdge != null && (transition.edge.getType() == GtfsStorage.EdgeType.ENTER_PT || previousEdge.getType() == GtfsStorage.EdgeType.EXIT_PT)) {
                ArrayList<Label.Transition> p = new ArrayList<Label.Transition>();
                p.add(new Label.Transition(((Label.Transition)previous.get((int)(previous.size() - 1))).label, null));
                partitions.add(p);
            }
            ((List)partitions.get(partitions.size() - 1)).add(transition);
        });
        return partitions;
    }

    private List<Trip.Leg> parsePartitionToLegs(List<Label.Transition> path, Graph graph, EncodedValueLookup encodedValueLookup, Weighting weighting, Translation tr, List<String> requestedPathDetails) {
        if (path.size() <= 1) {
            return Collections.emptyList();
        }
        if (GtfsStorage.EdgeType.ENTER_PT == path.get((int)1).edge.getType()) {
            String feedId = path.get((int)1).edge.getPlatformDescriptor().feed_id;
            ArrayList<Trip.Leg> result = new ArrayList<Trip.Leg>();
            long boardTime = -1L;
            ArrayList<Label.Transition> partition = null;
            for (int i = 1; i < path.size(); ++i) {
                Label.Transition transition = path.get(i);
                GraphExplorer.MultiModalEdge edge = path.get((int)i).edge;
                if (edge.getType() == GtfsStorage.EdgeType.BOARD) {
                    boardTime = transition.label.currentTime;
                    partition = new ArrayList<Label.Transition>();
                }
                if (partition != null) {
                    partition.add(path.get(i));
                }
                if (!EnumSet.of(GtfsStorage.EdgeType.TRANSFER, GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK).contains((Object)edge.getType())) continue;
                GtfsRealtime.TripDescriptor tripDescriptor = ((Label.Transition)partition.get((int)0)).edge.getTripDescriptor();
                StopsFromBoardHopDwellEdges stopsFromBoardHopDwellEdges = new StopsFromBoardHopDwellEdges(feedId, tripDescriptor);
                partition.stream().filter(e -> EnumSet.of(GtfsStorage.EdgeType.HOP, GtfsStorage.EdgeType.BOARD, GtfsStorage.EdgeType.DWELL).contains((Object)e.edge.getType())).forEach(stopsFromBoardHopDwellEdges::next);
                stopsFromBoardHopDwellEdges.finish();
                List<Trip.Stop> stops = stopsFromBoardHopDwellEdges.stops;
                result.add((Trip.Leg)new Trip.PtLeg(feedId, ((Label.Transition)partition.get((int)0)).edge.getTransfers() == 0, tripDescriptor.getTripId(), tripDescriptor.getRouteId(), Optional.ofNullable((com.conveyal.gtfs.model.Trip)this.gtfsStorage.getGtfsFeeds().get((Object)feedId).trips.get((Object)tripDescriptor.getTripId())).map(t -> t.trip_headsign).orElse("extra"), stops, partition.stream().mapToDouble(t -> t.edge.getDistance()).sum(), path.get((int)(i - 1)).label.currentTime - boardTime, (Geometry)this.geometryFactory.createLineString((Coordinate[])stops.stream().map(s -> s.geometry.getCoordinate()).toArray(Coordinate[]::new))));
                partition = null;
                if (edge.getType() != GtfsStorage.EdgeType.TRANSFER) continue;
                feedId = edge.getPlatformDescriptor().feed_id;
                int[] skippedEdgesForTransfer = (int[])this.gtfsStorage.getSkippedEdgesForTransfer().get(edge.getId());
                if (skippedEdgesForTransfer == null) continue;
                List<Trip.Leg> legs = this.parsePartitionToLegs(this.transferPath(skippedEdgesForTransfer, weighting, path.get((int)(i - 1)).label.currentTime), graph, encodedValueLookup, weighting, tr, requestedPathDetails);
                result.add(legs.get(0));
            }
            return result;
        }
        InstructionList instructions = new InstructionList(tr);
        InstructionsFromEdges instructionsFromEdges = new InstructionsFromEdges(graph, weighting, encodedValueLookup, instructions);
        int prevEdgeId = -1;
        for (int i = 1; i < path.size(); ++i) {
            if (path.get((int)i).edge.getType() != GtfsStorage.EdgeType.HIGHWAY) {
                throw new IllegalStateException("Got a transit edge where I think I must be on a road.");
            }
            EdgeIteratorState edge = graph.getEdgeIteratorState(path.get((int)i).edge.getId(), path.get((int)i).label.node.streetNode);
            instructionsFromEdges.next(edge, i, prevEdgeId);
            prevEdgeId = edge.getEdge();
        }
        instructionsFromEdges.finish();
        Path pathh = new Path(graph);
        for (Label.Transition transition : path) {
            if (transition.edge == null) continue;
            pathh.addEdge(transition.edge.getId());
        }
        pathh.setFromNode(path.get((int)0).label.node.streetNode);
        pathh.setEndNode(path.get((int)(path.size() - 1)).label.node.streetNode);
        pathh.setFound(true);
        Map pathDetails = PathDetailsFromEdges.calcDetails((Path)pathh, (EncodedValueLookup)encodedValueLookup, (Weighting)weighting, requestedPathDetails, (PathDetailsBuilderFactory)this.pathDetailsBuilderFactory, (int)0, (Graph)graph);
        Instant departureTime = Instant.ofEpochMilli(path.get((int)0).label.currentTime);
        Instant arrivalTime = Instant.ofEpochMilli(path.get((int)(path.size() - 1)).label.currentTime);
        return Collections.singletonList(new Trip.WalkLeg("Walk", Date.from(departureTime), this.lineStringFromInstructions(instructions), this.edges(path).mapToDouble(edgeLabel -> edgeLabel.getDistance()).sum(), instructions, pathDetails, Date.from(arrivalTime)));
    }

    public List<Label.Transition> transferPath(int[] skippedEdgesForTransfer, Weighting transferWeighting, long currentTime) {
        GraphExplorer graphExplorer = new GraphExplorer(this.graph, this.gtfsStorage.getPtGraph(), transferWeighting, this.gtfsStorage, this.realtimeFeed, false, true, false, this.walkSpeedKmH, false, 0);
        return graphExplorer.walkPath(skippedEdgesForTransfer, currentTime);
    }

    private Stream<GraphExplorer.MultiModalEdge> edges(List<Label.Transition> path) {
        return path.stream().filter(t -> t.edge != null).map(t -> t.edge);
    }

    private Geometry lineStringFromInstructions(InstructionList instructions) {
        PointList pointsList = new PointList();
        for (Instruction instruction : instructions) {
            pointsList.add(instruction.getPoints());
        }
        return pointsList.toLineString(false);
    }

    private class StopsFromBoardHopDwellEdges {
        private final GtfsRealtime.TripDescriptor tripDescriptor;
        private final List<Trip.Stop> stops = new ArrayList<Trip.Stop>();
        private final GTFSFeed gtfsFeed;
        private Instant boardTime;
        private Instant arrivalTimeFromHopEdge;
        private Optional<Instant> updatedArrival;
        private StopTime stopTime = null;
        private GtfsReader.TripWithStopTimes tripUpdate = null;
        private int stopSequence = 0;

        StopsFromBoardHopDwellEdges(String feedId, GtfsRealtime.TripDescriptor tripDescriptor) {
            this.tripDescriptor = tripDescriptor;
            this.gtfsFeed = TripFromLabel.this.gtfsStorage.getGtfsFeeds().get(feedId);
            if (this.tripUpdate != null) {
                this.validateTripUpdate(this.tripUpdate);
            }
        }

        void next(Label.Transition t) {
            switch (t.edge.getType()) {
                case BOARD: {
                    this.boardTime = Instant.ofEpochMilli(t.label.currentTime);
                    this.stopSequence = t.edge.getStopSequence();
                    this.stopTime = TripFromLabel.this.realtimeFeed.getStopTime(this.gtfsFeed, this.tripDescriptor, t, this.boardTime, this.stopSequence);
                    this.tripUpdate = TripFromLabel.this.realtimeFeed.getTripUpdate(this.gtfsFeed, this.tripDescriptor, this.boardTime).orElse(null);
                    Instant plannedDeparture = Instant.ofEpochMilli(t.label.currentTime);
                    Optional<Instant> updatedDeparture = this.getDepartureDelay(this.stopSequence).map(delay -> plannedDeparture.plus((long)delay.intValue(), ChronoUnit.SECONDS));
                    Stop stop = this.gtfsFeed.stops.get(this.stopTime.stop_id);
                    this.stops.add(new Trip.Stop(stop.stop_id, stop.stop_name, TripFromLabel.this.geometryFactory.createPoint(new Coordinate(stop.stop_lon, stop.stop_lat)), null, null, null, this.isArrivalCancelled(this.stopSequence), updatedDeparture.map(Date::from).orElse(Date.from(plannedDeparture)), Date.from(plannedDeparture), (Date)updatedDeparture.map(Date::from).orElse(null), this.isDepartureCancelled(this.stopSequence)));
                    break;
                }
                case HOP: {
                    this.stopSequence = t.edge.getStopSequence();
                    this.stopTime = TripFromLabel.this.realtimeFeed.getStopTime(this.gtfsFeed, this.tripDescriptor, t, this.boardTime, this.stopSequence);
                    this.arrivalTimeFromHopEdge = Instant.ofEpochMilli(t.label.currentTime);
                    this.updatedArrival = this.getArrivalDelay(this.stopSequence).map(delay -> this.arrivalTimeFromHopEdge.plus((long)delay.intValue(), ChronoUnit.SECONDS));
                    break;
                }
                case DWELL: {
                    Instant plannedDeparture = Instant.ofEpochMilli(t.label.currentTime);
                    Optional<Instant> updatedDeparture = this.getDepartureDelay(this.stopTime.stop_sequence).map(delay -> plannedDeparture.plus((long)delay.intValue(), ChronoUnit.SECONDS));
                    Stop stop = this.gtfsFeed.stops.get(this.stopTime.stop_id);
                    this.stops.add(new Trip.Stop(stop.stop_id, stop.stop_name, TripFromLabel.this.geometryFactory.createPoint(new Coordinate(stop.stop_lon, stop.stop_lat)), this.updatedArrival.map(Date::from).orElse(Date.from(this.arrivalTimeFromHopEdge)), Date.from(this.arrivalTimeFromHopEdge), (Date)this.updatedArrival.map(Date::from).orElse(null), this.isArrivalCancelled(this.stopSequence), updatedDeparture.map(Date::from).orElse(Date.from(plannedDeparture)), Date.from(plannedDeparture), (Date)updatedDeparture.map(Date::from).orElse(null), this.isDepartureCancelled(this.stopSequence)));
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }

        private Optional<Integer> getArrivalDelay(int stopSequence) {
            if (this.tripUpdate != null) {
                int arrival_time = this.tripUpdate.stopTimes.stream().filter((Predicate<StopTime>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getArrivalDelay$3(int com.conveyal.gtfs.model.StopTime ), (Lcom/conveyal/gtfs/model/StopTime;)Z)((int)stopSequence)).findFirst().orElseThrow((Supplier<RuntimeException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getArrivalDelay$4(), ()Ljava/lang/RuntimeException;)()).arrival_time;
                logger.trace("stop_sequence {} scheduled arrival {} updated arrival {}", new Object[]{stopSequence, this.stopTime.arrival_time, arrival_time});
                return Optional.of(arrival_time - this.stopTime.arrival_time);
            }
            return Optional.empty();
        }

        private boolean isArrivalCancelled(int stopSequence) {
            if (this.tripUpdate != null) {
                return this.tripUpdate.cancelledArrivals.contains(stopSequence);
            }
            return false;
        }

        private Optional<Integer> getDepartureDelay(int stopSequence) {
            if (this.tripUpdate != null) {
                int departure_time = this.tripUpdate.stopTimes.stream().filter((Predicate<StopTime>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getDepartureDelay$5(int com.conveyal.gtfs.model.StopTime ), (Lcom/conveyal/gtfs/model/StopTime;)Z)((int)stopSequence)).findFirst().orElseThrow((Supplier<RuntimeException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getDepartureDelay$6(), ()Ljava/lang/RuntimeException;)()).departure_time;
                logger.trace("stop_sequence {} scheduled departure {} updated departure {}", new Object[]{stopSequence, this.stopTime.departure_time, departure_time});
                return Optional.of(departure_time - this.stopTime.departure_time);
            }
            return Optional.empty();
        }

        private boolean isDepartureCancelled(int stopSequence) {
            if (this.tripUpdate != null) {
                return this.tripUpdate.cancelledDeparture.contains(stopSequence);
            }
            return false;
        }

        void finish() {
            Stop stop = this.gtfsFeed.stops.get(this.stopTime.stop_id);
            this.stops.add(new Trip.Stop(stop.stop_id, stop.stop_name, TripFromLabel.this.geometryFactory.createPoint(new Coordinate(stop.stop_lon, stop.stop_lat)), this.updatedArrival.map(Date::from).orElse(Date.from(this.arrivalTimeFromHopEdge)), Date.from(this.arrivalTimeFromHopEdge), (Date)this.updatedArrival.map(Date::from).orElse(null), this.isArrivalCancelled(this.stopSequence), null, null, null, this.isDepartureCancelled(this.stopSequence)));
            for (Trip.Stop tripStop : this.stops) {
                logger.trace("{}", (Object)tripStop);
            }
        }

        private void validateTripUpdate(GtfsReader.TripWithStopTimes tripUpdate) {
            try {
                Iterable<StopTime> interpolatedStopTimesForTrip = this.gtfsFeed.getInterpolatedStopTimesForTrip(tripUpdate.trip.trip_id);
                long nStopTimes = StreamSupport.stream(interpolatedStopTimesForTrip.spliterator(), false).count();
                logger.trace("Original stop times: {} Updated stop times: {}", (Object)nStopTimes, (Object)tripUpdate.stopTimes.size());
                if (nStopTimes != (long)tripUpdate.stopTimes.size()) {
                    logger.error("Original stop times: {} Updated stop times: {}", (Object)nStopTimes, (Object)tripUpdate.stopTimes.size());
                }
            }
            catch (GTFSFeed.FirstAndLastStopsDoNotHaveTimes firstAndLastStopsDoNotHaveTimes) {
                throw new RuntimeException(firstAndLastStopsDoNotHaveTimes);
            }
        }

        private static /* synthetic */ RuntimeException lambda$getDepartureDelay$6() {
            return new RuntimeException("Stop time not found.");
        }

        private static /* synthetic */ boolean lambda$getDepartureDelay$5(int stopSequence, StopTime st) {
            return st.stop_sequence == stopSequence;
        }

        private static /* synthetic */ RuntimeException lambda$getArrivalDelay$4() {
            return new RuntimeException("Stop time not found.");
        }

        private static /* synthetic */ boolean lambda$getArrivalDelay$3(int stopSequence, StopTime st) {
            return st.stop_sequence == stopSequence;
        }
    }
}

