/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs.analysis;

import com.carrotsearch.hppc.BitSetIterator;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.gtfs.analysis.PtGraphAsAdjacencyList;
import com.graphhopper.routing.subnetwork.TarjanSCC;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Graph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;

public class Analysis {
    public static List<List<GtfsStorage.FeedIdWithStopId>> findStronglyConnectedComponentsOfStopGraph(PtGraph ptGraph) {
        PtGraphAsAdjacencyList ptGraphAsAdjacencyList = new PtGraphAsAdjacencyList(ptGraph);
        TarjanSCC.ConnectedComponents components = TarjanSCC.findComponents((Graph)ptGraphAsAdjacencyList, (EdgeFilter)EdgeFilter.ALL_EDGES, (boolean)false);
        ArrayList<List<GtfsStorage.FeedIdWithStopId>> stronglyConnectedComponentsOfStopGraph = new ArrayList<List<GtfsStorage.FeedIdWithStopId>>();
        for (IntArrayList component : components.getComponents()) {
            ArrayList<GtfsStorage.FeedIdWithStopId> stopsOfComponent = new ArrayList<GtfsStorage.FeedIdWithStopId>();
            for (IntCursor intCursor : component) {
                stopsOfComponent.addAll(Analysis.getStopsForNode(ptGraph, intCursor.value));
            }
            if (stopsOfComponent.isEmpty()) continue;
            stronglyConnectedComponentsOfStopGraph.add(stopsOfComponent);
        }
        BitSetIterator iter = components.getSingleNodeComponents().iterator();
        int i = iter.nextSetBit();
        while (i >= 0) {
            List<GtfsStorage.FeedIdWithStopId> stopsForNode = Analysis.getStopsForNode(ptGraph, i);
            if (!stopsForNode.isEmpty()) {
                stronglyConnectedComponentsOfStopGraph.add(stopsForNode);
            }
            i = iter.nextSetBit();
        }
        return stronglyConnectedComponentsOfStopGraph;
    }

    public static List<GtfsStorage.FeedIdWithStopId> getStopsForNode(PtGraph ptGraph, int i) {
        EnumSet<GtfsStorage.EdgeType> inEdgeTypes = EnumSet.noneOf(GtfsStorage.EdgeType.class);
        for (PtGraph.PtEdge ptEdge : ptGraph.backEdgesAround(i)) {
            inEdgeTypes.add(ptEdge.getType());
        }
        EnumSet<GtfsStorage.EdgeType> outEdgeTypes = EnumSet.noneOf(GtfsStorage.EdgeType.class);
        for (PtGraph.PtEdge ptEdge : ptGraph.edgesAround(i)) {
            outEdgeTypes.add(ptEdge.getType());
        }
        if (inEdgeTypes.equals(EnumSet.of(GtfsStorage.EdgeType.EXIT_PT)) && outEdgeTypes.equals(EnumSet.of(GtfsStorage.EdgeType.ENTER_PT))) {
            HashSet hashSet = new HashSet();
            ptGraph.backEdgesAround(i).forEach(e -> stops.add(new GtfsStorage.FeedIdWithStopId(e.getAttrs().platformDescriptor.feed_id, e.getAttrs().platformDescriptor.stop_id)));
            ptGraph.edgesAround(i).forEach(e -> stops.add(new GtfsStorage.FeedIdWithStopId(e.getAttrs().platformDescriptor.feed_id, e.getAttrs().platformDescriptor.stop_id)));
            return new ArrayList<GtfsStorage.FeedIdWithStopId>(hashSet);
        }
        return Collections.emptyList();
    }
}

