/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs.fare;

import com.graphhopper.gtfs.fare.FareAssignment;
import com.graphhopper.gtfs.fare.Ticket;
import com.graphhopper.gtfs.fare.TicketPurchaseScoreCalculator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class TicketPurchase {
    public final List<FareAssignment> fareAssignments;

    TicketPurchase(List<FareAssignment> fareAssignments) {
        this.fareAssignments = fareAssignments;
    }

    List<Ticket> getTickets() {
        HashMap<String, TicketPurchaseScoreCalculator.TempTicket> currentTickets = new HashMap<String, TicketPurchaseScoreCalculator.TempTicket>();
        for (FareAssignment fareAssignment : this.fareAssignments) {
            if (fareAssignment.fare == null) continue;
            currentTickets.computeIfAbsent(this.fareKey(fareAssignment), fareId -> new TicketPurchaseScoreCalculator.TempTicket());
            currentTickets.compute(this.fareKey(fareAssignment), (s, tempTicket) -> {
                if (fareAssignment.segment.getStartTime() > tempTicket.validUntil || tempTicket.nMoreTransfers == 0) {
                    tempTicket.feed_id = fareAssignment.segment.feed_id;
                    tempTicket.fare = fareAssignment.fare;
                    tempTicket.validUntil = fareAssignment.segment.getStartTime() + (long)fareAssignment.fare.fare_attribute.transfer_duration;
                    tempTicket.nMoreTransfers = fareAssignment.fare.fare_attribute.transfers;
                    ++tempTicket.totalNumber;
                    return tempTicket;
                }
                --tempTicket.nMoreTransfers;
                return tempTicket;
            });
        }
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        for (TicketPurchaseScoreCalculator.TempTicket t : currentTickets.values()) {
            for (int i = 0; i < t.totalNumber; ++i) {
                tickets.add(new Ticket(t.feed_id, t.fare));
            }
        }
        return tickets;
    }

    private String fareKey(FareAssignment fareAssignment) {
        return fareAssignment.fare.fare_id + "_" + fareAssignment.fare.fare_attribute.feed_id;
    }

    int getNSchwarzfahrTrips() {
        return (int)this.fareAssignments.stream().filter(assignment -> assignment.fare == null).count();
    }
}

