/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.IntLongMap;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongIndexedContainer;
import com.carrotsearch.hppc.LongLongMap;
import com.carrotsearch.hppc.LongSet;
import com.graphhopper.coll.GHIntLongHashMap;
import com.graphhopper.coll.GHLongHashSet;
import com.graphhopper.coll.GHLongIntBTree;
import com.graphhopper.coll.GHLongLongHashMap;
import com.graphhopper.coll.LongIntMap;
import com.graphhopper.reader.DataReader;
import com.graphhopper.reader.PillarInfo;
import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GraphElevationSmoothing;
import com.graphhopper.reader.osm.OSMFileHeader;
import com.graphhopper.reader.osm.OSMInput;
import com.graphhopper.reader.osm.OSMInputFile;
import com.graphhopper.reader.osm.OSMReaderUtility;
import com.graphhopper.reader.osm.OSMTurnRelation;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TurnCostEncoder;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.GraphStorage;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostExtension;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalc3D;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMReader
implements DataReader {
    protected static final int EMPTY_NODE = -1;
    protected static final int PILLAR_NODE = 1;
    protected static final int TOWER_NODE = -2;
    private static final Logger LOGGER = LoggerFactory.getLogger(OSMReader.class);
    private final GraphStorage ghStorage;
    private final Graph graph;
    private final NodeAccess nodeAccess;
    private final LongIndexedContainer barrierNodeIds = new LongArrayList();
    private final DistanceCalc distCalc = Helper.DIST_EARTH;
    private final DistanceCalc3D distCalc3D = Helper.DIST_3D;
    private final DouglasPeucker simplifyAlgo = new DouglasPeucker();
    private boolean smoothElevation = false;
    private final boolean exitOnlyPillarNodeException = true;
    private final Map<FlagEncoder, EdgeExplorer> outExplorerMap = new HashMap<FlagEncoder, EdgeExplorer>();
    private final Map<FlagEncoder, EdgeExplorer> inExplorerMap = new HashMap<FlagEncoder, EdgeExplorer>();
    protected long zeroCounter = 0L;
    protected PillarInfo pillarInfo;
    private long locations;
    private long skippedLocations;
    private final EncodingManager encodingManager;
    private int workerThreads = 2;
    private LongIntMap osmNodeIdToInternalNodeMap;
    private GHLongLongHashMap osmNodeIdToNodeFlagsMap;
    private GHLongLongHashMap osmWayIdToRouteWeightMap;
    private GHLongHashSet osmWayIdSet = new GHLongHashSet();
    private IntLongMap edgeIdToOsmWayIdMap;
    private boolean doSimplify = true;
    private int nextTowerId = 0;
    private int nextPillarId = 0;
    private long newUniqueOsmId = -9223372036854775807L;
    private ElevationProvider eleProvider = ElevationProvider.NOOP;
    private File osmFile;
    private Date osmDataDate;
    private boolean createStorage = true;

    public OSMReader(GraphHopperStorage ghStorage) {
        this.ghStorage = ghStorage;
        this.graph = ghStorage;
        this.nodeAccess = this.graph.getNodeAccess();
        this.encodingManager = ghStorage.getEncodingManager();
        this.osmNodeIdToInternalNodeMap = new GHLongIntBTree(200);
        this.osmNodeIdToNodeFlagsMap = new GHLongLongHashMap(200, 0.5);
        this.osmWayIdToRouteWeightMap = new GHLongLongHashMap(200, 0.5);
        this.pillarInfo = new PillarInfo(this.nodeAccess.is3D(), ghStorage.getDirectory());
    }

    public void readGraph() throws IOException {
        if (this.encodingManager == null) {
            throw new IllegalStateException("Encoding manager was not set.");
        }
        if (this.osmFile == null) {
            throw new IllegalStateException("No OSM file specified");
        }
        if (!this.osmFile.exists()) {
            throw new IllegalStateException("Your specified OSM file does not exist:" + this.osmFile.getAbsolutePath());
        }
        StopWatch sw1 = new StopWatch().start();
        this.preProcess(this.osmFile);
        sw1.stop();
        StopWatch sw2 = new StopWatch().start();
        this.writeOsm2Graph(this.osmFile);
        sw2.stop();
        LOGGER.info("time pass1:" + (int)sw1.getSeconds() + "s, pass2:" + (int)sw2.getSeconds() + "s, total:" + (int)(sw1.getSeconds() + sw2.getSeconds()) + "s");
    }

    void preProcess(File osmFile) {
        try (OSMInput in = this.openOsmInputFile(osmFile);){
            ReaderElement item;
            long tmpWayCounter = 1L;
            long tmpRelationCounter = 1L;
            while ((item = in.getNext()) != null) {
                if (item.isType(1)) {
                    ReaderWay way = (ReaderWay)item;
                    boolean valid = this.filterWay(way);
                    if (!valid) continue;
                    LongArrayList wayNodes = way.getNodes();
                    int s = wayNodes.size();
                    for (int index = 0; index < s; ++index) {
                        this.prepareHighwayNode(wayNodes.get(index));
                    }
                    if (++tmpWayCounter % 10000000L != 0L) continue;
                    LOGGER.info(Helper.nf((long)tmpWayCounter) + " (preprocess), osmIdMap:" + Helper.nf((long)this.getNodeMap().getSize()) + " (" + this.getNodeMap().getMemoryUsage() + "MB) " + Helper.getMemInfo());
                    continue;
                }
                if (item.isType(2)) {
                    ReaderRelation relation = (ReaderRelation)item;
                    if (!relation.isMetaRelation() && relation.hasTag("type", (Object)"route")) {
                        this.prepareWaysWithRelationInfo(relation);
                    }
                    if (relation.hasTag("type", (Object)"restriction")) {
                        this.prepareRestrictionRelation(relation);
                    }
                    if (++tmpRelationCounter % 100000L != 0L) continue;
                    LOGGER.info(Helper.nf((long)tmpRelationCounter) + " (preprocess), osmWayMap:" + Helper.nf((long)this.getRelFlagsMap().size()) + " " + Helper.getMemInfo());
                    continue;
                }
                if (!item.isType(3)) continue;
                OSMFileHeader fileHeader = (OSMFileHeader)item;
                this.osmDataDate = Helper.createFormatter().parse(fileHeader.getTag("timestamp"));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem while parsing file", ex);
        }
    }

    private void prepareRestrictionRelation(ReaderRelation relation) {
        OSMTurnRelation turnRelation = this.createTurnRelation(relation);
        if (turnRelation != null) {
            this.getOsmWayIdSet().add(turnRelation.getOsmIdFrom());
            this.getOsmWayIdSet().add(turnRelation.getOsmIdTo());
        }
    }

    private LongSet getOsmWayIdSet() {
        return this.osmWayIdSet;
    }

    private IntLongMap getEdgeIdToOsmWayIdMap() {
        if (this.edgeIdToOsmWayIdMap == null) {
            this.edgeIdToOsmWayIdMap = new GHIntLongHashMap(this.getOsmWayIdSet().size(), 0.5);
        }
        return this.edgeIdToOsmWayIdMap;
    }

    boolean filterWay(ReaderWay item) {
        if (item.getNodes().size() < 2) {
            return false;
        }
        if (!item.hasTags()) {
            return false;
        }
        return this.encodingManager.acceptWay(item, new EncodingManager.AcceptWay());
    }

    private void writeOsm2Graph(File osmFile) {
        int tmp = (int)Math.max(this.getNodeMap().getSize() / 50L, 100L);
        LOGGER.info("creating graph. Found nodes (pillar+tower):" + Helper.nf((long)this.getNodeMap().getSize()) + ", " + Helper.getMemInfo());
        if (this.createStorage) {
            this.ghStorage.create((long)tmp);
        }
        long wayStart = -1L;
        long relationStart = -1L;
        long counter = 1L;
        try (OSMInput in = this.openOsmInputFile(osmFile);){
            ReaderElement item;
            LongIntMap nodeFilter = this.getNodeMap();
            while ((item = in.getNext()) != null) {
                switch (item.getType()) {
                    case 0: {
                        if (nodeFilter.get(item.getId()) == -1) break;
                        this.processNode((ReaderNode)item);
                        break;
                    }
                    case 1: {
                        if (wayStart < 0L) {
                            LOGGER.info(Helper.nf((long)counter) + ", now parsing ways");
                            wayStart = counter;
                        }
                        this.processWay((ReaderWay)item);
                        break;
                    }
                    case 2: {
                        if (relationStart < 0L) {
                            LOGGER.info(Helper.nf((long)counter) + ", now parsing relations");
                            relationStart = counter;
                        }
                        this.processRelation((ReaderRelation)item);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown type " + item.getType());
                    }
                }
                if (++counter % 200000000L != 0L) continue;
                LOGGER.info(Helper.nf((long)counter) + ", locs:" + Helper.nf((long)this.locations) + " (" + this.skippedLocations + ") " + Helper.getMemInfo());
            }
            if (in.getUnprocessedElements() > 0) {
                throw new IllegalStateException("Still unprocessed elements in reader queue " + in.getUnprocessedElements());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't process file " + osmFile + ", error: " + ex.getMessage(), ex);
        }
        this.finishedReading();
        if (this.graph.getNodes() == 0) {
            throw new RuntimeException("Graph after reading OSM must not be empty. Read " + counter + " items and " + this.locations + " locations");
        }
    }

    protected OSMInput openOsmInputFile(File osmFile) throws XMLStreamException, IOException {
        return new OSMInputFile(osmFile).setWorkerThreads(this.workerThreads).open();
    }

    void processWay(ReaderWay way) {
        IntsRef edgeFlags;
        if (way.getNodes().size() < 2) {
            return;
        }
        if (!way.hasTags()) {
            return;
        }
        long wayOsmId = way.getId();
        EncodingManager.AcceptWay acceptWay = new EncodingManager.AcceptWay();
        if (!this.encodingManager.acceptWay(way, acceptWay)) {
            return;
        }
        long relationFlags = this.getRelFlagsMap().get(way.getId());
        LongArrayList osmNodeIds = way.getNodes();
        int first = this.getNodeMap().get(osmNodeIds.get(0));
        int last = this.getNodeMap().get(osmNodeIds.get(osmNodeIds.size() - 1));
        double firstLat = this.getTmpLatitude(first);
        double firstLon = this.getTmpLongitude(first);
        double lastLat = this.getTmpLatitude(last);
        double lastLon = this.getTmpLongitude(last);
        if (!(Double.isNaN(firstLat) || Double.isNaN(firstLon) || Double.isNaN(lastLat) || Double.isNaN(lastLon))) {
            double estimatedDist = this.distCalc.calcDist(firstLat, firstLon, lastLat, lastLon);
            way.setTag("estimated_distance", (Object)estimatedDist);
            way.setTag("estimated_center", (Object)new GHPoint((firstLat + lastLat) / 2.0, (firstLon + lastLon) / 2.0));
        }
        if (way.getTag("duration") != null) {
            try {
                long dur = OSMReaderUtility.parseDuration(way.getTag("duration"));
                way.setTag("duration:seconds", (Object)Long.toString(dur));
            }
            catch (Exception ex) {
                LOGGER.warn("Parsing error in way with OSMID=" + way.getId() + " : " + ex.getMessage());
            }
        }
        if ((edgeFlags = this.encodingManager.handleWayTags(way, acceptWay, relationFlags)).isEmpty()) {
            return;
        }
        ArrayList<EdgeIteratorState> createdEdges = new ArrayList<EdgeIteratorState>();
        int size = osmNodeIds.size();
        int lastBarrier = -1;
        for (int i = 0; i < size; ++i) {
            long nodeId = osmNodeIds.get(i);
            long nodeFlags = this.getNodeFlagsMap().get(nodeId);
            if (nodeFlags <= 0L || !OSMReader.isOnePassable(this.encodingManager.getAccessEncFromNodeFlags(nodeFlags), edgeFlags)) continue;
            this.getNodeFlagsMap().put(nodeId, 0L);
            long newNodeId = this.addBarrierNode(nodeId);
            if (i > 0) {
                if (lastBarrier < 0) {
                    lastBarrier = 0;
                }
                int length = i - lastBarrier + 1;
                LongArrayList partNodeIds = new LongArrayList();
                partNodeIds.add(osmNodeIds.buffer, lastBarrier, length);
                partNodeIds.set(length - 1, newNodeId);
                createdEdges.addAll(this.addOSMWay((LongIndexedContainer)partNodeIds, edgeFlags, wayOsmId));
                createdEdges.addAll(this.addBarrierEdge(newNodeId, nodeId, edgeFlags, nodeFlags, wayOsmId));
            } else {
                createdEdges.addAll(this.addBarrierEdge(nodeId, newNodeId, edgeFlags, nodeFlags, wayOsmId));
                osmNodeIds.set(0, newNodeId);
            }
            lastBarrier = i;
        }
        if (lastBarrier >= 0) {
            if (lastBarrier < size - 1) {
                LongArrayList partNodeIds = new LongArrayList();
                partNodeIds.add(osmNodeIds.buffer, lastBarrier, size - lastBarrier);
                createdEdges.addAll(this.addOSMWay((LongIndexedContainer)partNodeIds, edgeFlags, wayOsmId));
            }
        } else {
            createdEdges.addAll(this.addOSMWay((LongIndexedContainer)way.getNodes(), edgeFlags, wayOsmId));
        }
        for (EdgeIteratorState edge : createdEdges) {
            this.encodingManager.applyWayTags(way, edge);
        }
    }

    public void processRelation(ReaderRelation relation) {
        GraphExtension extendedStorage;
        OSMTurnRelation turnRelation;
        if (relation.hasTag("type", (Object)"restriction") && (turnRelation = this.createTurnRelation(relation)) != null && (extendedStorage = this.graph.getExtension()) instanceof TurnCostExtension) {
            TurnCostExtension tcs = (TurnCostExtension)extendedStorage;
            Collection<OSMTurnRelation.TurnCostTableEntry> entries = this.analyzeTurnRelation(turnRelation);
            for (OSMTurnRelation.TurnCostTableEntry entry : entries) {
                tcs.addTurnInfo(entry.edgeFrom, entry.nodeVia, entry.edgeTo, entry.flags);
            }
        }
    }

    public Collection<OSMTurnRelation.TurnCostTableEntry> analyzeTurnRelation(OSMTurnRelation turnRelation) {
        LinkedHashMap<Long, OSMTurnRelation.TurnCostTableEntry> entries = new LinkedHashMap<Long, OSMTurnRelation.TurnCostTableEntry>();
        for (FlagEncoder encoder : this.encodingManager.fetchEdgeEncoders()) {
            for (OSMTurnRelation.TurnCostTableEntry entry : this.analyzeTurnRelation(encoder, turnRelation)) {
                OSMTurnRelation.TurnCostTableEntry oldEntry = (OSMTurnRelation.TurnCostTableEntry)entries.get(entry.getItemId());
                if (oldEntry != null) {
                    oldEntry.flags |= entry.flags;
                    continue;
                }
                entries.put(entry.getItemId(), entry);
            }
        }
        return entries.values();
    }

    public Collection<OSMTurnRelation.TurnCostTableEntry> analyzeTurnRelation(FlagEncoder encoder, OSMTurnRelation turnRelation) {
        if (!encoder.supports(TurnWeighting.class)) {
            return Collections.emptyList();
        }
        EdgeExplorer edgeOutExplorer = this.outExplorerMap.get(encoder);
        EdgeExplorer edgeInExplorer = this.inExplorerMap.get(encoder);
        if (edgeOutExplorer == null || edgeInExplorer == null) {
            edgeOutExplorer = this.graph.createEdgeExplorer((EdgeFilter)DefaultEdgeFilter.outEdges((FlagEncoder)encoder));
            this.outExplorerMap.put(encoder, edgeOutExplorer);
            edgeInExplorer = this.graph.createEdgeExplorer((EdgeFilter)DefaultEdgeFilter.inEdges((FlagEncoder)encoder));
            this.inExplorerMap.put(encoder, edgeInExplorer);
        }
        return turnRelation.getRestrictionAsEntries((TurnCostEncoder)encoder, edgeOutExplorer, edgeInExplorer, this);
    }

    public long getOsmIdOfInternalEdge(int edgeId) {
        return this.getEdgeIdToOsmWayIdMap().get(edgeId);
    }

    public int getInternalNodeIdOfOsmNode(long nodeOsmId) {
        int id = this.getNodeMap().get(nodeOsmId);
        if (id < -2) {
            return -id - 3;
        }
        return -1;
    }

    double getTmpLatitude(int id) {
        if (id == -1) {
            return Double.NaN;
        }
        if (id < -2) {
            id = -id - 3;
            return this.nodeAccess.getLatitude(id);
        }
        if (id > 2) {
            return this.pillarInfo.getLatitude(id -= 3);
        }
        return Double.NaN;
    }

    double getTmpLongitude(int id) {
        if (id == -1) {
            return Double.NaN;
        }
        if (id < -2) {
            id = -id - 3;
            return this.nodeAccess.getLongitude(id);
        }
        if (id > 2) {
            return this.pillarInfo.getLon(id -= 3);
        }
        return Double.NaN;
    }

    private void processNode(ReaderNode node) {
        if (this.isInBounds(node)) {
            long nodeFlags;
            this.addNode(node);
            if (node.hasTags() && (nodeFlags = this.encodingManager.handleNodeTags(node)) != 0L) {
                this.getNodeFlagsMap().put(node.getId(), nodeFlags);
            }
            ++this.locations;
        } else {
            ++this.skippedLocations;
        }
    }

    boolean addNode(ReaderNode node) {
        int nodeType = this.getNodeMap().get(node.getId());
        if (nodeType == -1) {
            return false;
        }
        double lat = node.getLat();
        double lon = node.getLon();
        double ele = this.getElevation(node);
        if (nodeType == -2) {
            this.addTowerNode(node.getId(), lat, lon, ele);
        } else if (nodeType == 1) {
            this.pillarInfo.setNode(this.nextPillarId, lat, lon, ele);
            this.getNodeMap().put(node.getId(), this.nextPillarId + 3);
            ++this.nextPillarId;
        }
        return true;
    }

    private static boolean isOnePassable(List<BooleanEncodedValue> checkEncoders, IntsRef edgeFlags) {
        for (BooleanEncodedValue accessEnc : checkEncoders) {
            if (!accessEnc.getBool(false, edgeFlags) && !accessEnc.getBool(true, edgeFlags)) continue;
            return true;
        }
        return false;
    }

    protected double getElevation(ReaderNode node) {
        return this.eleProvider.getEle(node.getLat(), node.getLon());
    }

    void prepareWaysWithRelationInfo(ReaderRelation osmRelation) {
        if (this.encodingManager.handleRelationTags(0L, osmRelation) == 0L) {
            return;
        }
        for (ReaderRelation.Member member : osmRelation.getMembers()) {
            long newRelationFlags;
            if (member.getType() != 1) continue;
            long osmId = member.getRef();
            long oldRelationFlags = this.getRelFlagsMap().get(osmId);
            if (oldRelationFlags == (newRelationFlags = this.encodingManager.handleRelationTags(oldRelationFlags, osmRelation))) continue;
            this.getRelFlagsMap().put(osmId, newRelationFlags);
        }
    }

    void prepareHighwayNode(long osmId) {
        int tmpGHNodeId = this.getNodeMap().get(osmId);
        if (tmpGHNodeId == -1) {
            this.getNodeMap().put(osmId, 1);
        } else if (tmpGHNodeId > -1) {
            this.getNodeMap().put(osmId, -2);
        }
    }

    int addTowerNode(long osmId, double lat, double lon, double ele) {
        if (this.nodeAccess.is3D()) {
            this.nodeAccess.setNode(this.nextTowerId, lat, lon, ele);
        } else {
            this.nodeAccess.setNode(this.nextTowerId, lat, lon);
        }
        int id = -(this.nextTowerId + 3);
        this.getNodeMap().put(osmId, id);
        ++this.nextTowerId;
        return id;
    }

    Collection<EdgeIteratorState> addOSMWay(LongIndexedContainer osmNodeIds, IntsRef flags, long wayOsmId) {
        PointList pointList = new PointList(osmNodeIds.size(), this.nodeAccess.is3D());
        ArrayList<EdgeIteratorState> newEdges = new ArrayList<EdgeIteratorState>(5);
        int firstNode = -1;
        int lastIndex = osmNodeIds.size() - 1;
        int lastInBoundsPillarNode = -1;
        try {
            for (int i = 0; i < osmNodeIds.size(); ++i) {
                long osmNodeId = osmNodeIds.get(i);
                int tmpNode = this.getNodeMap().get(osmNodeId);
                if (tmpNode == -1 || tmpNode == -2) continue;
                if (tmpNode == 1) {
                    if (pointList.isEmpty() || lastInBoundsPillarNode <= 2) continue;
                    tmpNode = lastInBoundsPillarNode;
                    tmpNode = this.handlePillarNode(tmpNode, osmNodeId, null, true);
                    tmpNode = -tmpNode - 3;
                    if (pointList.getSize() > 1 && firstNode >= 0) {
                        newEdges.add(this.addEdge(firstNode, tmpNode, pointList, flags, wayOsmId));
                        pointList.clear();
                        pointList.add((PointAccess)this.nodeAccess, tmpNode);
                    }
                    firstNode = tmpNode;
                    lastInBoundsPillarNode = -1;
                    continue;
                }
                if (tmpNode <= 2 && tmpNode >= -2) {
                    throw new AssertionError((Object)("Mapped index not in correct bounds " + tmpNode + ", " + osmNodeId));
                }
                if (tmpNode > 2) {
                    boolean convertToTowerNode;
                    boolean bl = convertToTowerNode = i == 0 || i == lastIndex;
                    if (!convertToTowerNode) {
                        lastInBoundsPillarNode = tmpNode;
                    }
                    tmpNode = this.handlePillarNode(tmpNode, osmNodeId, pointList, convertToTowerNode);
                }
                if (tmpNode >= -2) continue;
                tmpNode = -tmpNode - 3;
                if (firstNode >= 0 && firstNode == tmpNode) {
                    long lastOsmNodeId = osmNodeIds.get(i - 1);
                    int lastGHNodeId = this.getNodeMap().get(lastOsmNodeId);
                    if (lastGHNodeId < -2) {
                        LOGGER.warn("Pillar node " + lastOsmNodeId + " is already a tower node and used in loop, see #1533. Fix mapping for way " + wayOsmId + ", nodes:" + osmNodeIds);
                        break;
                    }
                    int newEndNode = -this.handlePillarNode(lastGHNodeId, lastOsmNodeId, pointList, true) - 3;
                    newEdges.add(this.addEdge(firstNode, newEndNode, pointList, flags, wayOsmId));
                    pointList.clear();
                    pointList.add((PointAccess)this.nodeAccess, newEndNode);
                    firstNode = newEndNode;
                }
                pointList.add((PointAccess)this.nodeAccess, tmpNode);
                if (firstNode >= 0) {
                    newEdges.add(this.addEdge(firstNode, tmpNode, pointList, flags, wayOsmId));
                    pointList.clear();
                    pointList.add((PointAccess)this.nodeAccess, tmpNode);
                }
                firstNode = tmpNode;
            }
        }
        catch (RuntimeException ex) {
            LOGGER.error("Couldn't properly add edge with osm ids:" + osmNodeIds, (Throwable)ex);
            throw ex;
        }
        return newEdges;
    }

    EdgeIteratorState addEdge(int fromIndex, int toIndex, PointList pointList, IntsRef flags, long wayOsmId) {
        if (fromIndex < 0 || toIndex < 0) {
            throw new AssertionError((Object)("to or from index is invalid for this edge " + fromIndex + "->" + toIndex + ", points:" + pointList));
        }
        if (pointList.getDimension() != this.nodeAccess.getDimension()) {
            throw new AssertionError((Object)("Dimension does not match for pointList vs. nodeAccess " + pointList.getDimension() + " <-> " + this.nodeAccess.getDimension()));
        }
        if (this.smoothElevation) {
            pointList = GraphElevationSmoothing.smoothElevation((PointList)pointList);
        }
        double towerNodeDistance = 0.0;
        double prevLat = pointList.getLatitude(0);
        double prevLon = pointList.getLongitude(0);
        double prevEle = pointList.is3D() ? pointList.getElevation(0) : Double.NaN;
        double ele = Double.NaN;
        PointList pillarNodes = new PointList(pointList.getSize() - 2, this.nodeAccess.is3D());
        int nodes = pointList.getSize();
        for (int i = 1; i < nodes; ++i) {
            double lat = pointList.getLatitude(i);
            double lon = pointList.getLongitude(i);
            if (pointList.is3D()) {
                ele = pointList.getElevation(i);
                if (!this.distCalc.isCrossBoundary(lon, prevLon)) {
                    towerNodeDistance += this.distCalc3D.calcDist(prevLat, prevLon, prevEle, lat, lon, ele);
                }
                prevEle = ele;
            } else if (!this.distCalc.isCrossBoundary(lon, prevLon)) {
                towerNodeDistance += this.distCalc.calcDist(prevLat, prevLon, lat, lon);
            }
            prevLat = lat;
            prevLon = lon;
            if (nodes <= 2 || i >= nodes - 1) continue;
            if (pillarNodes.is3D()) {
                pillarNodes.add(lat, lon, ele);
                continue;
            }
            pillarNodes.add(lat, lon);
        }
        if (towerNodeDistance < 1.0E-4) {
            ++this.zeroCounter;
            towerNodeDistance = 1.0E-4;
        }
        double maxDistance = 2147483.646;
        if (Double.isNaN(towerNodeDistance)) {
            LOGGER.warn("Bug in OSM or GraphHopper. Illegal tower node distance " + towerNodeDistance + " reset to 1m, osm way " + wayOsmId);
            towerNodeDistance = 1.0;
        }
        if (Double.isInfinite(towerNodeDistance) || towerNodeDistance > maxDistance) {
            LOGGER.warn("Bug in OSM or GraphHopper. Too big tower node distance " + towerNodeDistance + " reset to large value, osm way " + wayOsmId);
            towerNodeDistance = maxDistance;
        }
        EdgeIteratorState iter = this.graph.edge(fromIndex, toIndex).setDistance(towerNodeDistance).setFlags(flags);
        if (nodes > 2) {
            if (this.doSimplify) {
                this.simplifyAlgo.simplify(pillarNodes);
            }
            iter.setWayGeometry(pillarNodes);
        }
        this.storeOsmWayID(iter.getEdge(), wayOsmId);
        return iter;
    }

    protected void storeOsmWayID(int edgeId, long osmWayId) {
        if (this.getOsmWayIdSet().contains(osmWayId)) {
            this.getEdgeIdToOsmWayIdMap().put(edgeId, osmWayId);
        }
    }

    private int handlePillarNode(int tmpNode, long osmId, PointList pointList, boolean convertToTowerNode) {
        double lat = this.pillarInfo.getLatitude(tmpNode -= 3);
        double lon = this.pillarInfo.getLongitude(tmpNode);
        double ele = this.pillarInfo.getElevation(tmpNode);
        if (lat == Double.MAX_VALUE || lon == Double.MAX_VALUE) {
            throw new RuntimeException("Conversion pillarNode to towerNode already happended!? osmId:" + osmId + " pillarIndex:" + tmpNode);
        }
        if (convertToTowerNode) {
            this.pillarInfo.setNode(tmpNode, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            tmpNode = this.addTowerNode(osmId, lat, lon, ele);
        } else if (pointList.is3D()) {
            pointList.add(lat, lon, ele);
        } else {
            pointList.add(lat, lon);
        }
        return tmpNode;
    }

    protected void finishedReading() {
        this.printInfo("way");
        this.pillarInfo.clear();
        this.eleProvider.release();
        this.osmNodeIdToInternalNodeMap = null;
        this.osmNodeIdToNodeFlagsMap = null;
        this.osmWayIdToRouteWeightMap = null;
        this.osmWayIdSet = null;
        this.edgeIdToOsmWayIdMap = null;
    }

    long addBarrierNode(long nodeId) {
        ReaderNode newNode;
        int graphIndex = this.getNodeMap().get(nodeId);
        if (graphIndex < -2) {
            graphIndex = -graphIndex - 3;
            newNode = new ReaderNode(this.createNewNodeId(), (PointAccess)this.nodeAccess, graphIndex);
        } else {
            newNode = new ReaderNode(this.createNewNodeId(), (PointAccess)this.pillarInfo, graphIndex -= 3);
        }
        long id = newNode.getId();
        this.prepareHighwayNode(id);
        this.addNode(newNode);
        return id;
    }

    private long createNewNodeId() {
        return this.newUniqueOsmId++;
    }

    Collection<EdgeIteratorState> addBarrierEdge(long fromId, long toId, IntsRef inEdgeFlags, long nodeFlags, long wayOsmId) {
        IntsRef edgeFlags = IntsRef.deepCopyOf((IntsRef)inEdgeFlags);
        for (BooleanEncodedValue accessEnc : this.encodingManager.getAccessEncFromNodeFlags(nodeFlags)) {
            accessEnc.setBool(false, edgeFlags, false);
            accessEnc.setBool(true, edgeFlags, false);
        }
        this.barrierNodeIds.clear();
        this.barrierNodeIds.add(fromId);
        this.barrierNodeIds.add(toId);
        return this.addOSMWay(this.barrierNodeIds, edgeFlags, wayOsmId);
    }

    OSMTurnRelation createTurnRelation(ReaderRelation relation) {
        OSMTurnRelation.Type type = OSMTurnRelation.Type.getRestrictionType(relation.getTag("restriction"));
        if (type != OSMTurnRelation.Type.UNSUPPORTED) {
            long fromWayID = -1L;
            long viaNodeID = -1L;
            long toWayID = -1L;
            for (ReaderRelation.Member member : relation.getMembers()) {
                if (1 == member.getType()) {
                    if ("from".equals(member.getRole())) {
                        fromWayID = member.getRef();
                        continue;
                    }
                    if (!"to".equals(member.getRole())) continue;
                    toWayID = member.getRef();
                    continue;
                }
                if (0 != member.getType() || !"via".equals(member.getRole())) continue;
                viaNodeID = member.getRef();
            }
            if (fromWayID >= 0L && toWayID >= 0L && viaNodeID >= 0L) {
                return new OSMTurnRelation(fromWayID, viaNodeID, toWayID, type);
            }
        }
        return null;
    }

    boolean isInBounds(ReaderNode node) {
        return true;
    }

    protected LongIntMap getNodeMap() {
        return this.osmNodeIdToInternalNodeMap;
    }

    protected LongLongMap getNodeFlagsMap() {
        return this.osmNodeIdToNodeFlagsMap;
    }

    GHLongLongHashMap getRelFlagsMap() {
        return this.osmWayIdToRouteWeightMap;
    }

    public OSMReader setWayPointMaxDistance(double maxDist) {
        this.doSimplify = maxDist > 0.0;
        this.simplifyAlgo.setMaxDistance(maxDist);
        return this;
    }

    public DataReader setSmoothElevation(boolean smoothElevation) {
        this.smoothElevation = smoothElevation;
        return this;
    }

    public OSMReader setWorkerThreads(int numOfWorkers) {
        this.workerThreads = numOfWorkers;
        return this;
    }

    public OSMReader setElevationProvider(ElevationProvider eleProvider) {
        if (eleProvider == null) {
            throw new IllegalStateException("Use the NOOP elevation provider instead of null or don't call setElevationProvider");
        }
        if (!this.nodeAccess.is3D() && ElevationProvider.NOOP != eleProvider) {
            throw new IllegalStateException("Make sure you graph accepts 3D data");
        }
        this.eleProvider = eleProvider;
        return this;
    }

    public DataReader setFile(File osmFile) {
        this.osmFile = osmFile;
        return this;
    }

    private void printInfo(String str) {
        LOGGER.info("finished " + str + " processing. nodes: " + this.graph.getNodes() + ", osmIdMap.size:" + this.getNodeMap().getSize() + ", osmIdMap:" + this.getNodeMap().getMemoryUsage() + "MB, nodeFlagsMap.size:" + this.getNodeFlagsMap().size() + ", relFlagsMap.size:" + this.getRelFlagsMap().size() + ", zeroCounter:" + this.zeroCounter + " " + Helper.getMemInfo());
    }

    public Date getDataDate() {
        return this.osmDataDate;
    }

    public void setCreateStorage(boolean createStorage) {
        this.createStorage = createStorage;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

