/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.pbf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.OSMFileHeader;
import com.graphhopper.reader.osm.pbf.PbfBlobDecoderListener;
import com.graphhopper.reader.osm.pbf.PbfFieldDecoder;
import com.graphhopper.util.Helper;
import gnu.trove.list.TLongList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.openstreetmap.osmosis.osmbinary.Fileformat;
import org.openstreetmap.osmosis.osmbinary.Osmformat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbfBlobDecoder
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PbfBlobDecoder.class);
    private final boolean checkData = false;
    private final String blobType;
    private final byte[] rawBlob;
    private final PbfBlobDecoderListener listener;
    private List<ReaderElement> decodedEntities;

    public PbfBlobDecoder(String blobType, byte[] rawBlob, PbfBlobDecoderListener listener) {
        this.blobType = blobType;
        this.rawBlob = rawBlob;
        this.listener = listener;
    }

    private byte[] readBlobContent() throws IOException {
        byte[] blobData;
        Fileformat.Blob blob = Fileformat.Blob.parseFrom((byte[])this.rawBlob);
        if (blob.hasRaw()) {
            blobData = blob.getRaw().toByteArray();
        } else if (blob.hasZlibData()) {
            Inflater inflater = new Inflater();
            inflater.setInput(blob.getZlibData().toByteArray());
            blobData = new byte[blob.getRawSize()];
            try {
                inflater.inflate(blobData);
            }
            catch (DataFormatException e) {
                throw new RuntimeException("Unable to decompress PBF blob.", e);
            }
            if (!inflater.finished()) {
                throw new RuntimeException("PBF blob contains incomplete compressed data.");
            }
        } else {
            throw new RuntimeException("PBF blob uses unsupported compression, only raw or zlib may be used.");
        }
        return blobData;
    }

    private void processOsmHeader(byte[] data) throws InvalidProtocolBufferException {
        Osmformat.HeaderBlock header = Osmformat.HeaderBlock.parseFrom((byte[])data);
        List<String> supportedFeatures = Arrays.asList("OsmSchema-V0.6", "DenseNodes");
        ArrayList<String> unsupportedFeatures = new ArrayList<String>();
        for (String feature : header.getRequiredFeaturesList()) {
            if (supportedFeatures.contains(feature)) continue;
            unsupportedFeatures.add(feature);
        }
        if (unsupportedFeatures.size() > 0) {
            throw new RuntimeException("PBF file contains unsupported features " + unsupportedFeatures);
        }
        OSMFileHeader fileheader = new OSMFileHeader();
        long milliSecondDate = header.getOsmosisReplicationTimestamp();
        fileheader.setTag("timestamp", Helper.createFormatter().format(new Date(milliSecondDate * 1000L)));
        this.decodedEntities.add(fileheader);
    }

    private Map<String, String> buildTags(List<Integer> keys, List<Integer> values, PbfFieldDecoder fieldDecoder) {
        Iterator<Integer> keyIterator = keys.iterator();
        Iterator<Integer> valueIterator = values.iterator();
        if (keyIterator.hasNext()) {
            HashMap<String, String> tags = new HashMap<String, String>(keys.size());
            while (keyIterator.hasNext()) {
                String key = fieldDecoder.decodeString(keyIterator.next());
                String value = fieldDecoder.decodeString(valueIterator.next());
                tags.put(key, value);
            }
            return tags;
        }
        return null;
    }

    private void processNodes(List<Osmformat.Node> nodes, PbfFieldDecoder fieldDecoder) {
        for (Osmformat.Node node : nodes) {
            Map<String, String> tags = this.buildTags(node.getKeysList(), node.getValsList(), fieldDecoder);
            ReaderNode osmNode = new ReaderNode(node.getId(), fieldDecoder.decodeLatitude(node.getLat()), fieldDecoder.decodeLatitude(node.getLon()));
            osmNode.setTags(tags);
            this.decodedEntities.add((ReaderElement)osmNode);
        }
    }

    private void processNodes(Osmformat.DenseNodes nodes, PbfFieldDecoder fieldDecoder) {
        List idList = nodes.getIdList();
        List latList = nodes.getLatList();
        List lonList = nodes.getLonList();
        Iterator keysValuesIterator = nodes.getKeysValsList().iterator();
        long nodeId = 0L;
        long latitude = 0L;
        long longitude = 0L;
        for (int i = 0; i < idList.size(); ++i) {
            int keyIndex;
            nodeId += ((Long)idList.get(i)).longValue();
            latitude += ((Long)latList.get(i)).longValue();
            longitude += ((Long)lonList.get(i)).longValue();
            HashMap<String, String> tags = null;
            while (keysValuesIterator.hasNext() && (keyIndex = ((Integer)keysValuesIterator.next()).intValue()) != 0) {
                int valueIndex = (Integer)keysValuesIterator.next();
                if (tags == null) {
                    tags = new HashMap<String, String>();
                }
                tags.put(fieldDecoder.decodeString(keyIndex), fieldDecoder.decodeString(valueIndex));
            }
            ReaderNode node = new ReaderNode(nodeId, (double)latitude / 1.0E7, (double)longitude / 1.0E7);
            node.setTags(tags);
            this.decodedEntities.add((ReaderElement)node);
        }
    }

    private void processWays(List<Osmformat.Way> ways, PbfFieldDecoder fieldDecoder) {
        for (Osmformat.Way way : ways) {
            Map<String, String> tags = this.buildTags(way.getKeysList(), way.getValsList(), fieldDecoder);
            ReaderWay osmWay = new ReaderWay(way.getId());
            osmWay.setTags(tags);
            long nodeId = 0L;
            TLongList wayNodes = osmWay.getNodes();
            Iterator iterator = way.getRefsList().iterator();
            while (iterator.hasNext()) {
                long nodeIdOffset = (Long)iterator.next();
                wayNodes.add(nodeId += nodeIdOffset);
            }
            this.decodedEntities.add((ReaderElement)osmWay);
        }
    }

    private void buildRelationMembers(ReaderRelation relation, List<Long> memberIds, List<Integer> memberRoles, List<Osmformat.Relation.MemberType> memberTypes, PbfFieldDecoder fieldDecoder) {
        List members = relation.getMembers();
        Iterator<Long> memberIdIterator = memberIds.iterator();
        Iterator<Integer> memberRoleIterator = memberRoles.iterator();
        Iterator<Osmformat.Relation.MemberType> memberTypeIterator = memberTypes.iterator();
        long refId = 0L;
        while (memberIdIterator.hasNext()) {
            Osmformat.Relation.MemberType memberType = memberTypeIterator.next();
            refId += memberIdIterator.next().longValue();
            int entityType = 0;
            if (memberType == Osmformat.Relation.MemberType.WAY) {
                entityType = 1;
            } else if (memberType == Osmformat.Relation.MemberType.RELATION) {
                entityType = 2;
            }
            ReaderRelation.Member member = new ReaderRelation.Member(entityType, refId, fieldDecoder.decodeString(memberRoleIterator.next()));
            members.add(member);
        }
    }

    private void processRelations(List<Osmformat.Relation> relations, PbfFieldDecoder fieldDecoder) {
        for (Osmformat.Relation relation : relations) {
            Map<String, String> tags = this.buildTags(relation.getKeysList(), relation.getValsList(), fieldDecoder);
            ReaderRelation osmRelation = new ReaderRelation(relation.getId());
            osmRelation.setTags(tags);
            this.buildRelationMembers(osmRelation, relation.getMemidsList(), relation.getRolesSidList(), relation.getTypesList(), fieldDecoder);
            this.decodedEntities.add((ReaderElement)osmRelation);
        }
    }

    private void processOsmPrimitives(byte[] data) throws InvalidProtocolBufferException {
        Osmformat.PrimitiveBlock block = Osmformat.PrimitiveBlock.parseFrom((byte[])data);
        PbfFieldDecoder fieldDecoder = new PbfFieldDecoder(block);
        for (Osmformat.PrimitiveGroup primitiveGroup : block.getPrimitivegroupList()) {
            log.debug("Processing OSM primitive group.");
            this.processNodes(primitiveGroup.getDense(), fieldDecoder);
            this.processNodes(primitiveGroup.getNodesList(), fieldDecoder);
            this.processWays(primitiveGroup.getWaysList(), fieldDecoder);
            this.processRelations(primitiveGroup.getRelationsList(), fieldDecoder);
        }
    }

    private void runAndTrapExceptions() {
        try {
            this.decodedEntities = new ArrayList<ReaderElement>();
            if ("OSMHeader".equals(this.blobType)) {
                this.processOsmHeader(this.readBlobContent());
            } else if ("OSMData".equals(this.blobType)) {
                this.processOsmPrimitives(this.readBlobContent());
            } else if (log.isDebugEnabled()) {
                log.debug("Skipping unrecognised blob type " + this.blobType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process PBF blob", e);
        }
    }

    @Override
    public void run() {
        try {
            this.runAndTrapExceptions();
            this.listener.complete(this.decodedEntities);
        }
        catch (RuntimeException e) {
            this.listener.error(e);
        }
    }
}

