/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.graphhopper.GraphHopper;
import com.graphhopper.json.geo.JsonFeatureCollection;
import com.graphhopper.reader.DataReader;
import com.graphhopper.reader.osm.OSMReader;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.util.spatialrules.DefaultSpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupBuilder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.shapes.Polygon;
import java.util.List;

public class GraphHopperOSM
extends GraphHopper {
    private final JsonFeatureCollection landmarkSplittingFeatureCollection;

    public GraphHopperOSM() {
        this(null);
    }

    public GraphHopperOSM(JsonFeatureCollection landmarkSplittingFeatureCollection) {
        this.landmarkSplittingFeatureCollection = landmarkSplittingFeatureCollection;
    }

    protected DataReader createReader(GraphHopperStorage ghStorage) {
        return this.initDataReader(new OSMReader(ghStorage));
    }

    public String getOSMFile() {
        return this.getDataReaderFile();
    }

    public GraphHopperOSM setOSMFile(String osmFileStr) {
        super.setDataReaderFile(osmFileStr);
        return this;
    }

    protected void loadOrPrepareLM(boolean closeEarly) {
        if (!this.getLMFactoryDecorator().isEnabled() || this.getLMFactoryDecorator().getPreparations().isEmpty()) {
            return;
        }
        if (this.landmarkSplittingFeatureCollection != null && !this.landmarkSplittingFeatureCollection.getFeatures().isEmpty()) {
            SpatialRuleLookup ruleLookup = SpatialRuleLookupBuilder.buildIndex((JsonFeatureCollection)this.landmarkSplittingFeatureCollection, (String)"area", (SpatialRuleLookupBuilder.SpatialRuleFactory)new SpatialRuleLookupBuilder.SpatialRuleFactory(){

                public SpatialRule createSpatialRule(final String id, List<Polygon> polygons) {
                    return new DefaultSpatialRule(){

                        public String getId() {
                            return id;
                        }
                    }.setBorders(polygons);
                }
            });
            for (PrepareLandmarks prep : this.getLMFactoryDecorator().getPreparations()) {
                if (ruleLookup == null || ruleLookup.size() <= 0) continue;
                prep.setSpatialRuleLookup(ruleLookup);
            }
        }
        super.loadOrPrepareLM(closeEarly);
    }
}

