/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class GHRequest {
    private List<GHPoint> points;
    private String profile = "";
    private final PMap hints = new PMap();
    private List<Double> headings = new ArrayList<Double>();
    private List<String> pointHints = new ArrayList<String>();
    private List<String> curbsides = new ArrayList<String>();
    private List<String> snapPreventions;
    private List<String> pathDetails = new ArrayList<String>();
    private String algo = "";
    private Locale locale = Locale.US;
    private CustomModel customModel;

    public GHRequest() {
        this(5);
    }

    public GHRequest(int size) {
        this.points = new ArrayList<GHPoint>(size);
    }

    public GHRequest(double fromLat, double fromLon, double toLat, double toLon) {
        this(new GHPoint(fromLat, fromLon), new GHPoint(toLat, toLon));
    }

    public GHRequest(GHPoint startPlace, GHPoint endPlace) {
        if (startPlace == null) {
            throw new IllegalStateException("'from' cannot be null");
        }
        if (endPlace == null) {
            throw new IllegalStateException("'to' cannot be null");
        }
        this.points = new ArrayList<GHPoint>(2);
        this.points.add(startPlace);
        this.points.add(endPlace);
    }

    public GHRequest(List<GHPoint> points) {
        this.points = points;
    }

    public GHRequest setPoints(List<GHPoint> points) {
        this.points = points;
        return this;
    }

    public List<GHPoint> getPoints() {
        return this.points;
    }

    public GHRequest addPoint(GHPoint point) {
        if (point == null) {
            throw new IllegalArgumentException("point cannot be null");
        }
        this.points.add(point);
        return this;
    }

    public GHRequest setHeadings(List<Double> headings) {
        this.headings = headings;
        return this;
    }

    public List<Double> getHeadings() {
        return this.headings;
    }

    public static boolean isAzimuthValue(double heading) {
        return Double.isNaN(heading) || Double.compare(heading, 360.0) < 0 && Double.compare(heading, 0.0) >= 0;
    }

    public String getAlgorithm() {
        return this.algo;
    }

    public GHRequest setAlgorithm(String algo) {
        if (algo != null) {
            this.algo = Helper.camelCaseToUnderScore(algo);
        }
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public GHRequest setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
        return this;
    }

    public GHRequest setLocale(String localeStr) {
        return this.setLocale(Helper.getLocale(localeStr));
    }

    public CustomModel getCustomModel() {
        return this.customModel;
    }

    public GHRequest setCustomModel(CustomModel customModel) {
        this.customModel = customModel;
        return this;
    }

    public String getProfile() {
        return this.profile;
    }

    public GHRequest setProfile(String profile) {
        this.profile = profile;
        return this;
    }

    public PMap getHints() {
        return this.hints;
    }

    @JsonAnySetter
    public GHRequest putHint(String fieldName, Object value) {
        this.hints.putObject(fieldName, value);
        return this;
    }

    public GHRequest setPointHints(List<String> pointHints) {
        this.pointHints = pointHints;
        return this;
    }

    public List<String> getPointHints() {
        return this.pointHints;
    }

    public GHRequest setCurbsides(List<String> curbsides) {
        this.curbsides = curbsides;
        return this;
    }

    public List<String> getCurbsides() {
        return this.curbsides;
    }

    public boolean hasSnapPreventions() {
        return this.snapPreventions != null;
    }

    public GHRequest setSnapPreventions(List<String> snapPreventions) {
        this.snapPreventions = snapPreventions;
        return this;
    }

    public List<String> getSnapPreventions() {
        if (this.snapPreventions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.snapPreventions;
    }

    @JsonProperty(value="details")
    public GHRequest setPathDetails(List<String> pathDetails) {
        this.pathDetails = pathDetails;
        return this;
    }

    public List<String> getPathDetails() {
        return this.pathDetails;
    }

    public String toString() {
        Object res = "";
        for (GHPoint point : this.points) {
            if (((String)res).isEmpty()) {
                res = point.toString();
                continue;
            }
            res = (String)res + "; " + point.toString();
        }
        if (!this.algo.isEmpty()) {
            res = (String)res + " (" + this.algo + ")";
        }
        if (!this.pathDetails.isEmpty()) {
            res = (String)res + " (PathDetails: " + this.pathDetails + ")";
        }
        if (!this.hints.isEmpty()) {
            res = (String)res + " (Hints:" + this.hints + ")";
        }
        return res;
    }
}

