/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import java.util.Map;
import javax.lang.model.SourceVersion;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class JsonFeature {
    private String id;
    private String type = "Feature";
    private Envelope bbox;
    private Geometry geometry;
    private Map<String, Object> properties;

    public JsonFeature() {
    }

    public JsonFeature(String id, String type, Envelope bbox, Geometry geometry, Map<String, Object> properties) {
        this.id = id;
        this.type = type;
        this.bbox = bbox;
        this.geometry = geometry;
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Envelope getBBox() {
        return this.bbox;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBBox(Envelope bbox) {
        this.bbox = bbox;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String toString() {
        return "id:" + this.getId() + " with " + this.getGeometry().getCoordinates().length + " points: " + this.getGeometry();
    }

    public static boolean isValidId(String name) {
        if (name.length() <= 3 || !name.startsWith("in_") || SourceVersion.isKeyword(name)) {
            return false;
        }
        int underscoreCount = 0;
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                if (underscoreCount > 0) {
                    return false;
                }
                ++underscoreCount;
                continue;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                return false;
            }
            underscoreCount = 0;
        }
        return true;
    }
}

