/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TurnCostsConfig {
    public static final int INFINITE_U_TURN_COSTS = -1;
    private double leftTurnCosts;
    private double sharpLeftTurnCosts;
    private double straightCosts;
    private double rightTurnCosts;
    private double sharpRightTurnCosts;
    private double minTurnAngle = 25.0;
    private double minSharpTurnAngle = 80.0;
    private double minUTurnAngle = 180.0;
    private int uTurnCosts = -1;
    private List<String> vehicleTypes;
    private static final Set<String> ALL_SUPPORTED = Set.of("agricultural", "atv", "auto_rickshaw", "bdouble", "bicycle", "bus", "caravan", "carpool", "coach", "delivery", "destination", "emergency", "foot", "golf_cart", "goods", "hazmat", "hgv", "hgv:trailer", "hov", "minibus", "mofa", "moped", "motorcar", "motorcycle", "motor_vehicle", "motorhome", "nev", "ohv", "psv", "residents", "share_taxi", "small_electric_vehicle", "speed_pedelec", "taxi", "trailer", "tourist_bus");

    public static TurnCostsConfig car() {
        return new TurnCostsConfig(List.of("motorcar", "motor_vehicle"));
    }

    public static TurnCostsConfig bike() {
        return new TurnCostsConfig(List.of("bicycle"));
    }

    public TurnCostsConfig() {
    }

    public TurnCostsConfig(TurnCostsConfig copy) {
        this.leftTurnCosts = copy.leftTurnCosts;
        this.sharpLeftTurnCosts = copy.sharpLeftTurnCosts;
        this.straightCosts = copy.straightCosts;
        this.rightTurnCosts = copy.rightTurnCosts;
        this.sharpRightTurnCosts = copy.sharpRightTurnCosts;
        this.uTurnCosts = copy.uTurnCosts;
        this.minTurnAngle = copy.minTurnAngle;
        this.minSharpTurnAngle = copy.minSharpTurnAngle;
        this.minUTurnAngle = copy.minUTurnAngle;
        if (copy.vehicleTypes != null) {
            this.vehicleTypes = new ArrayList<String>(copy.vehicleTypes);
        }
    }

    public TurnCostsConfig(List<String> vehicleTypes) {
        this.vehicleTypes = this.check(vehicleTypes);
    }

    public TurnCostsConfig(List<String> vehicleTypes, int uTurnCost) {
        this.vehicleTypes = this.check(vehicleTypes);
        this.uTurnCosts = uTurnCost;
    }

    List<String> check(List<String> restrictions) {
        if (restrictions == null || restrictions.isEmpty()) {
            throw new IllegalArgumentException("turn_costs cannot have empty vehicle_types");
        }
        for (String r : restrictions) {
            if (ALL_SUPPORTED.contains(r)) continue;
            throw new IllegalArgumentException("Currently we do not support the restriction: " + r);
        }
        return restrictions;
    }

    public TurnCostsConfig setVehicleTypes(List<String> vehicleTypes) {
        this.vehicleTypes = this.check(vehicleTypes);
        return this;
    }

    @JsonProperty(value="vehicle_types")
    public List<String> getVehicleTypes() {
        this.check(this.vehicleTypes);
        return this.vehicleTypes;
    }

    public TurnCostsConfig setUTurnCosts(int uTurnCosts) {
        this.uTurnCosts = uTurnCosts;
        return this;
    }

    @JsonProperty(value="u_turn_costs")
    public int getUTurnCosts() {
        return this.uTurnCosts;
    }

    public boolean hasLeftRightStraightCosts() {
        return this.leftTurnCosts != 0.0 || this.sharpLeftTurnCosts != 0.0 || this.straightCosts != 0.0 || this.rightTurnCosts != 0.0 || this.sharpRightTurnCosts != 0.0;
    }

    public TurnCostsConfig setLeftTurnCosts(double leftTurnCosts) {
        this.leftTurnCosts = leftTurnCosts;
        return this;
    }

    @JsonProperty(value="left_turn_costs")
    public double getLeftTurnCosts() {
        return this.leftTurnCosts;
    }

    public TurnCostsConfig setSharpLeftTurnCosts(double sharpLeftTurnCosts) {
        this.sharpLeftTurnCosts = sharpLeftTurnCosts;
        return this;
    }

    @JsonProperty(value="sharp_left_turn_costs")
    public double getSharpLeftTurnCosts() {
        return this.sharpLeftTurnCosts;
    }

    public TurnCostsConfig setRightTurnCosts(double rightTurnCosts) {
        this.rightTurnCosts = rightTurnCosts;
        return this;
    }

    @JsonProperty(value="right_turn_costs")
    public double getRightTurnCosts() {
        return this.rightTurnCosts;
    }

    public TurnCostsConfig setSharpRightTurnCosts(double sharpRightTurnCosts) {
        this.sharpRightTurnCosts = sharpRightTurnCosts;
        return this;
    }

    @JsonProperty(value="sharp_right_turn_costs")
    public double getSharpRightTurnCosts() {
        return this.sharpRightTurnCosts;
    }

    public TurnCostsConfig setStraightCosts(double straightCosts) {
        this.straightCosts = straightCosts;
        return this;
    }

    @JsonProperty(value="straight_costs")
    public double getStraightCosts() {
        return this.straightCosts;
    }

    @JsonProperty(value="min_turn_angle")
    public TurnCostsConfig setMinTurnAngle(double minTurnAngle) {
        this.minTurnAngle = minTurnAngle;
        return this;
    }

    public double getMinTurnAngle() {
        return this.minTurnAngle;
    }

    @JsonProperty(value="min_sharp_turn_angle")
    public TurnCostsConfig setMinSharpTurnAngle(double minSharpTurnAngle) {
        this.minSharpTurnAngle = minSharpTurnAngle;
        return this;
    }

    public double getMinSharpTurnAngle() {
        return this.minSharpTurnAngle;
    }

    @JsonProperty(value="min_u_turn_angle")
    public TurnCostsConfig setMinUTurnAngle(double minUTurnAngle) {
        this.minUTurnAngle = minUTurnAngle;
        return this;
    }

    public double getMinUTurnAngle() {
        return this.minUTurnAngle;
    }

    public String toString() {
        return "leftTurnCosts=" + this.leftTurnCosts + ", sharpLeftTurnCosts=" + this.sharpLeftTurnCosts + ", straightCosts=" + this.straightCosts + ", rightTurnCosts=" + this.rightTurnCosts + ", sharpRightTurnCosts=" + this.sharpRightTurnCosts + ", minTurnAngle=" + this.minTurnAngle + ", minSharpTurnAngle=" + this.minSharpTurnAngle + ", minUTurnAngle=" + this.minUTurnAngle + ", uTurnCosts=" + this.uTurnCosts + ", vehicleTypes=" + this.vehicleTypes;
    }
}

