/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.graphhopper.isochrone.algorithm.ReadableTriangulation;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulator;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Path(value="isochrone-pt")
public class PtIsochroneResource {
    private static final double JTS_TOLERANCE = 1.0E-5;
    private final GtfsStorage gtfsStorage;
    private final EncodingManager encodingManager;
    private final GraphHopperStorage graphHopperStorage;
    private final LocationIndex locationIndex;
    private final Function<Label, Double> z = label -> label.currentTime;

    @Inject
    public PtIsochroneResource(GtfsStorage gtfsStorage, EncodingManager encodingManager, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex) {
        this.gtfsStorage = gtfsStorage;
        this.encodingManager = encodingManager;
        this.graphHopperStorage = graphHopperStorage;
        this.locationIndex = locationIndex;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@QueryParam(value="point") GHPoint source, @QueryParam(value="time_limit") @DefaultValue(value="600") long seconds, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="pt.earliest_departure_time") String departureTimeString, @QueryParam(value="pt.blocked_route_types") @DefaultValue(value="0") int blockedRouteTypes, @QueryParam(value="result") @DefaultValue(value="multipolygon") String format) {
        Instant initialTime;
        try {
            initialTime = Instant.parse(departureTimeString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Illegal value for required parameter %s: [%s]", "pt.earliest_departure_time", departureTimeString));
        }
        double targetZ = initialTime.toEpochMilli() + seconds * 1000L;
        GeometryFactory geometryFactory = new GeometryFactory();
        FlagEncoder footEncoder = this.encodingManager.getEncoder("foot");
        FastestWeighting weighting = new FastestWeighting(footEncoder);
        DefaultSnapFilter filter = new DefaultSnapFilter(weighting, this.encodingManager.getBooleanEncodedValue(Subnetwork.key("foot")));
        Snap snap = this.locationIndex.findClosest(source.lat, source.lon, filter);
        QueryGraph queryGraph = QueryGraph.create((Graph)this.graphHopperStorage, Collections.singletonList(snap));
        if (!snap.isValid()) {
            throw new IllegalArgumentException("Cannot find point: " + source);
        }
        PtEncodedValues ptEncodedValues = PtEncodedValues.fromEncodingManager(this.encodingManager);
        GraphExplorer graphExplorer = new GraphExplorer(queryGraph, weighting, ptEncodedValues, this.gtfsStorage, RealtimeFeed.empty(this.gtfsStorage), reverseFlow, false, false, 5.0, reverseFlow, blockedRouteTypes);
        MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, ptEncodedValues, reverseFlow, false, false, 0L, Collections.emptyList());
        HashMap z1 = new HashMap();
        NodeAccess nodeAccess = queryGraph.getNodeAccess();
        MultiCriteriaLabelSetting.SPTVisitor sptVisitor = nodeLabel -> {
            Coordinate nodeCoordinate = new Coordinate(nodeAccess.getLon(nodeLabel.adjNode), nodeAccess.getLat(nodeLabel.adjNode));
            z1.merge(nodeCoordinate, this.z.apply(nodeLabel), Math::min);
        };
        if (format.equals("multipoint")) {
            PtIsochroneResource.calcLabels(router, snap.getClosestNode(), initialTime, sptVisitor, label -> (double)label.currentTime <= targetZ);
            MultiPoint exploredPoints = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
            return this.wrap(exploredPoints);
        }
        PtIsochroneResource.calcLabels(router, snap.getClosestNode(), initialTime, sptVisitor, label -> (double)label.currentTime <= targetZ);
        MultiPoint exploredPoints = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
        this.locationIndex.query(BBox.fromEnvelope(exploredPoints.getEnvelopeInternal()), edgeId -> {
            EdgeIteratorState edge = queryGraph.getEdgeIteratorStateForKey(edgeId * 2);
            z1.merge(new Coordinate(nodeAccess.getLon(edge.getBaseNode()), nodeAccess.getLat(edge.getBaseNode())), Double.MAX_VALUE, Math::min);
            z1.merge(new Coordinate(nodeAccess.getLon(edge.getAdjNode()), nodeAccess.getLat(edge.getAdjNode())), Double.MAX_VALUE, Math::min);
        });
        exploredPoints = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
        CoordinateList siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(exploredPoints);
        ArrayList<ConstraintVertex> constraintVertices = new ArrayList<ConstraintVertex>();
        for (Object siteCoord : siteCoords) {
            Coordinate coord = (Coordinate)siteCoord;
            constraintVertices.add(new ConstraintVertex(coord));
        }
        ConformingDelaunayTriangulator cdt = new ConformingDelaunayTriangulator(constraintVertices, 1.0E-5);
        cdt.setConstraints(new ArrayList(), new ArrayList());
        cdt.formInitialDelaunay();
        QuadEdgeSubdivision tin = cdt.getSubdivision();
        for (Vertex vertex : tin.getVertices(true)) {
            if (tin.isFrameVertex(vertex)) {
                vertex.setZ(Double.MAX_VALUE);
                continue;
            }
            Double aDouble = (Double)z1.get(vertex.getCoordinate());
            if (aDouble != null) {
                vertex.setZ(aDouble);
                continue;
            }
            vertex.setZ(Double.MAX_VALUE);
        }
        ReadableTriangulation triangulation = ReadableTriangulation.wrap(tin);
        ContourBuilder contourBuilder = new ContourBuilder(triangulation);
        MultiPolygon isoline = contourBuilder.computeIsoline(targetZ, triangulation.getEdges());
        if (format.equals("triangulation")) {
            HashMap<String, Object> properties;
            JsonFeature feature;
            Response response = new Response();
            for (Vertex vertex : tin.getVertices(true)) {
                feature = new JsonFeature();
                feature.setGeometry(geometryFactory.createPoint(vertex.getCoordinate()));
                properties = new HashMap<String, Object>();
                properties.put("z", vertex.getZ());
                feature.setProperties(properties);
                response.polygons.add(feature);
            }
            for (QuadEdge edge : tin.getPrimaryEdges(false)) {
                feature = new JsonFeature();
                feature.setGeometry(edge.toLineSegment().toGeometry(geometryFactory));
                properties = new HashMap();
                feature.setProperties(properties);
                response.polygons.add(feature);
            }
            JsonFeature feature2 = new JsonFeature();
            feature2.setGeometry(isoline);
            HashMap<String, Object> properties2 = new HashMap<String, Object>();
            properties2.put("z", targetZ);
            feature2.setProperties(properties2);
            response.polygons.add(feature2);
            response.info.copyrights.addAll(ResponsePathSerializer.COPYRIGHTS);
            return response;
        }
        return this.wrap(isoline);
    }

    private static void calcLabels(MultiCriteriaLabelSetting router, int from, Instant startTime, MultiCriteriaLabelSetting.SPTVisitor visitor, Predicate<Label> predicate) {
        Label label;
        Iterator iterator = router.calcLabels(from, startTime).iterator();
        while (iterator.hasNext() && predicate.test(label = (Label)iterator.next())) {
            visitor.visit(label);
        }
    }

    private Response wrap(Geometry isoline) {
        JsonFeature feature = new JsonFeature();
        feature.setGeometry(isoline);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bucket", 0);
        feature.setProperties(properties);
        Response response = new Response();
        response.polygons.add(feature);
        response.info.copyrights.addAll(ResponsePathSerializer.COPYRIGHTS);
        return response;
    }

    public static class Response {
        public List<JsonFeature> polygons = new ArrayList<JsonFeature>();
        public Info info = new Info();

        public static class Info {
            public List<String> copyrights = new ArrayList<String>();
        }
    }
}

