/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.Profile;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.CHPathCalculator;
import com.graphhopper.routing.FlexiblePathCalculator;
import com.graphhopper.routing.MultiplePointsNotFoundException;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathCalculator;
import com.graphhopper.routing.RoundTripRouting;
import com.graphhopper.routing.RouterConfig;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.ViaRouting;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.lm.LMRoutingAlgorithmFactory;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FiniteWeightFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BlockAreaWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.PointDistanceExceededException;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.exceptions.PointOutOfBoundsException;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Router {
    private final GraphHopperStorage ghStorage;
    private final EncodingManager encodingManager;
    private final LocationIndex locationIndex;
    private final Map<String, Profile> profilesByName;
    private final PathDetailsBuilderFactory pathDetailsBuilderFactory;
    private final TranslationMap translationMap;
    private final RouterConfig routerConfig;
    private final WeightingFactory weightingFactory;
    private final Map<String, RoutingCHGraph> chGraphs;
    private final Map<String, LandmarkStorage> landmarks;
    private final boolean chEnabled;
    private final boolean lmEnabled;

    public Router(GraphHopperStorage ghStorage, LocationIndex locationIndex, Map<String, Profile> profilesByName, PathDetailsBuilderFactory pathDetailsBuilderFactory, TranslationMap translationMap, RouterConfig routerConfig, WeightingFactory weightingFactory, Map<String, RoutingCHGraph> chGraphs, Map<String, LandmarkStorage> landmarks) {
        this.ghStorage = ghStorage;
        this.encodingManager = ghStorage.getEncodingManager();
        this.locationIndex = locationIndex;
        this.profilesByName = profilesByName;
        this.pathDetailsBuilderFactory = pathDetailsBuilderFactory;
        this.translationMap = translationMap;
        this.routerConfig = routerConfig;
        this.weightingFactory = weightingFactory;
        this.chGraphs = chGraphs;
        this.landmarks = landmarks;
        this.chEnabled = !chGraphs.isEmpty();
        this.lmEnabled = !landmarks.isEmpty();
        for (String profile : profilesByName.keySet()) {
            if (this.encodingManager.hasEncodedValue(Subnetwork.key(profile))) continue;
            throw new IllegalStateException("The profile '" + profile + "' needs an EncodedValue '" + Subnetwork.key(profile) + "'");
        }
    }

    public GHResponse route(GHRequest request) {
        try {
            this.checkNoLegacyParameters(request);
            this.checkAtLeastOnePoint(request);
            this.checkIfPointsAreInBounds(request.getPoints());
            this.checkHeadings(request);
            this.checkPointHints(request);
            this.checkCurbsides(request);
            this.checkNoBlockAreaWithCustomModel(request);
            Solver solver = this.createSolver(request);
            solver.checkRequest();
            solver.init();
            if ("round_trip".equalsIgnoreCase(request.getAlgorithm())) {
                if (!(solver instanceof FlexSolver)) {
                    throw new IllegalArgumentException("algorithm=round_trip only works with a flexible algorithm");
                }
                return this.routeRoundTrip(request, (FlexSolver)solver);
            }
            if ("alternative_route".equalsIgnoreCase(request.getAlgorithm())) {
                return this.routeAlt(request, solver);
            }
            return this.routeVia(request, solver);
        }
        catch (MultiplePointsNotFoundException ex) {
            GHResponse ghRsp = new GHResponse();
            for (IntCursor p : ex.getPointsNotFound()) {
                ghRsp.addError(new PointNotFoundException("Cannot find point " + p.value + ": " + request.getPoints().get(p.value), p.value));
            }
            return ghRsp;
        }
        catch (IllegalArgumentException ex) {
            GHResponse ghRsp = new GHResponse();
            ghRsp.addError(ex);
            return ghRsp;
        }
    }

    private void checkNoLegacyParameters(GHRequest request) {
        if (request.getHints().has("vehicle")) {
            throw new IllegalArgumentException("GHRequest may no longer contain a vehicle, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getHints().has("weighting")) {
            throw new IllegalArgumentException("GHRequest may no longer contain a weighting, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getHints().has("turn_costs")) {
            throw new IllegalArgumentException("GHRequest may no longer contain the turn_costs=true/false parameter, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getHints().has("edge_based")) {
            throw new IllegalArgumentException("GHRequest may no longer contain the edge_based=true/false parameter, use the profile parameter instead, see docs/core/profiles.md");
        }
    }

    private void checkAtLeastOnePoint(GHRequest request) {
        if (request.getPoints().isEmpty()) {
            throw new IllegalArgumentException("You have to pass at least one point");
        }
    }

    private void checkIfPointsAreInBounds(List<GHPoint> points) {
        BBox bounds = this.ghStorage.getBounds();
        for (int i = 0; i < points.size(); ++i) {
            GHPoint point = points.get(i);
            if (bounds.contains(point.getLat(), point.getLon())) continue;
            throw new PointOutOfBoundsException("Point " + i + " is out of bounds: " + point + ", the bounds are: " + bounds, i);
        }
    }

    private void checkHeadings(GHRequest request) {
        if (request.getHeadings().size() > 1 && request.getHeadings().size() != request.getPoints().size()) {
            throw new IllegalArgumentException("The number of 'heading' parameters must be zero, one or equal to the number of points (" + request.getPoints().size() + ")");
        }
        for (int i = 0; i < request.getHeadings().size(); ++i) {
            if (GHRequest.isAzimuthValue(request.getHeadings().get(i))) continue;
            throw new IllegalArgumentException("Heading for point " + i + " must be in range [0,360) or NaN, but was: " + request.getHeadings().get(i));
        }
    }

    private void checkPointHints(GHRequest request) {
        if (request.getPointHints().size() > 0 && request.getPointHints().size() != request.getPoints().size()) {
            throw new IllegalArgumentException("If you pass point_hint, you need to pass exactly one hint for every point, empty hints will be ignored");
        }
    }

    private void checkCurbsides(GHRequest request) {
        if (request.getCurbsides().size() > 0 && request.getCurbsides().size() != request.getPoints().size()) {
            throw new IllegalArgumentException("If you pass curbside, you need to pass exactly one curbside for every point, empty curbsides will be ignored");
        }
    }

    private void checkNoBlockAreaWithCustomModel(GHRequest request) {
        if (request.getCustomModel() != null && request.getHints().has("block_area")) {
            throw new IllegalArgumentException("When using `custom_model` do not use `block_area`. Use `areas` in the custom model instead");
        }
    }

    protected Solver createSolver(GHRequest request) {
        boolean disableCH = Router.getDisableCH(request.getHints());
        boolean disableLM = Router.getDisableLM(request.getHints());
        if (this.chEnabled && !disableCH) {
            return new CHSolver(request, this.profilesByName, this.routerConfig, this.encodingManager, this.chGraphs);
        }
        if (this.lmEnabled && !disableLM) {
            return new LMSolver(request, this.profilesByName, this.routerConfig, this.encodingManager, this.weightingFactory, this.ghStorage, this.locationIndex, this.landmarks);
        }
        return new FlexSolver(request, this.profilesByName, this.routerConfig, this.encodingManager, this.weightingFactory, this.ghStorage, this.locationIndex);
    }

    protected GHResponse routeRoundTrip(GHRequest request, FlexSolver solver) {
        GHResponse ghRsp = new GHResponse();
        StopWatch sw = new StopWatch().start();
        double startHeading = request.getHeadings().isEmpty() ? Double.NaN : request.getHeadings().get(0);
        RoundTripRouting.Params params = new RoundTripRouting.Params(request.getHints(), startHeading, this.routerConfig.getMaxRoundTripRetries());
        List<Snap> snaps = RoundTripRouting.lookup(request.getPoints(), solver.getSnapFilter(), this.locationIndex, params);
        ghRsp.addDebugInfo("idLookup:" + sw.stop().getSeconds() + "s");
        QueryGraph queryGraph = QueryGraph.create((Graph)this.ghStorage, snaps);
        FlexiblePathCalculator pathCalculator = solver.createPathCalculator(queryGraph);
        RoundTripRouting.Result result = RoundTripRouting.calcPaths(snaps, pathCalculator);
        ResponsePath responsePath = this.concatenatePaths(request, solver.weighting, queryGraph, result.paths, this.getWaypoints(snaps));
        ghRsp.add(responsePath);
        ghRsp.getHints().putObject("visited_nodes.sum", result.visitedNodes);
        ghRsp.getHints().putObject("visited_nodes.average", Float.valueOf((float)result.visitedNodes / (float)(snaps.size() - 1)));
        return ghRsp;
    }

    protected GHResponse routeAlt(GHRequest request, Solver solver) {
        if (request.getPoints().size() > 2) {
            throw new IllegalArgumentException("Currently alternative routes work only with start and end point. You tried to use: " + request.getPoints().size() + " points");
        }
        GHResponse ghRsp = new GHResponse();
        StopWatch sw = new StopWatch().start();
        List<Snap> snaps = ViaRouting.lookup(this.encodingManager, request.getPoints(), solver.getSnapFilter(), this.locationIndex, request.getSnapPreventions(), request.getPointHints());
        ghRsp.addDebugInfo("idLookup:" + sw.stop().getSeconds() + "s");
        QueryGraph queryGraph = QueryGraph.create((Graph)this.ghStorage, snaps);
        PathCalculator pathCalculator = solver.createPathCalculator(queryGraph);
        boolean passThrough = Router.getPassThrough(request.getHints());
        boolean forceCurbsides = Router.getForceCurbsides(request.getHints());
        if (passThrough) {
            throw new IllegalArgumentException("Alternative paths and pass_through at the same time is currently not supported");
        }
        if (!request.getCurbsides().isEmpty()) {
            throw new IllegalArgumentException("Alternative paths do not support the curbside parameter yet");
        }
        ViaRouting.Result result = ViaRouting.calcPaths(request.getPoints(), queryGraph, snaps, solver.weighting, pathCalculator, request.getCurbsides(), forceCurbsides, request.getHeadings(), passThrough);
        if (result.paths.isEmpty()) {
            throw new RuntimeException("Empty paths for alternative route calculation not expected");
        }
        PathMerger pathMerger = this.createPathMerger(request, solver.weighting, queryGraph);
        for (Path path : result.paths) {
            PointList waypoints = this.getWaypoints(snaps);
            ResponsePath responsePath = pathMerger.doWork(waypoints, Collections.singletonList(path), this.encodingManager, this.translationMap.getWithFallBack(request.getLocale()));
            ghRsp.add(responsePath);
        }
        ghRsp.getHints().putObject("visited_nodes.sum", result.visitedNodes);
        ghRsp.getHints().putObject("visited_nodes.average", Float.valueOf((float)result.visitedNodes / (float)(snaps.size() - 1)));
        return ghRsp;
    }

    protected GHResponse routeVia(GHRequest request, Solver solver) {
        GHResponse ghRsp = new GHResponse();
        StopWatch sw = new StopWatch().start();
        List<Snap> snaps = ViaRouting.lookup(this.encodingManager, request.getPoints(), solver.getSnapFilter(), this.locationIndex, request.getSnapPreventions(), request.getPointHints());
        ghRsp.addDebugInfo("idLookup:" + sw.stop().getSeconds() + "s");
        QueryGraph queryGraph = QueryGraph.create((Graph)this.ghStorage, snaps);
        PathCalculator pathCalculator = solver.createPathCalculator(queryGraph);
        boolean passThrough = Router.getPassThrough(request.getHints());
        boolean forceCurbsides = Router.getForceCurbsides(request.getHints());
        ViaRouting.Result result = ViaRouting.calcPaths(request.getPoints(), queryGraph, snaps, solver.weighting, pathCalculator, request.getCurbsides(), forceCurbsides, request.getHeadings(), passThrough);
        if (request.getPoints().size() != result.paths.size() + 1) {
            throw new RuntimeException("There should be exactly one more point than paths. points:" + request.getPoints().size() + ", paths:" + result.paths.size());
        }
        ResponsePath responsePath = this.concatenatePaths(request, solver.weighting, queryGraph, result.paths, this.getWaypoints(snaps));
        responsePath.addDebugInfo(result.debug);
        ghRsp.add(responsePath);
        ghRsp.getHints().putObject("visited_nodes.sum", result.visitedNodes);
        ghRsp.getHints().putObject("visited_nodes.average", Float.valueOf((float)result.visitedNodes / (float)(snaps.size() - 1)));
        return ghRsp;
    }

    private PathMerger createPathMerger(GHRequest request, Weighting weighting, Graph graph) {
        boolean enableInstructions = request.getHints().getBool("instructions", this.encodingManager.isEnableInstructions());
        boolean calcPoints = request.getHints().getBool("calc_points", this.routerConfig.isCalcPoints());
        double wayPointMaxDistance = request.getHints().getDouble("way_point_max_distance", 1.0);
        double elevationWayPointMaxDistance = request.getHints().getDouble("elevation_way_point_max_distance", this.routerConfig.getElevationWayPointMaxDistance());
        DouglasPeucker peucker = new DouglasPeucker().setMaxDistance(wayPointMaxDistance).setElevationMaxDistance(elevationWayPointMaxDistance);
        PathMerger pathMerger = new PathMerger(graph, weighting).setCalcPoints(calcPoints).setDouglasPeucker(peucker).setEnableInstructions(enableInstructions).setPathDetailsBuilders(this.pathDetailsBuilderFactory, request.getPathDetails()).setSimplifyResponse(this.routerConfig.isSimplifyResponse() && wayPointMaxDistance > 0.0);
        if (!request.getHeadings().isEmpty()) {
            pathMerger.setFavoredHeading(request.getHeadings().get(0));
        }
        return pathMerger;
    }

    private ResponsePath concatenatePaths(GHRequest request, Weighting weighting, QueryGraph queryGraph, List<Path> paths, PointList waypoints) {
        PathMerger pathMerger = this.createPathMerger(request, weighting, queryGraph);
        return pathMerger.doWork(waypoints, paths, this.encodingManager, this.translationMap.getWithFallBack(request.getLocale()));
    }

    private PointList getWaypoints(List<Snap> snaps) {
        PointList pointList = new PointList(snaps.size(), true);
        for (Snap snap : snaps) {
            pointList.add(snap.getSnappedPoint());
        }
        return pointList;
    }

    private static boolean getDisableLM(PMap hints) {
        return hints.getBool("lm.disable", false);
    }

    private static boolean getDisableCH(PMap hints) {
        return hints.getBool("ch.disable", false);
    }

    private static boolean getPassThrough(PMap hints) {
        return hints.getBool("pass_through", false);
    }

    private static boolean getForceCurbsides(PMap hints) {
        return hints.getBool("force_curbside", true);
    }

    private static class LMSolver
    extends FlexSolver {
        private final Map<String, LandmarkStorage> landmarks;

        LMSolver(GHRequest request, Map<String, Profile> profilesByName, RouterConfig routerConfig, EncodedValueLookup lookup, WeightingFactory weightingFactory, GraphHopperStorage ghStorage, LocationIndex locationIndex, Map<String, LandmarkStorage> landmarks) {
            super(request, profilesByName, routerConfig, lookup, weightingFactory, ghStorage, locationIndex);
            this.landmarks = landmarks;
        }

        @Override
        protected FlexiblePathCalculator createPathCalculator(QueryGraph queryGraph) {
            LandmarkStorage landmarkStorage = this.landmarks.get(this.profile.getName());
            if (landmarkStorage == null) {
                throw new IllegalArgumentException("Cannot find LM preparation for the requested profile: '" + this.profile.getName() + "'\nYou can try disabling LM using " + "lm.disable" + "=true\navailable LM profiles: " + this.landmarks.keySet());
            }
            LMRoutingAlgorithmFactory routingAlgorithmFactory = new LMRoutingAlgorithmFactory(landmarkStorage).setDefaultActiveLandmarks(this.routerConfig.getActiveLandmarkCount());
            return new FlexiblePathCalculator(queryGraph, routingAlgorithmFactory, this.weighting, this.getAlgoOpts());
        }
    }

    private static class FlexSolver
    extends Solver {
        protected final RouterConfig routerConfig;
        private final WeightingFactory weightingFactory;
        private final GraphHopperStorage ghStorage;
        private final LocationIndex locationIndex;

        FlexSolver(GHRequest request, Map<String, Profile> profilesByName, RouterConfig routerConfig, EncodedValueLookup lookup, WeightingFactory weightingFactory, GraphHopperStorage ghStorage, LocationIndex locationIndex) {
            super(request, profilesByName, routerConfig, lookup);
            this.routerConfig = routerConfig;
            this.weightingFactory = weightingFactory;
            this.ghStorage = ghStorage;
            this.locationIndex = locationIndex;
        }

        @Override
        protected void checkRequest() {
            super.checkRequest();
            this.checkNonChMaxWaypointDistance(this.request.getPoints());
        }

        @Override
        protected Weighting createWeighting() {
            PMap requestHints = new PMap(this.request.getHints());
            requestHints.putObject("custom_model", this.request.getCustomModel());
            Weighting weighting = this.weightingFactory.createWeighting(this.profile, requestHints, false);
            if (requestHints.has("block_area")) {
                GraphEdgeIdFinder.BlockArea blockArea = GraphEdgeIdFinder.createBlockArea(this.ghStorage, this.locationIndex, this.request.getPoints(), requestHints, new FiniteWeightFilter(weighting));
                weighting = new BlockAreaWeighting(weighting, blockArea);
            }
            return weighting;
        }

        @Override
        protected FlexiblePathCalculator createPathCalculator(QueryGraph queryGraph) {
            RoutingAlgorithmFactorySimple algorithmFactory = new RoutingAlgorithmFactorySimple();
            return new FlexiblePathCalculator(queryGraph, algorithmFactory, this.weighting, this.getAlgoOpts());
        }

        AlgorithmOptions getAlgoOpts() {
            AlgorithmOptions algoOpts = new AlgorithmOptions().setAlgorithm(this.request.getAlgorithm()).setTraversalMode(this.profile.isTurnCosts() ? TraversalMode.EDGE_BASED : TraversalMode.NODE_BASED).setMaxVisitedNodes(this.getMaxVisitedNodes(this.request.getHints())).setHints(this.request.getHints());
            if ("round_trip".equalsIgnoreCase(this.request.getAlgorithm())) {
                algoOpts.setAlgorithm("astarbi");
                algoOpts.getHints().putObject("astarbi.epsilon", 2);
            }
            return algoOpts;
        }

        private void checkNonChMaxWaypointDistance(List<GHPoint> points) {
            if (this.routerConfig.getNonChMaxWaypointDistance() == Integer.MAX_VALUE) {
                return;
            }
            GHPoint lastPoint = points.get(0);
            for (int i = 1; i < points.size(); ++i) {
                GHPoint point = points.get(i);
                double dist = DistanceCalcEarth.DIST_EARTH.calcDist(lastPoint.getLat(), lastPoint.getLon(), point.getLat(), point.getLon());
                if (dist > (double)this.routerConfig.getNonChMaxWaypointDistance()) {
                    HashMap<String, Object> detailMap = new HashMap<String, Object>(2);
                    detailMap.put("from", i - 1);
                    detailMap.put("to", i);
                    throw new PointDistanceExceededException("Point " + i + " is too far from Point " + (i - 1) + ": " + point, detailMap);
                }
                lastPoint = point;
            }
        }
    }

    private static class CHSolver
    extends Solver {
        private final Map<String, RoutingCHGraph> chGraphs;

        CHSolver(GHRequest request, Map<String, Profile> profilesByName, RouterConfig routerConfig, EncodedValueLookup lookup, Map<String, RoutingCHGraph> chGraphs) {
            super(request, profilesByName, routerConfig, lookup);
            this.chGraphs = chGraphs;
        }

        @Override
        protected void checkRequest() {
            super.checkRequest();
            if (!this.request.getHeadings().isEmpty()) {
                throw new IllegalArgumentException("The 'heading' parameter is currently not supported for speed mode, you need to disable speed mode with `ch.disable=true`. See issue #483");
            }
            if (Router.getPassThrough(this.request.getHints())) {
                throw new IllegalArgumentException("The 'pass_through' parameter is currently not supported for speed mode, you need to disable speed mode with `ch.disable=true`. See issue #1765");
            }
            if (this.request.getHints().has("block_area")) {
                throw new IllegalArgumentException("The 'block_area' parameter is currently not supported for speed mode, you need to disable speed mode with `ch.disable=true`.");
            }
            if (this.request.getCustomModel() != null) {
                throw new IllegalArgumentException("The 'custom_model' parameter is currently not supported for speed mode, you need to disable speed mode with `ch.disable=true`.");
            }
            if ("round_trip".equalsIgnoreCase(this.request.getAlgorithm())) {
                throw new IllegalArgumentException("algorithm=round_trip cannot be used with CH");
            }
        }

        @Override
        protected Weighting createWeighting() {
            return this.getRoutingCHGraph(this.profile.getName()).getWeighting();
        }

        @Override
        protected PathCalculator createPathCalculator(QueryGraph queryGraph) {
            PMap opts = new PMap(this.request.getHints());
            opts.putObject("algorithm", this.request.getAlgorithm());
            opts.putObject("max_visited_nodes", this.getMaxVisitedNodes(this.request.getHints()));
            return new CHPathCalculator(new CHRoutingAlgorithmFactory(this.getRoutingCHGraph(this.profile.getName()), queryGraph), opts);
        }

        private RoutingCHGraph getRoutingCHGraph(String profileName) {
            RoutingCHGraph chGraph = this.chGraphs.get(profileName);
            if (chGraph == null) {
                throw new IllegalArgumentException("Cannot find CH preparation for the requested profile: '" + profileName + "'\nYou can try disabling CH using " + "ch.disable" + "=true\navailable CH profiles: " + this.chGraphs.keySet());
            }
            return chGraph;
        }
    }

    public static abstract class Solver {
        protected final GHRequest request;
        private final Map<String, Profile> profilesByName;
        private final RouterConfig routerConfig;
        protected Profile profile;
        protected Weighting weighting;
        protected final EncodedValueLookup lookup;

        public Solver(GHRequest request, Map<String, Profile> profilesByName, RouterConfig routerConfig, EncodedValueLookup lookup) {
            this.request = request;
            this.profilesByName = profilesByName;
            this.routerConfig = routerConfig;
            this.lookup = lookup;
        }

        protected void checkRequest() {
            this.checkProfileSpecified();
            this.checkMaxVisitedNodes();
        }

        private void checkProfileSpecified() {
            if (Helper.isEmpty(this.request.getProfile())) {
                throw new IllegalArgumentException("You need to specify a profile to perform a routing request, see docs/core/profiles.md");
            }
        }

        private void checkMaxVisitedNodes() {
            if (this.getMaxVisitedNodes(this.request.getHints()) > this.routerConfig.getMaxVisitedNodes()) {
                throw new IllegalArgumentException("The max_visited_nodes parameter has to be below or equal to:" + this.routerConfig.getMaxVisitedNodes());
            }
        }

        private void init() {
            this.profile = this.getProfile();
            this.checkProfileCompatibility();
            this.weighting = this.createWeighting();
        }

        protected Profile getProfile() {
            Profile profile = this.profilesByName.get(this.request.getProfile());
            if (profile == null) {
                throw new IllegalArgumentException("The requested profile '" + this.request.getProfile() + "' does not exist.\nAvailable profiles: " + this.profilesByName.keySet());
            }
            return profile;
        }

        protected void checkProfileCompatibility() {
            if (!this.profile.isTurnCosts() && !this.request.getCurbsides().isEmpty()) {
                throw new IllegalArgumentException("To make use of the curbside parameter you need to use a profile that supports turn costs\nThe following profiles do support turn costs: " + this.getTurnCostProfiles());
            }
            if (this.request.getCustomModel() != null && !(this.profile instanceof CustomProfile)) {
                throw new IllegalArgumentException("The requested profile '" + this.request.getProfile() + "' cannot be used with `custom_model`, because it has weighting=" + this.profile.getWeighting());
            }
            int uTurnCostsInt = this.request.getHints().getInt("u_turn_costs", -1);
            if (uTurnCostsInt != -1 && !this.profile.isTurnCosts()) {
                throw new IllegalArgumentException("Finite u-turn costs can only be used for edge-based routing, you need to use a profile that supports turn costs. Currently the following profiles that support turn costs are available: " + this.getTurnCostProfiles());
            }
        }

        protected abstract Weighting createWeighting();

        protected EdgeFilter getSnapFilter() {
            return new DefaultSnapFilter(this.weighting, this.lookup.getBooleanEncodedValue(Subnetwork.key(this.profile.getName())));
        }

        protected abstract PathCalculator createPathCalculator(QueryGraph var1);

        private List<String> getTurnCostProfiles() {
            ArrayList<String> turnCostProfiles = new ArrayList<String>();
            for (Profile p : this.profilesByName.values()) {
                if (!p.isTurnCosts()) continue;
                turnCostProfiles.add(p.getName());
            }
            return turnCostProfiles;
        }

        int getMaxVisitedNodes(PMap hints) {
            return hints.getInt("max_visited_nodes", this.routerConfig.getMaxVisitedNodes());
        }
    }
}

