/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Instruction;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;

public class FinishInstruction
extends Instruction {
    public FinishInstruction(String name, final double lat, final double lon, final double ele) {
        super(4, name, new PointList(2, !Double.isNaN(ele)){
            {
                super(cap, is3D);
                this.add(lat, lon, ele);
            }
        });
    }

    public FinishInstruction(final double lat, final double lon, final double ele) {
        super(4, "", new PointList(2, !Double.isNaN(ele)){
            {
                super(cap, is3D);
                this.add(lat, lon, ele);
            }
        });
    }

    public FinishInstruction(String name, PointAccess pointAccess, int node) {
        this(name, pointAccess.getLat(node), pointAccess.getLon(node), pointAccess.is3D() ? pointAccess.getEle(node) : Double.NaN);
    }

    public FinishInstruction(PointAccess pointAccess, int node) {
        this(pointAccess.getLat(node), pointAccess.getLon(node), pointAccess.is3D() ? pointAccess.getEle(node) : Double.NaN);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public String getTurnDescription(Translation tr) {
        if (this.rawName) {
            return this.getName();
        }
        return tr.tr("finish", new Object[0]);
    }
}

